/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __IMPORT_DATA_H__
#define __IMPORT_DATA_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void
    g_ptr_array_free_strings(GPtrArray *array,
    				gboolean free_segment,
				gboolean free_strings);
PyObject *
    python_read_table_block(PyObject *self, PyObject *args, PyObject *keywds);

PyObject *
    python_read_table_lines(PyObject *self, PyObject *args, PyObject *keywds);

PyObject *
    python_read_table_block_string(PyObject *self, PyObject *args, PyObject *keywds);
PyObject *
    python_read_table_lines_string(PyObject *self, PyObject *args, PyObject *keywds);


PyObject
    *python_read_build_array(GArray *array, gint x, gint y);

PyObject 
    *python_read_build_list(GPtrArray *array, gint x, gint y);

GArray *
read_table(gchar *filename,gchar *commentchars,
          gchar *delim, gchar *blockstart,
          gint block, gint beginline, gint endline,
          gint *x,gint *y, GPtrArray **titles);

GPtrArray *
read_table_string(gchar *filename,gchar *commentchars,
          gchar *delim, gchar *blockstart,
          gint block, gint beginline, gint endline,
          gint *x,gint *y, GPtrArray **titles);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
