/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <sg.h>
#include <sg_file_dialog.h>

GtkPlotArray*
sg_array_file(SGpluginArray *plugin, SGapplication *app, gpointer _data)
{
  GtkPlotArray *array;
  GtkWidget *filesel = NULL;
  gboolean rvalue;

  array = GTK_PLOT_ARRAY(g_object_new(gtk_plot_array_get_type(),NULL));
  array->own_data = TRUE;
  array->type = GTK_TYPE_STRING;
  filesel = sg_file_dialog_new(SG_PLUGIN_FILE_IMPORT, app, "sg_array", G_OBJECT(array));
  rvalue = sg_file_dialog_run(filesel);
  if(!rvalue) {
    if(array) g_object_unref(G_OBJECT(array));
    array = NULL;
  }
  return array;
}

