/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
/*
 *  Copyright (c) 1995 Regents of the University of Michigan.
 *  All rights reserved.
 */
/*
 *  charset.c
 */

#include "ldap-int.h"

#ifdef STR_TRANSLATION

void
ldap_set_string_translators( LDAP *ld, BERTranslateProc encode_proc,
	BERTranslateProc decode_proc )
{
	if ( ld == NULL ) {
		if ( !nsldapi_initialized ) {
			nsldapi_initialize_defaults();
		}
		ld = &nsldapi_ld_defaults;
	}

	if ( NSLDAPI_VALID_LDAP_POINTER( ld )) {
		ld->ld_lber_encode_translate_proc = encode_proc;
		ld->ld_lber_decode_translate_proc = decode_proc;
	}
}


void
ldap_enable_translation( LDAP *ld, LDAPMessage *entry, int enable )
{
	char	*optionsp;

	if ( ld == NULL ) {
		if ( !nsldapi_initialized ) {
			nsldapi_initialize_defaults();
		}
		ld = &nsldapi_ld_defaults;
	}

	optionsp = ( entry == NULLMSG ) ? &ld->ld_lberoptions :
	    &entry->lm_ber->ber_options;
		
	if ( enable ) {
		*optionsp |= LBER_OPT_TRANSLATE_STRINGS;
	} else {
		*optionsp &= ~LBER_OPT_TRANSLATE_STRINGS;
	}
}


int
ldap_translate_from_t61( LDAP *ld, char **bufp, unsigned long *lenp,
    int free_input )
{
	if ( ld->ld_lber_decode_translate_proc == NULL ) {
		return( LDAP_SUCCESS );
	}
	    
	return( (*ld->ld_lber_decode_translate_proc)( bufp, lenp, free_input ));
}


int
ldap_translate_to_t61( LDAP *ld, char **bufp, unsigned long *lenp,
    int free_input )
{
	if ( ld->ld_lber_encode_translate_proc == NULL ) {
		return( LDAP_SUCCESS );
	}
	    
	return( (*ld->ld_lber_encode_translate_proc)( bufp, lenp, free_input ));
}


/*
 ** Character translation routine notes:
 *
 * On entry:  bufp points to a "string" to be converted (not necessarily
 *  zero-terminated) and buflenp points to the length of the buffer.
 *
 * On exit:  bufp should point to a malloc'd result.  If free_input is
 *  non-zero then the original bufp will be freed.  *buflenp should be
 *  set to the new length.  Zero bytes in the input buffer must be left
 *  as zero bytes.
 *
 * Return values: any ldap error code (LDAP_SUCCESS if all goes well).
 */


#ifdef LDAP_CHARSET_8859

#if LDAP_CHARSET_8859 == 88591
#define ISO_8859 1
#elif LDAP_CHARSET_8859 == 88592
#define ISO_8859 2
#elif LDAP_CHARSET_8859 == 88593
#define ISO_8859 3
#elif LDAP_CHARSET_8859 == 88594
#define ISO_8859 4
#elif LDAP_CHARSET_8859 == 88595
#define ISO_8859 5
#elif LDAP_CHARSET_8859 == 88596
#define ISO_8859 6
#elif LDAP_CHARSET_8859 == 88597
#define ISO_8859 7
#elif LDAP_CHARSET_8859 == 88598
#define ISO_8859 8
#elif LDAP_CHARSET_8859 == 88599
#define ISO_8859 9
#elif LDAP_CHARSET_8859 == 885910
#define ISO_8859 10
#else
#define ISO_8859 0
#endif

/*
 * the following ISO_8859 to/afrom T.61 character set translation code is
 * based on the code found in Enrique Silvestre Mora's iso-t61.c, found
 * as part of this package:
 *   ftp://pereiii.uji.es/pub/uji-ftp/unix/ldap/iso-t61.translation.tar.Z
 * Enrique is now (10/95) at this address: enrique.silvestre@uv.es
 *
 * changes made by mcs@umich.edu 12 October 1995:
 *   Change calling conventions of iso8859_t61() and t61_iso8859() to
 *	match libldap conventions; rename to ldap_8859_to_t61() and
 *	ldap_t61_to_8859().
 *   Change conversion routines to deal with non-zero terminated strings.
 *   ANSI-ize functions and include prototypes.
 */

/* iso-t61.c - ISO-T61 translation routines (version: 0.2.1, July-1994) */
/*
 * Copyright (c) 1994 Enrique Silvestre Mora, Universitat Jaume I, Spain.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the Universitat Jaume I. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Character set used: ISO 8859-1, ISO 8859-2, ISO 8859-3, ... */
/* #define  ISO_8859      1 */

#ifndef ISO_8859
#  define ISO_8859     0
#endif

typedef unsigned char  Byte;
typedef struct { Byte  a, b; } Couple;

#ifdef NEEDPROTOS
static Byte *c_to_hh( Byte *o, Byte c );
static Byte *c_to_cc( Byte *o, Couple *cc, Byte c );
static int hh_to_c( Byte *h );
static Byte *cc_to_t61( Byte *o, Byte *s );
#else /* NEEDPROTOS */
static Byte *c_to_hh();
static Byte *c_to_cc();
static int hh_to_c();
static Byte *cc_to_t61();
#endif /* NEEDPROTOS */

/*
   Character choosed as base in diacritics alone: NO-BREAK SPACE.
   (The standard say it must be a blank space, 0x20.)
*/
#define  ALONE  0xA0

static Couple diacritic[16] = {
#if (ISO_8859 == 1) || (ISO_8859 == 9)
	{0,0},       {'`',0},     {0xb4,0},    {'^',0},
	{'~',0},     {0xaf,0},    {'(',ALONE}, {'.',ALONE},
	{0xa8,0},    {0,0},       {'0',ALONE}, {0xb8,0},
	{0,0},       {'"',ALONE}, {';',ALONE}, {'<',ALONE},
#elif (ISO_8859 == 2)
	{0,0},       {'`',0},     {0xb4,0},    {'^',0},
	{'~',0},     {'-',ALONE}, {0xa2,0},    {0xff,0},
	{0xa8,0},    {0,0},       {'0',ALONE}, {0xb8,0},
	{0,0},       {0xbd,0},    {0xb2,0},    {0xb7,0}
#elif (ISO_8859 == 3)
	{0,0},       {'`',0},     {0xb4,0},    {'^',0},
	{'~',0},     {'-',ALONE}, {0xa2,0},    {0xff,0},
	{0xa8,0},    {0,0},       {'0',ALONE}, {0xb8,0},
	{0,0},       {'"',ALONE}, {';',ALONE}, {'<',ALONE}
#elif (ISO_8859 == 4)
	{0,0},       {'`',0},     {0xb4,0},    {'^',0},
	{'~',0},     {0xaf,0},    {'(',ALONE}, {0xff,0},
	{0xa8,0},    {0,0},       {'0',ALONE}, {0xb8,0},
	{0,0},       {'"',ALONE}, {0xb2,0},    {0xb7,0}
#else
	{0,0},       {'`',0},     {'\'',ALONE}, {'^',0},
	{'~',0},     {'-',ALONE}, {'(',ALONE},  {'.',ALONE},
	{':',ALONE}, {0,0},       {'0',ALONE},  {',',ALONE},
	{0,0},       {'"',ALONE}, {';',ALONE},  {'<',ALONE}
#endif
};

/*
   --- T.61 (T.51) letters with diacritics: conversion to ISO 8859-n -----
       A,   C,   D,   E,   G,   H,   I,   J,   K,
       L,   N,   O,   R,   S,   T,   U,   W,   Y,   Z.
   -----------------------------------------------------------------------
*/
static int letter_w_diacritic[16][38] = {
#if (ISO_8859 == 1)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc0,0,   0,   0xc8,0,   0,   0xcc,0,   0,
	0,   0,   0xd2,0,   0,   0,   0xd9,0,   0,   0,
	0xe0,0,   0,   0xe8,0,   0,   0xec,0,   0,
	0,   0,   0xf2,0,   0,   0,   0xf9,0,   0,   0,
	0xc1,-1,  0,   0xc9,0,   0,   0xcd,0,   0,
	-1,  -1,  0xd3,-1,  -1,  0,   0xda,0,   0xdd,-1,
	0xe1,-1,  0,   0xe9,0,   0,   0xed,0,   0,
	-1,  -1,  0xf3,-1,  -1,  0,   0xfa,0,   0xfd,-1,
	0xc2,-1,  0,   0xca,-1,  -1,  0xce,-1,  0,
	0,   0,   0xd4,0,   -1,  0,   0xdb,-1,  -1,  0,
	0xe2,-1,  0,   0xea,-1,  -1,  0xee,-1,  0,
	0,   0,   0xf4,0,   -1,  0,   0xfb,-1,  -1,  0,
	0xc3,0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xd1,0xd5,0,   0,   0,   -1,  0,   0,   0,
	0xe3,0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xf1,0xf5,0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   -1,  -1,  0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0,   -1,  0,   -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0xc4,0,   0,   0xcb,0,   0,   0xcf,0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   0xef,0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   0xff,0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xe5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   0xc7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   0xe7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1
#elif (ISO_8859 == 2)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xc1,0xc6,0,   0xc9,0,   0,   0xcd,0,   0,
	0xc5,0xd1,0xd3,0xc0,0xa6,0,   0xda,0,   0xdd,0xac,
	0xe1,0xe6,0,   0xe9,0,   0,   0xed,0,   0,
	0xe5,0xf1,0xf3,0xe0,0xb6,0,   0xfa,0,   0xfd,0xbc,
	0xc2,-1,  0,   -1,  -1,  -1,  0xce,-1,  0,
	0,   0,   0xd4,0,   -1,  0,   -1,  -1,  -1,  0,
	0xe2,-1,  0,   -1,  -1,  -1,  0xee,-1,  0,
	0,   0,   0xf4,0,   -1,  0,   -1,  -1,  -1,  0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   -1,  -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   -1,  -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xc3,0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xe3,0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   -1,  -1,  0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0xaf,
	0,   -1,  0,   -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0xbf,
	0xc4,0,   0,   0xcb,0,   0,   -1,  0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   -1,  0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   -1,  0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0xd9,0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0xf9,0,   0,   0,
	0,   0xc7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xaa,0xde,0,   0,   0,   0,
	0,   0xe7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xba,0xfe,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0xd5,0,   0,   0,   0xdb,0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0xf5,0,   0,   0,   0xfb,0,   0,   0,
	0xa1,0,   0,   0xca,0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xb1,0,   0,   0xea,0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   0xc8,0xcf,0xcc,0,   0,   0,   0,   0,
	0xa5,0xd2,0,   0xd8,0xa9,0xab,0,   0,   0,   0xae,
	0,   0xe8,0xef,0xec,0,   0,   0,   0,   0,
	0xb5,0xf2,0,   0xf8,0xb9,0xbb,0,   0,   0,   0xbe
#elif (ISO_8859 == 3)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc0,0,   0,   0xc8,0,   0,   0xcc,0,   0,
	0,   0,   0xd2,0,   0,   0,   0xd9,0,   0,   0,
	0xe0,0,   0,   0xe8,0,   0,   0xec,0,   0,
	0,   0,   0xf2,0,   0,   0,   0xf9,0,   0,   0,
	0xc1,-1,  0,   0xc9,0,   0,   0xcd,0,   0,
	-1,  -1,  0xd3,-1,  -1,  0,   0xda,0,   -1,  -1,
	0xe1,-1,  0,   0xe9,0,   0,   0xed,0,   0,
	-1,  -1,  0xf3,-1,  -1,  0,   0xfa,0,   -1,  -1,
	0xc2,0xc6,0,   0xca,0xd8,0xa6,0xce,0xac,0,
	0,   0,   0xd4,0,   0xde,0,   0xdb,-1,  -1,  0,
	0xe2,0xe6,0,   0xea,0xf8,0xb6,0xee,0xbc,0,
	0,   0,   0xf4,0,   0xfe,0,   0xfb,-1,  -1,  0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xd1,-1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xf1,-1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0xab,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0xdd,0,   0,   0,
	-1,  0,   0,   0,   0xbb,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0xfd,0,   0,   0,
	0,   0xc5,0,   -1,  0xd5,0,   0xa9,0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0xaf,
	0,   0xe5,0,   -1,  0xf5,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0xbf,
	0xc4,0,   0,   0xcb,0,   0,   0xcf,0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   0xef,0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   -1,  0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   0xc7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xaa,-1,  0,   0,   0,   0,
	0,   0xe7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xba,-1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1
#elif (ISO_8859 == 4)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xc1,-1,  0,   0xc9,0,   0,   0xcd,0,   0,
	-1,  -1,  -1,  -1,  -1,  0,   0xda,0,   -1,  -1,
	0xe1,-1,  0,   0xe9,0,   0,   0xed,0,   0,
	-1,  -1,  -1,  -1,  -1,  0,   0xfa,0,   -1,  -1,
	0xc2,-1,  0,   -1,  -1,  -1,  0xce,-1,  0,
	0,   0,   0xd4,0,   -1,  0,   0xdb,-1,  -1,  0,
	0xe2,-1,  0,   -1,  -1,  -1,  0xee,-1,  0,
	0,   0,   0xf4,0,   -1,  0,   0xfb,-1,  -1,  0,
	0xc3,0,   0,   0,   0,   0,   0xa5,0,   0,
	0,   -1,  0xd5,0,   0,   0,   0xdd,0,   0,   0,
	0xe3,0,   0,   0,   0,   0,   0xb5,0,   0,
	0,   -1,  0xf5,0,   0,   0,   0xfd,0,   0,   0,
	0xc0,0,   0,   0xaa,0,   0,   0xcf,0,   0,
	0,   0,   0xd2,0,   0,   0,   0xde,0,   0,   0,
	0xe0,0,   0,   0xba,0,   0,   0xef,0,   0,
	0,   0,   0xf2,0,   0,   0,   0xfe,0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   0xcc,-1,  0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0,   -1,  0,   0xec,-1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0xc4,0,   0,   0xcb,0,   0,   -1,  0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   -1,  0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   -1,  0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xe5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   0,   0xab,0,   0,   0,   0xd3,
	0xa6,0xd1,0,   0xa3,-1,  -1,  0,   0,   0,   0,
	0,   -1,  0,   0,   0xbb,0,   0,   0,   0xf3,
	0xb6,0xf1,0,   0xb3,-1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xa1,0,   0,   0xca,0,   0,   0xc7,0,   0,
	0,   0,   0,   0,   0,   0,   0xd9,0,   0,   0,
	0xb1,0,   0,   0xea,0,   0,   0xe7,0,   0,
	0,   0,   0,   0,   0,   0,   0xf9,0,   0,   0,
	0,   0xc8,-1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  0xa9,-1,  0,   0,   0,   0xae,
	0,   0xe8,-1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  0xb9,-1,  0,   0,   0,   0xbe
#elif (ISO_8859 == 9)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc0,0,   0,   0xc8,0,   0,   0xcc,0,   0,
	0,   0,   0xd2,0,   0,   0,   0xd9,0,   0,   0,
	0xe0,0,   0,   0xe8,0,   0,   -1,  0,   0,
	0,   0,   0xf2,0,   0,   0,   0xf9,0,   0,   0,
	0xc1,-1,  0,   0xc9,0,   0,   0xcd,0,   0,
	-1,  -1,  0xd3,-1,  -1,  0,   0xda,0,   -1,  -1,
	0xe1,-1,  0,   0xe9,0,   0,   0xed,0,   0,
	-1,  -1,  0xf3,-1,  -1,  0,   0xfa,0,   -1,  -1,
	0xc2,-1,  0,   0xca,-1,  -1,  0xce,-1,  0,
	0,   0,   0xd4,0,   -1,  0,   0xdb,-1,  -1,  0,
	0xe2,-1,  0,   -1,  -1,  -1,  0xee,-1,  0,
	0,   0,   0xf4,0,   -1,  0,   0xfb,-1,  -1,  0,
	0xc3,0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xd1,0xd5,0,   0,   0,   -1,  0,   0,   0,
	0xe3,0,   0,   0,   0,   0,   -1,  0,   0,
	0,   0xf1,0xf5,0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   0xef,0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0xd0,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0xf0,0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   -1,  -1,  0,   0xdd,0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0,   -1,  0,   0xec,-1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0xc4,0,   0,   0xcb,0,   0,   0xcf,0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   -1,  0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   0xff,0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xe5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   0xc7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xde,-1,  0,   0,   0,   0,
	0,   0xe7,0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  0xfe,-1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0xea,0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1
#elif (ISO_8859 == 10)
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xc1,-1,  0,   0xc9,0,   0,   0xcd,0,   0,
	-1,  -1,  0xd3,-1,  -1,  0,   0xda,0,   0xdd,-1,
	0xe1,-1,  0,   0xe9,0,   0,   0xed,0,   0,
	-1,  -1,  0xf3,-1,  -1,  0,   0xfa,0,   0xfd,-1,
	0xc2,-1,  0,   -1,  -1,  -1,  0xce,-1,  0,
	0,   0,   0xd4,0,   -1,  0,   0xdb,-1,  -1,  0,
	0xe2,-1,  0,   -1,  -1,  -1,  0xee,-1,  0,
	0,   0,   0xf4,0,   -1,  0,   0xfb,-1,  -1,  0,
	0xc3,0,   0,   0,   0,   0,   0xa5,0,   0,
	0,   -1,  0xd5,0,   0,   0,   0xd7,0,   0,   0,
	0xe3,0,   0,   0,   0,   0,   0xb5,0,   0,
	0,   -1,  0xf5,0,   0,   0,   0xf7,0,   0,   0,
	0xc0,0,   0,   0xa2,0,   0,   0xa4,0,   0,
	0,   0,   0xd2,0,   0,   0,   0xae,0,   0,   0,
	0xe0,0,   0,   0xb2,0,   0,   0xb4,0,   0,
	0,   0,   0xf2,0,   0,   0,   0xbe,0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   0xcc,-1,  0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0,   -1,  0,   0xec,-1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0xc4,0,   0,   0xcb,0,   0,   0xcf,0,   0,
	0,   0,   0xd6,0,   0,   0,   0xdc,0,   -1,  0,
	0xe4,0,   0,   0xeb,0,   0,   0xef,0,   0,
	0,   0,   0xf6,0,   0,   0,   0xfc,0,   -1,  0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0xc5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0xe5,0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   0,   0xa3,0,   0,   0,   0xa6,
	0xa8,0xd1,0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   -1,  0,   0,   0xb3,0,   0,   0,   0xb6,
	0xb8,0xf1,0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0xa1,0,   0,   0xca,0,   0,   0xc7,0,   0,
	0,   0,   0,   0,   0,   0,   0xd9,0,   0,   0,
	0xb1,0,   0,   0xea,0,   0,   0xe7,0,   0,
	0,   0,   0,   0,   0,   0,   0xf9,0,   0,   0,
	0,   0xc8,-1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  0xaa,-1,  0,   0,   0,   0xac,
	0,   0xe8,-1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  0xba,-1,  0,   0,   0,   0xbc
#else
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  -1,  0,   -1,  0,   0,   -1,  0,   0,
	-1,  -1,  -1,  -1,  -1,  0,   -1,  0,   -1,  -1,
	-1,  -1,  0,   -1,  0,   0,   -1,  0,   0,
	-1,  -1,  -1,  -1,  -1,  0,   -1,  0,   -1,  -1,
	-1,  -1,  0,   -1,  -1,  -1,  -1,  -1,  0,
	0,   0,   -1,  0,   -1,  0,   -1,  -1,  -1,  0,
	-1,  -1,  0,   -1,  -1,  -1,  -1,  -1,  0,
	0,   0,   -1,  0,   -1,  0,   -1,  -1,  -1,  0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   -1,  -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0,   0,   -1,  0,   0,
	0,   -1,  -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   -1,  -1,  0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	0,   -1,  0,   -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   -1,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   -1,  0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   -1,  0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   -1,  0,   0,   -1,  0,   0,   0,   -1,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   -1,  0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	-1,  0,   0,   -1,  0,   0,   -1,  0,   0,
	0,   0,   0,   0,   0,   0,   -1,  0,   0,   0,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1,
	0,   -1,  -1,  -1,  0,   0,   0,   0,   0,
	-1,  -1,  0,   -1,  -1,  -1,  0,   0,   0,   -1
#endif
};

/*
--- T.61 characters [0xA0 .. 0xBF] -----------------
*/
static Couple trans_t61a_iso8859[32] = {
#if (ISO_8859 == 1) || (ISO_8859 == 9)
	{'N','S'}, {0xa1,0},  {0xa2,0},  {0xa3,0},
	{'D','O'}, {0xa5,0},  {'C','u'}, {0xa7,0},
	{0xa4,0},  {'\'','6'},{'"','6'}, {0xab,0},
	{'<','-'}, {'-','!'}, {'-','>'}, {'-','v'},
	{0xb0,0},  {0xb1,0},  {0xb2,0},  {0xb3,0},
	{0xd7,0},  {0xb5,0},  {0xb6,0},  {0xb7,0},
	{0xf7,0},  {'\'','9'},{'"','9'}, {0xbb,0},
	{0xbc,0},  {0xbd,0},  {0xbe,0},  {0xbf,0}
#elif (ISO_8859 == 2) || (ISO_8859 == 4)
	{'N','S'}, {'!','I'}, {'C','t'}, {'P','d'},
	{'D','O'}, {'Y','e'}, {'C','u'}, {0xa7,0},
	{0xa4,0},  {'\'','6'},{'"','6'}, {'<','<'},
	{'<','-'}, {'-','!'}, {'-','>'}, {'-','v'},
	{0xb0,0},  {'+','-'}, {'2','S'}, {'3','S'},
	{0xd7,0},  {'M','y'}, {'P','I'}, {'.','M'},
	{0xf7,0},  {'\'','9'},{'"','9'}, {'>','>'},
	{'1','4'}, {'1','2'}, {'3','4'}, {'?','I'},
#elif (ISO_8859 == 3)
	{'N','S'}, {'!','I'}, {'C','t'}, {0xa3,0},
	{'D','O'}, {'Y','e'}, {'C','u'}, {0xa7,0},
	{0xa4,0},  {'\'','6'},{'"','6'}, {'<','<'},
	{'<','-'}, {'-','!'}, {'-','>'}, {'-','v'},
	{0xb0,0},  {'+','-'}, {0xb2,0},  {0xb3,0},
	{0xd7,0},  {0xb5,0},  {'P','I'}, {0xb7,0},
	{0xf7,0},  {'\'','9'},{'"','9'}, {'>','>'},
	{'1','4'}, {0xbd,0},  {'3','4'}, {'?','I'}
#elif (ISO_8859 == 10)
	{'N','S'}, {'!','I'}, {'C','t'}, {'P','d'},
	{'D','O'}, {'Y','e'}, {'C','u'}, {0xa7,0},
	{'C','u'}, {'\'','6'},{'"','6'}, {'<','<'},
	{'<','-'}, {'-','!'}, {'-','>'}, {'-','v'},
	{0xb0,0},  {'+','-'}, {'2','S'}, {'3','S'},
	{'*','X'}, {'M','y'}, {'P','I'}, {0xb7,0},
	{'-',':'}, {'\'','9'},{'"','9'}, {'>','>'},
	{'1','4'}, {'1','2'}, {'3','4'}, {'?','I'}
#else
	{'N','S'}, {'!','I'}, {'C','t'}, {'P','d'},
	{'D','O'}, {'Y','e'}, {'C','u'}, {'S','E'},
	{'X','O'}, {'\'','6'},{'"','6'}, {'<','<'},
	{'<','-'}, {'-','!'}, {'-','>'}, {'-','v'},
	{'D','G'}, {'+','-'}, {'2','S'}, {'3','S'},
	{'*','X'}, {'M','y'}, {'P','I'}, {'.','M'},
	{'-',':'}, {'\'','9'},{'"','9'}, {'>','>'},
	{'1','4'}, {'1','2'}, {'3','4'}, {'?','I'}
#endif
};

/*
--- T.61 characters [0xE0 .. 0xFF] -----------------
*/
static Couple trans_t61b_iso8859[48] = {
#if (ISO_8859 == 1)
	{'-','M'}, {0xb9,0},  {0xae,0},  {0xa9,0},
	{'T','M'}, {'M','8'}, {0xac,0},  {0xa6,0},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {0xc6,0},  {0xd0,0},  {0xaa,0},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {0xd8,0},  {'O','E'}, {0xba,0},
	{0xde,0},  {'T','/'}, {'N','G'}, {'\'','n'},
	{'k','k'}, {0xe6,0},  {'d','/'}, {0xf0,0},
	{'h','/'}, {'i','.'}, {'i','j'}, {'l','.'},
	{'l','/'}, {0xf8,0},  {'o','e'}, {0xdf,0},
	{0xfe,0},  {'t','/'}, {'n','g'}, {'-','-'}
#elif (ISO_8859 == 2)
	{'-','M'}, {'1','S'}, {'R','g'}, {'C','o'},
	{'T','M'}, {'M','8'}, {'N','O'}, {'B','B'},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {'A','E'}, {0xd0,0},  {'-','a'},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{0xa3,0},  {'O','/'}, {'O','E'}, {'-','o'},
	{'T','H'}, {'T','/'}, {'N','G'}, {'\'','n'},
	{'k','k'}, {'a','e'}, {0xf0,0},  {'d','-'},
	{'h','/'}, {'i','.'}, {'i','j'}, {'l','.'},
	{0xb3,0},  {'o','/'}, {'o','e'}, {0xdf,0},
	{'t','h'}, {'t','/'}, {'n','g'}, {'-','-'}
#elif (ISO_8859 == 3)
	{'-','M'}, {'1','S'}, {'R','g'}, {'C','o'},
	{'T','M'}, {'M','8'}, {'N','O'}, {'B','B'},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {'A','E'}, {'D','/'}, {'-','a'},
	{0xa1,0},  {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {'O','/'}, {'O','E'}, {'-','o'},
	{'T','H'}, {'T','/'}, {'N','G'}, {'\'','n'},
	{'k','k'}, {'a','e'}, {'d','/'}, {'d','-'},
	{0xb1,0},  {0xb9,0},  {'i','j'}, {'l','.'},
	{'l','/'}, {'o','/'}, {'o','e'}, {0xdf,0},
	{'t','h'}, {'t','/'}, {'n','g'}, {'-','-'}
#elif (ISO_8859 == 4)
	{'-','M'}, {'1','S'}, {'R','g'}, {'C','o'},
	{'T','M'}, {'M','8'}, {'N','O'}, {'B','B'},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {0xc6,0},  {0xd0,0},  {'-','a'},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {0xd8,0},  {'O','E'}, {'-','o'},
	{'T','H'}, {0xac,0},  {0xbd,0},  {'\'','n'},
	{0xa2,0},  {0xe6,0},  {0xf0,0},  {'d','-'},
	{'h','/'}, {'i','.'}, {'i','j'}, {'l','.'},
	{'l','/'}, {0xf8,0},  {'o','e'}, {0xdf,0},
	{'t','h'}, {0xbc,0},  {0xbf,0},  {'-','-'}
#elif (ISO_8859 == 9)
	{'-','M'}, {0xb9,0},  {0xae,0},  {0xa9,0},
	{'T','M'}, {'M','8'}, {0xac,0},  {0xa6,0},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {0xc6,0},  {'D','/'}, {0xaa,0},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {0xd8,0},  {'O','E'}, {0xba,0},
	{'T','H'}, {'T','/'}, {'N','G'}, {'\'','n'},
	{'k','k'}, {0xe6,0},  {'d','/'}, {'d','-'},
	{'h','/'}, {0xfd,0},  {'i','j'}, {'l','.'},
	{'l','/'}, {0xf8,0},  {'o','e'}, {0xdf,0},
	{'t','h'}, {'t','/'}, {'n','g'}, {'-','-'}
#elif (ISO_8859 == 10)
	{0xbd,0},  {'1','S'}, {'R','g'}, {'C','o'},
	{'T','M'}, {'M','8'}, {'N','O'}, {'B','B'},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {0xc6,0},  {0xa9,0},  {'-','a'},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {0xd8,0},  {'O','E'}, {'-','o'},
	{0xde,0},  {0xab,0},  {0xaf,0},  {'\'','n'},
	{0xff,0},  {0xe6,0},  {0xb9,0},  {0xf0,0},
	{'h','/'}, {'i','.'}, {'i','j'}, {'l','.'},
	{'l','/'}, {0xf8,0},  {'o','e'}, {0xdf,0},
	{0xfe,0},  {0xbb,0},  {0xbf,0},  {'-','-'}
#else
	{'-','M'}, {'1','S'}, {'R','g'}, {'C','o'},
	{'T','M'}, {'M','8'}, {'N','O'}, {'B','B'},
	{0,0},     {0,0},     {0,0},     {0,0},
	{'1','8'}, {'3','8'}, {'5','8'}, {'7','8'},
	{'O','m'}, {'A','E'}, {'D','/'}, {'-','a'},
	{'H','/'}, {0,0},     {'I','J'}, {'L','.'},
	{'L','/'}, {'O','/'}, {'O','E'}, {'-','o'},
	{'T','H'}, {'T','/'}, {'N','G'}, {'\'','n'},
	{'k','k'}, {'a','e'}, {'d','/'}, {'d','-'},
	{'h','/'}, {'i','.'}, {'i','j'}, {'l','.'},
	{'l','/'}, {'o','/'}, {'o','e'}, {'s','s'},
	{'t','h'}, {'t','-'}, {'n','g'}, {'-','-'}
#endif
};

/*
--- ISO 8859-n characters <0xA0 .. 0xFF> -------------------
*/
#if (ISO_8859 == 1)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xa1,0},     {0xa2,0},     {0xa3,0},
	{0xa8,0},     {0xa5,0},     {0xd7,0},     {0xa7,0},
	{0xc8,ALONE}, {0xd3,0},     {0xe3,0},     {0xab,0},
	{0xd6,0},     {0xff,0},     {0xd2,0},     {0xc5,ALONE},
	{0xb0,0},     {0xb1,0},     {0xb2,0},     {0xb3,0},
	{0xc2,ALONE}, {0xb5,0},     {0xb6,0},     {0xb7,0},
	{0xcb,ALONE}, {0xd1,0},     {0xeb,0},     {0xbb,0},
	{0xbc,0},     {0xbd,0},     {0xbe,0},     {0xbf,0},
	{0xc1,'A'},   {0xc2,'A'},   {0xc3,'A'},   {0xc4,'A'},
	{0xc8,'A'},   {0xca,'A'},   {0xe1,0},     {0xcb,'C'},
	{0xc1,'E'},   {0xc2,'E'},   {0xc3,'E'},   {0xc8,'E'},
	{0xc1,'I'},   {0xc2,'I'},   {0xc3,'I'},   {0xc8,'I'},
	{0xe2,0},     {0xc4,'N'},   {0xc1,'O'},   {0xc2,'O'},
	{0xc3,'O'},   {0xc4,'O'},   {0xc8,'O'},   {0xb4,0},
	{0xe9,0},     {0xc1,'U'},   {0xc2,'U'},   {0xc3,'U'},
	{0xc8,'U'},   {0xc2,'Y'},   {0xec,0},     {0xfb,0},
	{0xc1,'a'},   {0xc2,'a'},   {0xc3,'a'},   {0xc4,'a'},
	{0xc8,'a'},   {0xca,'a'},   {0xf1,0},     {0xcb,'c'},
	{0xc1,'e'},   {0xc2,'e'},   {0xc3,'e'},   {0xc8,'e'},
	{0xc1,'i'},   {0xc2,'i'},   {0xc3,'i'},   {0xc8,'i'},
	{0xf3,0},     {0xc4,'n'},   {0xc1,'o'},   {0xc2,'o'},
	{0xc3,'o'},   {0xc4,'o'},   {0xc8,'o'},   {0xb8,0},
	{0xf9,0},     {0xc1,'u'},   {0xc2,'u'},   {0xc3,'u'},
	{0xc8,'u'},   {0xc2,'y'},   {0xfc,0},     {0xc8,'y'}
};
#elif (ISO_8859 == 2)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xce,'A'},   {0xc6,ALONE}, {0xe8,0},
	{0xa8,0},     {0xcf,'L'},   {0xc2,'S'},   {0xa7,0},
	{0xc8,ALONE}, {0xcf,'S'},   {0xcb,'S'},   {0xcf,'T'},
	{0xc2,'Z'},   {0xff,0},     {0xcf,'Z'},   {0xc7,'Z'},
	{0xb0,0},     {0xce,'a'},   {0xce,ALONE}, {0xf8,0},
	{0xc2,ALONE}, {0xcf,'l'},   {0xc2,'s'},   {0xcf,ALONE},
	{0xcb,ALONE}, {0xcf,'s'},   {0xcb,'s'},   {0xcf,'t'},
	{0xc2,'z'},   {0xcd,ALONE}, {0xcf,'z'},   {0xc7,'z'},
	{0xc2,'R'},   {0xc2,'A'},   {0xc3,'A'},   {0xc6,'A'},
	{0xc8,'A'},   {0xc2,'L'},   {0xc2,'C'},   {0xcb,'C'},
	{0xcf,'C'},   {0xc2,'E'},   {0xce,'E'},   {0xc8,'E'},
	{0xcf,'E'},   {0xc2,'I'},   {0xc3,'I'},   {0xcf,'D'},
	{0xe2,0},     {0xc2,'N'},   {0xcf,'N'},   {0xc2,'O'},
	{0xc3,'O'},   {0xcd,'O'},   {0xc8,'O'},   {0xb4,0},
	{0xcf,'R'},   {0xca,'U'},   {0xc2,'U'},   {0xcd,'U'},
	{0xc8,'U'},   {0xc2,'Y'},   {0xcb,'T'},   {0xfb,0},
	{0xc2,'r'},   {0xc2,'a'},   {0xc3,'a'},   {0xc6,'a'},
	{0xc8,'a'},   {0xc2,'l'},   {0xc2,'c'},   {0xcb,'c'},
	{0xcf,'c'},   {0xc2,'e'},   {0xce,'e'},   {0xc8,'e'},
	{0xcf,'e'},   {0xc2,'i'},   {0xc3,'i'},   {0xcf,'d'},
	{0xf2,0},     {0xc2,'n'},   {0xcf,'n'},   {0xc2,'o'},
	{0xc3,'o'},   {0xcd,'o'},   {0xc8,'o'},   {0xb8,0},
	{0xcf,'r'},   {0xca,'u'},   {0xc2,'u'},   {0xcd,'u'},
	{0xc8,'u'},   {0xc2,'y'},   {0xcb,'t'},   {0xc7,ALONE}
};
#elif (ISO_8859 == 3)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xe4,0},     {0xc6,ALONE}, {0xa3,0},
	{0xa8,0},     {0,0},        {0xc3,'H'},   {0xa7,0},
	{0xc8,ALONE}, {0xc7,'I'},   {0xcb,'S'},   {0xc6,'G'},
	{0xc3,'J'},   {0xff,0},     {0,0},        {0xc7,'Z'},
	{0xb0,0},     {0xf4,0},     {0xb2,0},     {0xb3,0},
	{0xc2,ALONE}, {0xb5,0},     {0xc3,'h'},   {0xb7,0},
	{0xcb,ALONE}, {0xf5,0},     {0xcb,'s'},   {0xc6,'g'},
	{0xc3,'j'},   {0xbd,0},     {0,0},        {0xc7,'z'},
	{0xc1,'A'},   {0xc2,'A'},   {0xc3,'A'},   {0,0},
	{0xc8,'A'},   {0xc7,'C'},   {0xc3,'C'},   {0xcb,'C'},
	{0xc1,'E'},   {0xc2,'E'},   {0xc3,'E'},   {0xc8,'E'},
	{0xc1,'I'},   {0xc2,'I'},   {0xc3,'I'},   {0xc8,'I'},
	{0,0},        {0xc4,'N'},   {0xc1,'O'},   {0xc2,'O'},
	{0xc3,'O'},   {0xc7,'G'},   {0xc8,'O'},   {0xb4,0},
	{0xc3,'G'},   {0xc1,'U'},   {0xc2,'U'},   {0xc3,'U'},
	{0xc8,'U'},   {0xc6,'U'},   {0xc3,'S'},   {0xfb,0},
	{0xc1,'a'},   {0xc2,'a'},   {0xc3,'a'},   {0,0},
	{0xc8,'a'},   {0xc7,'c'},   {0xc3,'c'},   {0xcb,'c'},
	{0xc1,'e'},   {0xc2,'e'},   {0xc3,'e'},   {0xc8,'e'},
	{0xc1,'i'},   {0xc2,'i'},   {0xc3,'i'},   {0xc8,'i'},
	{0,0},        {0xc4,'n'},   {0xc1,'o'},   {0xc2,'o'},
	{0xc3,'o'},   {0xc7,'g'},   {0xc8,'o'},   {0xb8,0},
	{0xc3,'g'},   {0xc1,'u'},   {0xc2,'u'},   {0xc3,'u'},
	{0xc8,'u'},   {0xc6,'u'},   {0xc3,'s'},   {0xc7,ALONE}
};
#elif (ISO_8859 == 4)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xce,'A'},   {0xf0,0},     {0xcb,'R'},
	{0xa8,0},     {0xc4,'I'},   {0xcb,'L'},   {0xa7,0},
	{0xc8,ALONE}, {0xcf,'S'},   {0xc5,'E'},   {0xcb,'G'},
	{0xed,0},     {0xff,0},     {0xcf,'Z'},   {0xc5,ALONE},
	{0xb0,0},     {0xce,'a'},   {0xce,ALONE}, {0xcb,'r'},
	{0xc2,ALONE}, {0xc4,'i'},   {0xcb,'l'},   {0xcf,ALONE},
	{0xcb,ALONE}, {0xcf,'s'},   {0xc5,'e'},   {0xcb,'g'},
	{0xfd,0},     {0xee,0},     {0xcf,'z'},   {0xfe,0},
	{0xc5,'A'},   {0xc2,'A'},   {0xc3,'A'},   {0xc4,'A'},
	{0xc8,'A'},   {0xca,'A'},   {0xe1,0},     {0xce,'I'},
	{0xcf,'C'},   {0xc2,'E'},   {0xce,'E'},   {0xc8,'E'},
	{0xc7,'E'},   {0xc2,'I'},   {0xc3,'I'},   {0xc5,'I'},
	{0xe2,0},     {0xcb,'N'},   {0xc5,'O'},   {0xcb,'K'},
	{0xc3,'O'},   {0xc4,'O'},   {0xc8,'O'},   {0xb4,0},
	{0xe9,0},     {0xce,'U'},   {0xc2,'U'},   {0xc3,'U'},
	{0xc8,'U'},   {0xc4,'U'},   {0xc5,'U'},   {0xfb,0},
	{0xc5,'a'},   {0xc2,'a'},   {0xc3,'a'},   {0xc4,'a'},
	{0xc8,'a'},   {0xca,'a'},   {0xf1,0},     {0xce,'i'},
	{0xcf,'c'},   {0xc2,'e'},   {0xce,'e'},   {0xc8,'e'},
	{0xc7,'e'},   {0xc2,'i'},   {0xc3,'i'},   {0xc5,'i'},
	{0xf2,0},     {0xcb,'n'},   {0xc5,'o'},   {0xcb,'k'},
	{0xc3,'o'},   {0xc4,'o'},   {0xc8,'o'},   {0xb8,0},
	{0xf9,0},     {0xce,'u'},   {0xc2,'u'},   {0xc3,'u'},
	{0xc8,'u'},   {0xc4,'u'},   {0xc5,'u'},   {0xc7,ALONE}
};
#elif (ISO_8859 == 9)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xa1,0},     {0xa2,0},     {0xa3,0},
	{0xa8,0},     {0xa5,0},     {0xd7,0},     {0xa7,0},
	{0xc8,ALONE}, {0xd3,0},     {0xe3,0},     {0xab,0},
	{0xd6,0},     {0xff,0},     {0xd2,0},     {0xc5,ALONE},
	{0xb0,0},     {0xb1,0},     {0xb2,0},     {0xb3,0},
	{0xc2,ALONE}, {0xb5,0},     {0xb6,0},     {0xb7,0},
	{0xcb,ALONE}, {0xd1,0},     {0xeb,0},     {0xbb,0},
	{0xbc,0},     {0xbd,0},     {0xbe,0},     {0xbf,0},
	{0xc1,'A'},   {0xc2,'A'},   {0xc3,'A'},   {0xc4,'A'},
	{0xc8,'A'},   {0xca,'A'},   {0xe1,0},     {0xcb,'C'},
	{0xc1,'E'},   {0xc2,'E'},   {0xc3,'E'},   {0xc8,'E'},
	{0xc1,'I'},   {0xc2,'I'},   {0xc3,'I'},   {0xc8,'I'},
	{0xc6,'G'},   {0xc4,'N'},   {0xc1,'O'},   {0xc2,'O'},
	{0xc3,'O'},   {0xc4,'O'},   {0xc8,'O'},   {0xb4,0},
	{0xe9,0},     {0xc1,'U'},   {0xc2,'U'},   {0xc3,'U'},
	{0xc8,'U'},   {0xc7,'I'},   {0xcb,'S'},   {0xfb,0},
	{0xc1,'a'},   {0xc2,'a'},   {0xc3,'a'},   {0xc4,'a'},
	{0xc8,'a'},   {0xca,'a'},   {0xf1,0},     {0xcb,'c'},
	{0xc1,'e'},   {0xc2,'e'},   {0xce,'e'},   {0xc8,'e'},
	{0xc7,'e'},   {0xc2,'i'},   {0xc3,'i'},   {0xc5,'i'},
	{0xc6,'g'},   {0xc4,'n'},   {0xc1,'o'},   {0xc2,'o'},
	{0xc3,'o'},   {0xc4,'o'},   {0xc8,'o'},   {0xb8,0},
	{0xf9,0},     {0xc1,'u'},   {0xc2,'u'},   {0xc3,'u'},
	{0xc8,'u'},   {0xf5,0},     {0xcb,'s'},   {0xc8,'y'}
};
#elif (ISO_8859 == 10)
static Couple trans_iso8859_t61[96] = {
	{0xa0,0},     {0xce,'A'},   {0xc5,'E'},   {0xcb,'G'},
	{0xc5,'I'},   {0xc4,'I'},   {0xcb,'K'},   {0xa7,0},
	{0xcb,'L'},   {0xe2,0},     {0xcf,'S'},   {0xed,0},
	{0xcf,'Z'},   {0xff,0},     {0xc5,'U'},   {0xee,0},
	{0xb0,0},     {0xce,'a'},   {0xc5,'e'},   {0xcb,'g'},
	{0xc5,'i'},   {0xc4,'i'},   {0xcb,'k'},   {0xb7,0},
	{0xcb,'l'},   {0xf2,0},     {0xcf,'s'},   {0xfd,0},
	{0xcf,'z'},   {0xd0,0},     {0xc5,'u'},   {0xfe,0},
	{0xc5,'A'},   {0xc2,'A'},   {0xc3,'A'},   {0xc4,'A'},
	{0xc8,'A'},   {0xca,'A'},   {0xe1,0},     {0xce,'I'},
	{0xcf,'C'},   {0xc2,'E'},   {0xce,'E'},   {0xc8,'E'},
	{0xc7,'E'},   {0xc2,'I'},   {0xc3,'I'},   {0xc8,'I'},
	{0,0},        {0xcb,'N'},   {0xc5,'O'},   {0xc2,'O'},
	{0xc3,'O'},   {0xc4,'O'},   {0xc8,'O'},   {0xc4,'U'},
	{0xe9,0},     {0xce,'U'},   {0xc2,'U'},   {0xc3,'U'},
	{0xc8,'U'},   {0xc2,'Y'},   {0xec,0},     {0xfb,0},
	{0xc5,'a'},   {0xc2,'a'},   {0xc3,'a'},   {0xc4,'a'},
	{0xc8,'a'},   {0xca,'a'},   {0xf1,0},     {0xce,'i'},
	{0xcf,'c'},   {0xc2,'e'},   {0xce,'e'},   {0xc8,'e'},
	{0xc7,'e'},   {0xc2,'i'},   {0xc3,'i'},   {0xc8,'i'},
	{0xf3,0},     {0xcb,'n'},   {0xc5,'o'},   {0xc2,'o'},
	{0xc3,'o'},   {0xc4,'o'},   {0xc8,'o'},   {0xc4,'u'},
	{0xf9,0},     {0xce,'u'},   {0xc2,'u'},   {0xc3,'u'},
	{0xc8,'u'},   {0xc2,'y'},   {0xfc,0},     {0xf0,0}
};
#endif


static Byte *
c_to_hh( Byte *o, Byte c )
{
  Byte n;

  *o++ = '{'; *o++ = 'x';
  n = c >> 4;
  *o++ = ((n < 0xA) ? '0' : 'A' - 0xA) + n;
  n = c & 0x0F;
  *o++ = ((n < 0xA) ? '0' : 'A' - 0xA) + n;
  *o++ = '}';
  return o;
}


static Byte *
c_to_cc( Byte *o, Couple *cc, Byte c )
{
  if ( (*cc).a != 0 ) {
    if ( (*cc).b == 0 )
      *o++ = (*cc).a;
    else {
      *o++ = '{';
      *o++ = (*cc).a;
      *o++ = (*cc).b;
      *o++ = '}';
    }
    return o;
  }
  else
    return c_to_hh( o, c );
}

/* --- routine to convert from T.61 to ISO 8859-n --- */

int
ldap_t61_to_8859( char **bufp, unsigned long *buflenp, int free_input )
{
  Byte		*s, *oo, *o;
  unsigned int  n;
  int           c;
  unsigned long len;
  Couple        *cc;

  LDAPDebug( LDAP_DEBUG_TRACE, "ldap_t61_to_8859 input length: %ld\n",
	*buflenp, 0, 0 );

  len = *buflenp;
  s = (Byte *) *bufp;

  if ( (o = oo = (Byte *)NSLDAPI_MALLOC( 2 * len + 64 )) == NULL ) {
        return( 1 );
  }

  while ( (char *)s - *(char **)bufp < len ) {
    switch ( *s >> 4 ) {

    case 0xA: case 0xB:
      o = c_to_cc( o, &trans_t61a_iso8859[ *s - 0xA0 ], *s );
      s++;
      break;

    case 0xD: case 0xE: case 0xF:
      o = c_to_cc( o, &trans_t61b_iso8859[ *s - 0xD0 ], *s );
      s++;
      break;

    case 0xC:
      if ( (*s == 0xC0) || (*s == 0xC9) || (*s == 0xCC) ) {
        o = c_to_hh( o, *s++ );
        break;
      }

      n = (*s++) - 0xC0;
      switch ( *s ) {

      case 'A':  c = letter_w_diacritic[n][0]; break;
      case 'C':  c = letter_w_diacritic[n][1]; break;
      case 'D':  c = letter_w_diacritic[n][2]; break;
      case 'E':  c = letter_w_diacritic[n][3]; break;
      case 'G':  c = letter_w_diacritic[n][4]; break;
      case 'H':  c = letter_w_diacritic[n][5]; break;
      case 'I':  c = letter_w_diacritic[n][6]; break;
      case 'J':  c = letter_w_diacritic[n][7]; break;
      case 'K':  c = letter_w_diacritic[n][8]; break;
      case 'L':  c = letter_w_diacritic[n][9]; break;
      case 'N':  c = letter_w_diacritic[n][10]; break;
      case 'O':  c = letter_w_diacritic[n][11]; break;
      case 'R':  c = letter_w_diacritic[n][12]; break;
      case 'S':  c = letter_w_diacritic[n][13]; break;
      case 'T':  c = letter_w_diacritic[n][14]; break;
      case 'U':  c = letter_w_diacritic[n][15]; break;
      case 'W':  c = letter_w_diacritic[n][16]; break;
      case 'Y':  c = letter_w_diacritic[n][17]; break;
      case 'Z':  c = letter_w_diacritic[n][18]; break;

      case 'a':  c = letter_w_diacritic[n][19]; break;
      case 'c':  c = letter_w_diacritic[n][20]; break;
      case 'd':  c = letter_w_diacritic[n][21]; break;
      case 'e':  c = letter_w_diacritic[n][22]; break;
      case 'g':  c = letter_w_diacritic[n][23]; break;
      case 'h':  c = letter_w_diacritic[n][24]; break;
      case 'i':  c = letter_w_diacritic[n][25]; break;
      case 'j':  c = letter_w_diacritic[n][26]; break;
      case 'k':  c = letter_w_diacritic[n][27]; break;
      case 'l':  c = letter_w_diacritic[n][28]; break;
      case 'n':  c = letter_w_diacritic[n][29]; break;
      case 'o':  c = letter_w_diacritic[n][30]; break;
      case 'r':  c = letter_w_diacritic[n][31]; break;
      case 's':  c = letter_w_diacritic[n][32]; break;
      case 't':  c = letter_w_diacritic[n][33]; break;
      case 'u':  c = letter_w_diacritic[n][34]; break;
      case 'w':  c = letter_w_diacritic[n][35]; break;
      case 'y':  c = letter_w_diacritic[n][36]; break;
      case 'z':  c = letter_w_diacritic[n][37]; break;

      case ALONE:  c = (( !diacritic[n].b ) ? diacritic[n].a : -1);
                   break;

      default:   c = 0;
      }

      if ( c > 0 ) {
        *o++ = c;  s++;
      } else {
        *o++ = '{';
        if ( c == -1 ) {
          *o++ = ( ( *s == ALONE ) ? ' ' : *s );
          s++;
        } else {
          *o++ = '"';
        }
        *o++ = diacritic[n].a;
        *o++ = '}';
      }
      break;

#if (ISO_8859 == 0)
    case 0x8: case 0x9:
      *o++ = 0x1B; /* <ESC> */
      *o++ = *s++ - 0x40;
      break;
#endif

      default:
        *o++ = *s++;
    }
  }

  len = o - oo;
  o = oo;

  if ( (oo = (Byte *)NSLDAPI_REALLOC( o, len )) == NULL ) {
    NSLDAPI_FREE( o );
    return( 1 );
  }

  if ( free_input ) {
    NSLDAPI_FREE( *bufp );
  }
  *bufp = (char *) oo;
  *buflenp = len;
  return( 0 );
}


static int
hh_to_c( Byte *h )
{
  Byte c;

  if ( (*h >= '0') && (*h <= '9') )      c = *h++ - '0';
  else if ( (*h >= 'A') && (*h <= 'F') ) c = *h++ - 'A' + 10;
  else if ( (*h >= 'a') && (*h <= 'f') ) c = *h++ - 'a' + 10;
  else return -1;

  c <<= 4;

  if ( (*h >= '0') && (*h <= '9') )      c |= *h - '0';
  else if ( (*h >= 'A') && (*h <= 'F') ) c |= *h - 'A' + 10;
  else if ( (*h >= 'a') && (*h <= 'f') ) c |= *h - 'a' + 10;
  else return -1;

  return c;
}


static Byte *
cc_to_t61( Byte *o, Byte *s )
{
  int n, c = 0;

  switch ( *(s + 1) ) {

  case '`':  c = -1;   break;    /* <grave-accent> */

  case '!':
    switch ( *s ) {
    case '!':  c = 0x7C;  break;  /* <vertical-line> */
    case '(':  c = 0x7B;  break;  /* <left-curly-bracket> */
    case '-':  c = 0xAD;  break;  /* <upwards-arrow> */
    default:   c = -1;            /* <grave-accent> */
    }
    break;

#if (ISO_8859 == 1) || (ISO_8859 == 2) || (ISO_8859 == 3) || \
    (ISO_8859 == 4) || (ISO_8859 == 9)
  case 0xB4:
#endif
  case '\'': c = -2;  break;    /* <acute-accent> */

  case '^':  c = -3;  break;    /* <circumflex-acent> */

  case '>':
    switch ( *s ) {
    case ')':  c = 0x5D;  break;  /* <right-square-bracket> */
    case '>':  c = 0xBB;  break;  /* <right-angle-quotation> */
    case '-':  c = 0xAE;  break;  /* <rightwards-arrow> */
    default:   c = -3;            /* <circumflex-acent> */
    }
    break;

  case '~':
  case '?':  c = -4;  break;        /* <tilde> */

#if (ISO_8859 == 1) || (ISO_8859 == 4) || (ISO_8859 == 9)
  case 0xAF:  c = -5;  break;       /* <macron> */
#endif

  case '-':
    switch ( *s ) {
    case '-':  c = 0xFF; break; /* <soft-hyphen> */
    case '<':  c = 0xAC; break; /* <leftwards arrow> */
    case '+':  c = 0xB1; break; /* <plus-minus> */
    case 'd':  c = 0xF3; break; /* <eth> */
    default:   c = -5;          /* <macron> */
    }
    break;

#if (ISO_8859 == 2) || (ISO_8859 == 3)
  case 0xA2:  c = -6;  break;            /* <breve> */
#endif

  case '(':
    if ( *s == '<' ) c = 0x5B;  /* <left-square-bracket> */
    else             c = -6;    /* <breve> */
    break;

#if (ISO_8859 == 2) || (ISO_8859 == 3) || (ISO_8859 == 4)
  case 0xFF:  c = -7;  break;    /* <dot-accent> */
#endif

  case '.':
    switch ( *s ) {
    case 'i':  c = 0xF5; break; /* <dotless-i> */
    case 'L':  c = 0xE7; break; /* <L-middle-dot> */
    case 'l':  c = 0xF7; break; /* <l-middle-dot> */
    default:   c = -7;          /* <dot-accent> */
    }
    break;

#if (ISO_8859 == 1) || (ISO_8859 == 2) || (ISO_8859 == 3) || \
    (ISO_8859 == 4) || (ISO_8859 == 9)
  case 0xA8:  c = -8; break; /* <diaeresis> */
#endif

  case ':':
    if ( *s == '-')  c = 0xB8; /* <division-sign> */
    else             c = -8;   /* <diaeresis> */
    break;

#if (ISO_8859 == 1) || (ISO_8859 == 2) || (ISO_8859 == 3) || \
    (ISO_8859 == 4) || (ISO_8859 == 9) || (ISO_8859 == 10)
  case 0xB0:
#endif
  case '0':  c = -10;  break;  /* <ring-above> */

#if (ISO_8859 == 1) || (ISO_8859 == 2) || (ISO_8859 == 3) || \
    (ISO_8859 == 4) || (ISO_8859 == 9)
  case 0xB8:
#endif
  case ',':  c = -11; break; /* <cedilla> */

#if (ISO_8859 == 2)
  case 0xBD:
#endif
  case '"':  c = -13; break; /* <double-acute-accent> */

#if (ISO_8859 == 2) || (ISO_8859 == 4)
  case 0xB2:
#endif
  case ';':  c = -14; break; /* <ogonek> */

#if (ISO_8859 == 2) || (ISO_8859 == 4)
  case 0xB7:  c = -15;  break;  /* <caron> */
#endif

  case ')':
    if ( *s == '!' )  c = 0x7D;  /* <left-curly-bracket> */
    break;

  case '<':
    if ( *s == '<' )  c = 0xAB;  /* <left-angle-quotation> */
    else              c = -15;   /* <caron> */
    break;

  case '/':
    switch ( *s ) {
    case '/':  c = 0x5C; break; /* <reverse-solidus> */
    case 'D':  c = 0xE2; break; /* <D-stroke> */
    case 'd':  c = 0xF2; break; /* <d-stroke> */
    case 'H':  c = 0xE4; break; /* <H-stroke> */
    case 'h':  c = 0xF4; break; /* <h-stroke> */
    case 'L':  c = 0xE8; break; /* <L-stroke> */
    case 'l':  c = 0xF8; break; /* <l-stroke> */
    case 'O':  c = 0xE9; break; /* <O-stroke> */
    case 'o':  c = 0xF9; break; /* <o-stroke> */
    case 'T':  c = 0xED; break; /* <T-stroke> */
    case 't':  c = 0xFD; break; /* <t-stroke> */
    }
    break;

  case '2':
    if ( *s == '1' )  c = 0xBD;    /* <one-half> */
    break;

  case '4':
    switch ( *s ) {
    case '1':  c = 0xBC; break; /* <one-quarter> */
    case '3':  c = 0xBE; break; /* <three-quarters> */
    }
    break;

  case '6':
    switch ( *s ) {
    case '\'': c = 0xA9; break; /* <left-single-quotation> */
    case '"':  c = 0xAA; break; /* <left-double-quotation> */
    }
    break;

  case '8':
    switch ( *s ) {
    case '1':  c = 0xDC; break; /* <one-eighth> */
    case '3':  c = 0xDD; break; /* <three-eighths> */
    case '5':  c = 0xDE; break; /* <five-eighths> */
    case '7':  c = 0xDF; break; /* <seven-eighths> */
    case 'M':  c = 0xD5; break; /* <eighth-note> */
    }
    break;

  case '9':
    switch ( *s ) {
    case '\'': c = 0xB9; break; /* <right-single-quotation> */
    case '"':  c = 0xBA; break; /* <right-double-quotation> */
    }
    break;

  case 'A':
    if ( *s == 'A' )  c = -10;  /* <ring-above> + <A> */
    break;

  case 'a':
    switch ( *s ) {
    case '-':  c = 0xE3; break; /* <femenine-ordinal-a> */
    case 'a':  c = -10;  break; /* <ring-above> + <a> */
    }
    break;

  case 'B':
    if ( *s == 'B' )  c = 0xD7; /* <broken-bar> */
    break;

  case 'b':
    if ( *s == 'N' )  c = 0xA6;  /* <number-sign> */
    break;

  case 'd':
    if ( *s == 'P' )  c = 0xA3;  /* <pound-sign> */
    break;

  case 'E':
    switch ( *s ) {
    case 'S':  c = 0xA7; break; /* <section-sign> */
    case 'A':  c = 0xE1; break; /* <AE> */
    case 'O':  c = 0xEA; break; /* <OE> */
    }
    break;

  case 'e':
    switch ( *s ) {
    case 'a':  c = 0xF1; break; /* <ae> */
    case 'o':  c = 0xFA; break; /* <oe> */
    case 'Y':  c = 0xA5;  break;  /* <yen-sign> */
    }
    break;

  case 'G':
    switch ( *s ) {
    case 'D':  c = 0xB0; break; /* <degree-sign> */
    case 'N':  c = 0xEE; break; /* <Eng> */
    }
    break;

  case 'g':
    switch ( *s ) {
    case 'R':  c = 0xD2; break;  /* <registered-sign> */
    case 'n':  c = 0xFE; break; /* <eng> */
    }
    break;

  case 'H':
    if ( *s == 'T' )  c = 0xEC;  /* <Thorn> */
    break;

  case 'h':
    if ( *s == 't' )  c = 0xFC; /* <thorn> */
    break;

  case 'I':
    switch ( *s ) {
    case 'P':  c = 0xB6; break;  /* <pilcrow-sign> */
    case '!':  c = 0xA1; break; /* <inverted-exclamation> */
    case '?':  c = 0xBF; break; /* <inverted-question> */
    }
    break;

  case 'J':
    if ( *s == 'I' )  c = 0xE6; /* <IJ> */
    break;

  case 'j':
    if ( *s == 'i' )  c = 0xF6;  /* <ij> */
    break;

  case 'k':
    if ( *s == 'k' )  c = 0xF0; /* <kra> */
    break;

  case 'M':
    switch ( *s ) {
    case '.':  c = 0xB7; break; /* <middle-dot> */
    case '-':  c = 0xD0; break; /* <em-dash> */
    case 'T':  c = 0xD4; break; /* <trade-mark-sign> */
    }
    break;

  case 'm':
    switch ( *s ) {
    case '\'':                  /* <macron> RFC 1345 */
    case ' ':  c = -5;   break; /* <macron> */
    case 'O':  c = 0xE0; break; /* <Ohm sign> */
    }
    break;

  case 'n':
    if ( *s == '\'' )  c = 0xEF; /* <n-preceded-by-apostrophe> */
    break;

  case 'O':
    switch ( *s ) {
    case 'D':  c = 0xA4; break; /* <dollar-sign> */
    case 'N':  c = 0xD6; break; /* <not-sign> */
    }
    break;

  case 'o':
    switch ( *s ) {
    case 'C':  c = 0xD3; break; /* <copyright-sign> */
    case '-':  c = 0xEB; break; /* <masculine-ordinal-o> */
    }
    break;

  case 'S':
    switch ( *s ) {
    case '1':  c = 0xD1; break; /* <superscript-1> */
    case '2':  c = 0xB2; break; /* <superscript-2> */
    case '3':  c = 0xB3; break; /* <superscript-3> */
    case 'N':  c = 0xA0; break; /* <no-break-space> */
    }
    break;

  case 's':
    if ( *s == 's' )  c = 0xFB; /* <sharp-s> */
    break;

  case 't':
    if ( *s == 'C' )  c = 0xA2; /* <cent-sign> */
    break;

  case 'u':
    if ( *s == 'C' )  c = 0xA8; /* <currency-sign> */
    break;

  case 'v':
    if ( *s == '-' )  c = 0xAF; /* <downwards-arrow> */
    break;

  case 'X':
    if ( *s == '*' )  c = 0xB4; /* <multiplication-sign> */
    break;

  case 'y':
    if ( *s == 'M' )  c = 0xB5; /* <micro-sign> */
    break;
  }

  if ( c > 0 ) {
    *o++ = c;
    return o;
  } else if ( !c )
    return NULL;

  /* else: c < 0 */
  n = -c;
  switch ( *s ) {

  case 'A':  c = letter_w_diacritic[n][0]; break;
  case 'C':  c = letter_w_diacritic[n][1]; break;
  case 'D':  c = letter_w_diacritic[n][2]; break;
  case 'E':  c = letter_w_diacritic[n][3]; break;
  case 'G':  c = letter_w_diacritic[n][4]; break;
  case 'H':  c = letter_w_diacritic[n][5]; break;
  case 'I':  c = letter_w_diacritic[n][6]; break;
  case 'J':  c = letter_w_diacritic[n][7]; break;
  case 'K':  c = letter_w_diacritic[n][8]; break;
  case 'L':  c = letter_w_diacritic[n][9]; break;
  case 'N':  c = letter_w_diacritic[n][10]; break;
  case 'O':  c = letter_w_diacritic[n][11]; break;
  case 'R':  c = letter_w_diacritic[n][12]; break;
  case 'S':  c = letter_w_diacritic[n][13]; break;
  case 'T':  c = letter_w_diacritic[n][14]; break;
  case 'U':  c = letter_w_diacritic[n][15]; break;
  case 'W':  c = letter_w_diacritic[n][16]; break;
  case 'Y':  c = letter_w_diacritic[n][17]; break;
  case 'Z':  c = letter_w_diacritic[n][18]; break;

  case 'a':  c = letter_w_diacritic[n][19]; break;
  case 'c':  c = letter_w_diacritic[n][20]; break;
  case 'd':  c = letter_w_diacritic[n][21]; break;
  case 'e':  c = letter_w_diacritic[n][22]; break;
  case 'g':  c = letter_w_diacritic[n][23]; break;
  case 'h':  c = letter_w_diacritic[n][24]; break;
  case 'i':  c = letter_w_diacritic[n][25]; break;
  case 'j':  c = letter_w_diacritic[n][26]; break;
  case 'k':  c = letter_w_diacritic[n][27]; break;
  case 'l':  c = letter_w_diacritic[n][28]; break;
  case 'n':  c = letter_w_diacritic[n][29]; break;
  case 'o':  c = letter_w_diacritic[n][30]; break;
  case 'r':  c = letter_w_diacritic[n][31]; break;
  case 's':  c = letter_w_diacritic[n][32]; break;
  case 't':  c = letter_w_diacritic[n][33]; break;
  case 'u':  c = letter_w_diacritic[n][34]; break;
  case 'w':  c = letter_w_diacritic[n][35]; break;
  case 'y':  c = letter_w_diacritic[n][36]; break;
  case 'z':  c = letter_w_diacritic[n][37]; break;

  case '\'':
  case ' ':  c = -1; break;

  default:   c = 0;
  }

  if ( !c )
    return NULL;

  *o++ = n + 0xC0;
  *o++ = ( ( (*s == ' ') || (*s == '\'') ) ? ALONE : *s );
  return o;
}


/* --- routine to convert from ISO 8859-n to T.61 --- */

int
ldap_8859_to_t61( char **bufp, unsigned long *buflenp, int free_input )
{
  Byte		*s, *oo, *o, *aux;
  int		c;
  unsigned long len; 
  Couple	*cc;

  LDAPDebug( LDAP_DEBUG_TRACE, "ldap_8859_to_t61 input length: %ld\n",
	*buflenp, 0, 0 );

  len = *buflenp;
  s = (Byte *) *bufp;

  if ( (o = oo = (Byte *)NSLDAPI_MALLOC( 2 * len + 64 )) == NULL ) {
        return( 1 );
  }

  while ( (char *)s - *(char **)bufp < len ) {
    switch( *s >> 5 ) {

    case 2:
      switch ( *s ) {

      case '^':  *o++ = 0xC3; *o++ = ALONE; s++; break;

      case '\\':
        s++;
        if ( (c = hh_to_c( s )) != -1 ) {
          *o++ = c;
          s += 2;
        } else
          *o++ = '\\';
        break;

      default:  *o++ = *s++;
      }
      break;

    case 3:
      switch ( *s ) {

      case '`':  *o++ = 0xC1; *o++ = ALONE; s++; break;
      case '~':  *o++ = 0xC4; *o++ = ALONE; s++; break;

      case '{':
        s++;
        if ( *(s + 2) == '}' ) {
          if ( (aux = cc_to_t61( o, s )) != NULL ) {
            o = aux;
            s += 3;
          } else {
            *o++ = '{';
          }
        } else if ( (*(s + 3) == '}') && ( (*s == 'x') || (*s == 'X') ) &&
                    ( (c = hh_to_c( s + 1 )) != -1 ) ) {
          *o++ = c;
          s += 4;
        } else {
          *o++ = '{';
        }
        break;

      default:
        *o++ = *s++;
      }
      break;

#if (ISO_8859 == 0)
    case 4: case 5: case 6: case 7:
      s++;
      break;
#else
    case 5: case 6: case 7:
# if (ISO_8859 == 1) || (ISO_8859 == 2) || (ISO_8859 == 3) || \
     (ISO_8859 == 4) || (ISO_8859 == 9) || (ISO_8859 == 10)
      if ( (*(cc = &trans_iso8859_t61[ *s - 0xA0 ])).a ) {
	*o++ = (*cc).a;
	if ( (*cc).b )  *o++ = (*cc).b;
      }
# endif
      s++;
      break;
#endif

    default:
      *o++ = *s++;
    }
  }

  len = o - oo;
  o = oo;

  if ( (oo = (Byte *)NSLDAPI_REALLOC( o, len )) == NULL ) {
    NSLDAPI_FREE( o );
    return( 1 );
  }

  if ( free_input ) {
    NSLDAPI_FREE( *bufp );
  }
  *bufp = (char *) oo;
  *buflenp = len;
  return( 0 );
}


#ifdef NOT_NEEDED_IN_LIBLDAP	/* mcs@umich.edu 12 Oct 1995 */
/* --- routine to convert "escaped" (\hh) characters to 8bits --- */

void convert_escaped_to_8bit( s )
char	*s;
{
  char	*o = s;
  int	c;

  while ( *s ) {
    if ( *s == '\\' ) {
      if ( (c = hh_to_c( ++s )) != -1 ) {
	*o++ = c;
	s += 2;
      } else
        *o++ = '\\';
    } else
      *o++ = *s++;
  }
  *o = '\0';
}

/* --- routine to convert 8bits characters to the "escaped" (\hh) form --- */

char *convert_8bit_to_escaped( s )
Byte  *s;
{
  Byte	*o, *oo;
  Byte	n;

  if ( (o = oo = (Byte *)NSLDAPI_MALLOC( 2 * strlen( s ) + 64 )) == NULL ) {
        return( NULL );
  }

  while ( *s ) {
    if ( *s < 0x80 )
      *o++ = *s++;
    else {
      *o++ = '\\';
      n = *s >> 4;
      *o++ = ((n < 0xA) ? '0' : 'A' - 0xA) + n;
      n = *s++ & 0x0F;
      *o++ = ((n < 0xA) ? '0' : 'A' - 0xA) + n;
    }
  }
  *o = '\0';

  o = oo;

  if ( (oo = (Byte *)NSLDAPI_REALLOC( o, strlen( o ) + 1 )) == NULL ) {
    NSLDAPI_FREE( o );
    return( NULL );
  }

  return( (char *)oo );
}

/* --- routine to convert from T.61 to printable characters --- */

/*
   printable characters [RFC 1488]: 'A'..'Z', 'a'..'z', '0'..'9',
       '\'', '(', ')', '+', ',', '-', '.', '/', ':', '?, ' '.

   that conversion is language dependent.
*/

static Couple last_t61_printabled[32] = {
	{0,0},     {'A','E'}, {'D',0},   {0,0},
	{'H',0},   {0,0},     {'I','J'}, {'L',0},
	{'L',0},   {'O',0},   {'O','E'}, {0,0},
	{'T','H'}, {'T',0},   {'N','G'}, {'n',0},
	{'k',0},   {'a','e'}, {'d',0},   {'d',0},
	{'h',0},   {'i',0},   {'i','j'}, {'l',0},
	{'l',0},   {'o',0},   {'o','e'}, {'s','s'},
	{'t','h'}, {'t',0},   {'n','g'}, {0,0}
};

char *t61_printable( s )
Byte  *s;
{
  Byte   *o, *oo;
  Byte   n;
  Couple *cc;

  if ( (o = oo = (Byte *)NSLDAPI_MALLOC( 2 * strlen( s ) + 64 )) == NULL ) {
        return( NULL );
  }

  while ( *s ) {
    if ( ( (*s >= 'A') && (*s <= 'Z') ) ||
         ( (*s >= 'a') && (*s <= 'z') ) ||
         ( (*s >= '0') && (*s <= '9') ) ||
         ( (*s >= '\'') && (*s <= ')') ) ||
         ( (*s >= '+') && (*s <= '/') ) ||
         ( *s == '?' ) || ( *s == ' ' ) )
      *o++ = *s++;
    else {
      if ( *s >= 0xE0 ) {
	if ( (*(cc = &last_t61_printabled[ *s - 0xE0 ])).a ) {
          *o++ = (*cc).a;
          if ( (*cc).b )  *o++ = (*cc).b;
        }
      }
      else if ( (*s >> 4) == 0xC ) {
        switch ( *s ) {
	case 0xCA:			/* ring */
	  switch ( *(s + 1) ) {
	  case 'A':  *o++ = 'A'; *o++ = 'A'; s++; break; /* Swedish */
	  case 'a':  *o++ = 'a'; *o++ = 'a'; s++; break; /* Swedish */
	  }
	  break;

	case 0xC8:			/* diaeresis */
	  switch ( *(s + 1) ) {
	  case 'Y':  *o++ = 'I'; *o++ = 'J'; s++; break; /* Dutch */
	  case 'y':  *o++ = 'i'; *o++ = 'j'; s++; break; /* Dutch */
          }
	  break;
        }
      }
      s++;
    }
  }
  *o = '\0';

  o = oo;

  if ( (oo = (Byte *)NSLDAPI_REALLOC( o, strlen( o ) + 1 )) == NULL ) {
    NSLDAPI_FREE( o );
    return( NULL );
  }

  return( (char *)oo );
}
#endif /* NOT_NEEDED_IN_LIBLDAP */	/* mcs@umich.edu 12 Oct 1995 */

#endif /* LDAP_CHARSET_8859 */
#endif /* STR_TRANSLATION */
