/***************************************************************************
                          list_pgn.h  -  description
                             -------------------
    begin                : Thu Dec 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LIST_PGN_H
#define LIST_PGN_H

#include <qvbox.h>
#include <qstring.h>
#include "pgn.h"

/**
  *@author Troy Corbin Jr.
  */

class match_param;
class KStatusBar;
class KProgress;
class KListView;
class QHBox;

class list_pgn : public QVBox
{
	Q_OBJECT
	public:
										list_pgn(QWidget *parent=0, const char *name=0);
		void						setURL( QString URL );
		void						setProgress( const int );
		QString					URL( void )
												{ return myURL; }
										~list_pgn();


	signals:
		void						selected( const QString&, const int& );

	protected slots:
		void						slot_selected( QListViewItem *item );

	protected:
		void						timerEvent( QTimerEvent * );

	private:
		QString					myURL;
		QHBox						*statusBox;
		KListView				*listView;
		KListView				*dummyView;
		KStatusBar			*status;
		KProgress				*progress;
		pgn							tmpPGN;
};

#endif
