/***************************************************************************
                          thinbuttons.h  -  description
                             -------------------
    begin                : Tue Nov 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef THINBUTTONS_H
#define THINBUTTONS_H

#include <kpopupmenu.h>
#include <qframe.h>
#include <qbutton.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */
struct Buttons
{
	QButton		*button;
	int				ID;
};

class thinbuttons : public QFrame
{
	Q_OBJECT
	public:
								thinbuttons(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
								~thinbuttons();
		void				mousePressEvent( QMouseEvent *event );
		void				setButton( int id );
		QButton*		find( int id );
		QButton*		create( int id );
		void				remove( QButton* button );
		void				remove( const int &id );
		void				resize( const int Width );
		int					id( QButton * );

	signals:
		void				leftClick( int id );
		void				rightClick( int id );
		void				menuItemSelected( int id, int item );

	protected slots:
		void				buttonClicked(void);
		void				menuClicked( int item );

	protected:
		void				childEvent( QChildEvent * );

	private:
		resource										*Resource;
		KPopupMenu									*matchMenu;
		QList<Buttons>							buttons;
		int													buttWidth;
		int													rightClickID;
};

#endif
