/***************************************************************************
                          knights.h  -  description
                             -------------------
    begin                : Thu Mar  1 10:43:51 CST 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNIGHTS_H
#define KNIGHTS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* KDEBase */
#include <kapp.h>
#include <kmainwindow.h>
#include <khelpmenu.h>
#include <kaboutdata.h>
#include <kstatusbar.h>
#include <kcmdlineargs.h>
/* QT */
#include <qlayout.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qstring.h>
/* Local */
#include "definitions.h"
#include "resource.h"
#include "accel.h"

class KMenuBar;
class KPopupMenu;
class KComboBox;
class QLabel;
class QFrame;
class dlg_settings;
class dlg_newmatch;
class core;
class splash;

/**
		Knights is the top-level widget of the project.
		It is responsable for creating the menu bar and it's contents,
		as well as creating an instance of the game itself ( class Grid )
**/
class Knights : public KMainWindow
{
  Q_OBJECT 
  public:
		KAboutData			*aboutData;
		resource				*Resource;

								    Knights( KCmdLineArgs *Args, QWidget* parent=0, const char *name=0 );
								    ~Knights();
		bool						init( void );
		void						initMenus( void );
		void						BirthAll( void );
		void						keyPressEvent( QKeyEvent* );

	public slots:
		void						KillAll( void );
		void						menuClose( void );
		/**		Yeah, they're sloppy, but I need my own geometry managment routines
					because I don't like the "default" look my statusbar was getting
					( double-height ). Plus, I want the console to appear only when needed. */
		void						resizeMainFrame( void );

		bool						event( QEvent* );
		void						resizeEvent( QResizeEvent* );
		void						hideEvent( QHideEvent* );
		void						showEvent( QShowEvent* );
		void						wheelEvent( QWheelEvent* );

		void						setStatusBar( const int &ID, const QString& MSG=QString::null );

		void						setClocks( void );
		void						initMatch( void );

		void						setNotation( void );
		void						PrevNotation( void );
		void						NextNotation( void );

		void						SelectTheme( int boardIndex, int chessmenIndex );
		void						Settings( int opt );
		void						openSettingsDialog( void );
		void						openNewMatchDialog( void );
		void						openKeyBindingDialog( void );
		bool						SaveGame( void );
		bool						SaveGamePrompt( void );
		bool						SaveGameAs( void );

		void						netConnect( void );

	signals:
		void						themesAdded( void );
		void						focus( const QChar& );

	protected:
		bool						queryClose( void );

	protected slots:
		void						boardSmaller( void );
		void						boardBigger( void );
		void						installThemes( void );
		void						newMatch( void );

	private:
		KCmdLineArgs 		*args;
		KMenuBar				*topMenu;
		KPopupMenu			*help;
		KPopupMenu			*fileMenu;
		KPopupMenu			*settingsMenu;
		KPopupMenu			*matchMenu;
		KPopupMenu			*drawMenu;
		KPopupMenu			*tutorialMenu;
		KComboBox				*notationBar;
		QFrame					*MainFrame;
		QLabel					*whiteTimeLabel;
		QLabel					*blackTimeLabel;
		QLabel					*Message;
		dlg_settings		*SettingsDialog;
		dlg_newmatch		*NewMatch;
		core						*Core;
		splash					*SplashScreen;
		Accel						*myAccel;

		int							NotationIndex;
		bool						InitAll;
		bool						Minimized;
		bool						ResizeFlag;
		int							margin;
};

#endif
