#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif /* HAVE_CONFIG_H */

#include "kz-embed.h"

#include <gcutter.h>

void test_names (void);
void test_ids (void);

static GList *expected;

void
cut_startup (void)
{
    kz_embed_load(NULL);
}

void
cut_shutdown (void)
{
    kz_embed_unload();
    kz_embed_exit();
}

void
setup (void)
{
    expected = NULL;
}

void
teardown (void)
{
    g_list_free(expected);
}

void
test_names (void)
{
#ifdef WITH_GECKO
    expected = g_list_append(expected, GECKO_VERSION);
#endif
    gcut_assert_equal_list_string(expected, kz_embed_engine_names());
}

void
test_ids (void)
{
#ifdef WITH_GECKO
    expected = g_list_append(expected, "gecko");
#endif
    gcut_assert_equal_list_string(expected, kz_embed_engine_ids());
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
