/*
 *	Copyright (c) 1986-2002, Hiram Clawson - curator@hiram.ws.NoSpam
 *	All rights reserved.
 *
 *	Redistribution and use in source and binary forms, with or
 *	without modification, are permitted provided that the following
 *	conditions are met:
 *
 *		Redistributions of source code must retain the above
 *		copyright notice, this list of conditions and the
 *		following disclaimer.
 *
 *		Redistributions in binary form must reproduce the
 *		above copyright notice, this list of conditions and
 *		the following disclaimer in the documentation and/or
 *		other materials provided with the distribution.
 *
 *		Neither name of The Museum of Hiram nor the names of
 *		its contributors may be used to endorse or promote products
 *		derived from this software without specific prior
 *		written permission. 
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 *	CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 *	THE POSSIBILITY OF SUCH DAMAGE. 
 */
/*
 *
 *	jday - output julian date
 *	- no arguments - julian date for right now
 *	- otherwise, jday [year] [month] [day] [hour] [minute]
 *	- with only [year] - uses today for month, day, hour, minute
 *	- with [year] [month] - uses today for day, hour, minute
 *	- etc...
 *	- must have [year] if using [month]
 *	- must have [month] if using [day]
 *	- must have [day] if using [hour]
 *	- must have [hour] if using [minute]
 *	- i.e. the arguments are purely positional
 *
 */

#include	<stdio.h>
#include  <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include  <time.h>
#include <math.h>
#include "jday.h"

extern char version[];
extern char patchlevel[];
extern char date[];
extern char jday_copyright[];

static void
Version() {
fprintf(stderr, "jday - version %s - %s\n", version, date );
fprintf(stderr, "\t%s\n", jday_copyright );
}

static void
Usage() {
fprintf(stderr, "usage: jday [year [month [day [hour [minute] [second]]]]]\n");
fprintf(stderr, "\tor: jday -d year/month/day hour:minute:second\n" );
Version();
}

main( argc, argv )
int argc;
char * argv[];
{
	int day;
	int mo;
	int hour;
	int minute;
	int second;
	long year;
	double jd;
  	time_t now_time;
	struct tm *local_now;
	struct ut_instant today;
	char * cp;

	(void) putenv("TZ=GMT");
	time ( & now_time);
	local_now = localtime  (& now_time);

	year = local_now->tm_year + 1900;
	mo = local_now->tm_mon + 1;
	day = local_now->tm_mday;
	hour = local_now->tm_hour;
	minute = local_now->tm_min;
	second = local_now->tm_sec;

	if ( argc > 1 ) {
		switch ( argc ) {
			case 7:
				second = atoi( argv[6] );
				if ( second > 59 ) second = 59;
				if ( second < 0 ) second = 0;
			case 6:
				minute = atoi( argv[5] );
				if ( minute > 59 ) minute = 59;
				if ( minute < 0 ) minute = 0;
			case 5:
				hour = atoi( argv[4] );
				if ( hour > 23 ) hour = 23;
				if ( hour < 0 ) hour = 0;
			case 4:
				day = atoi( argv[3] );
				if ( day > 31 ) day = 31;
				if ( day < 1 ) day = 1;
			case 3:
		if ( ! strcmp((const char *)argv[1], (const char *) "-d") ) {
	if ( 3 != sscanf( argv[2], "%d/%d/%d", & year, & mo, & day ) ) {
fprintf( stderr, "failed sscanf for ymd\n" );
		exit (-1);
	} else {
				if ( day > 31 ) day = 31;
				if ( day < 1 ) day = 1;
				if ( mo > 12 ) mo = 12;
				if ( mo < 1 ) mo = 1;
	}
	if ( 3 != sscanf( argv[3], "%d:%d:%d", & hour, & minute, & second ) ) {
fprintf( stderr, "failed sscanf for hms\n" );
		exit (-1);
	} else {
				if ( second > 59 ) second = 59;
				if ( second < 0 ) second = 0;
				if ( minute > 59 ) minute = 59;
				if ( minute < 0 ) minute = 0;
				if ( hour > 23 ) hour = 23;
				if ( hour < 0 ) hour = 0;
			break;
	}
		} else {
				mo = atoi( argv[2] );
				if ( mo > 12 ) mo = 12;
				if ( mo < 1 ) mo = 1;
		}
			case 2:
		if ( (char *) NULL != (cp =
			strstr((const char *)argv[1], (const char *) "-h") ) ){
				Usage();
				exit(0);
		}
		if ( (char *) NULL != (cp =
			strstr((const char *)argv[1], (const char *) "-v") ) ){
				Version();
				exit(0);
		}
				year = atol( argv[1] );
				break;
			default:
				Usage();
				break;;
		}
	}

/*	clear the today structure	*/

	today.year = 0;
	today.month = 0;
	today.day = 0;
	today.i_hour = 0;
	today.i_minute = 0;
	today.second = 0.0;
	today.d_hour = 0;
	today.d_minute = 0;
	today.weekday = 7;
	today.day_of_year = 0;
	today.j_date = 2147483647;
	today.j_date = (today.j_date * 2.0) + 1.0;

	today.year = year;
	today.month = mo;
	today.day = day;
	today.i_hour = hour;
	today.i_minute = minute;
	today.second = (double) second;

	/*	for completeness	*/
	today.d_minute = today.i_minute + (today.second / 60.0);
	today.d_hour = today.i_hour + (today.d_minute / 60.0);

	jd = JulDate( & today );
	printf( "%-17.6f\n", jd );

	exit( 0 );
	/*	NOTREACHED	*/
}
