<% if (thumbnailBorderSize < 0 || thumbnailBorderType == "none") {
	thumbnailBorderSize = 0;
}
if (selectedThumbnailBorderSize < 0 || selectedThumbnailBorderType == "none") {
	selectedThumbnailBorderSize = 0;
}
if (folderIconBorderSize < 0 || folderIconBorderType == "none") {
	folderIconBorderSize = 0;
}
browserThumbWidth = fixedSizeBrowserScaling ? fixedWidth : maxThumbWidth;
browserThumbHeight = fixedSizeBrowserScaling ? fixedHeight : maxThumbHeight;
thumbItemSize = browserThumbWidth + thumbnailMargin + thumbnailBorderSize * 2;
selectedThumbItemSize = browserThumbWidth + thumbnailMargin + selectedThumbnailBorderSize * 2;
scrollerWidth = thumbItemSize * (scrollerSize-1) + selectedThumbItemSize;
scrollerContainerWidth = scrollerWidth;
arrowCount = 0; 
if (navigation) {
	arrowCount += 2;
	scrollerContainerWidth += (arrowWidth + arrowMargin) * 2 - thumbnailMargin;
	if (fastNavigation) {
		arrowCount += 2;
		scrollerContainerWidth += arrowWidth * 2 + arrowMargin * 4;
	}
}
folderItemWidth = maxThumbWidth + (folderIconBorderSize * 2) + folderMargin;
folderItemHeight = maxThumbHeight + (folderIconBorderSize * 2) + folderMargin; 
totalFoldersWidth = totalFolderCount * folderItemWidth;
foldersWidth = thumbnailCount > totalFolderCount ? totalFoldersWidth : thumbnailCount * folderItemWidth; %>
<style type="text/css">
	.thumbnails li {
		width: <%= browserThumbWidth %>px;
		height: <%= browserThumbHeight %>px;
		margin: 0 <%= thumbnailMargin %>px <%= thumbnailMargin %>px 0;	
		border-style: <%= thumbnailBorderType %>;
		border-width: <%= thumbnailBorderSize %>px;
		<% if (useCustomThumbnailBorderColor) { out.print("border-color: " + thumbnailBorderColor + ";"); } %>
	}
	
	.thumbnails li.active {
		border-style: <%= selectedThumbnailBorderType %>;
		border-width: <%= selectedThumbnailBorderSize %>px;
		<% if (useCustomSelectedThumbnailBorderColor) { out.print("border-color: " + selectedThumbnailBorderColor + ";"); } %>
	}
	
	#main_image img {
		border-style: <%= mainImageBorderType %>;
		border-width: <%= mainImageBorderSize %>px;
		<% if (useCustomMainImageBorderColor) { out.print("border-color: " + mainImageBorderColor + ";"); } %>
	}
	
	#main_image .loader {
		height: <%= maxHeight %>px; 
		width: <%= maxWidth %>px;
		border-style: <%= mainImageBorderType %>;
		border-width: <%= mainImageBorderSize %>px;
		<% if (useCustomMainImageBorderColor) { out.print("border-color: " + mainImageBorderColor + ";"); } %>
	}

	#main_image .loader img {		
		margin-top: <%= (maxHeight/3) %>px;
	}

	#middle_container {
		height: <%= (maxHeight + bottomMargin) %>px;
	}

	#scroller_container {
		margin-top: <%= scrollerMargin %>px;
		margin-bottom: <%= scrollerMargin - thumbnailMargin %>px;
		width: <%= scrollerContainerWidth %>px;	
	}

	#image_scroller {
		margin: <% if (arrowCount > 0) { out.print("0 " + (arrowMargin - thumbnailMargin) + "px 0 " + arrowMargin + "px"); } else { out.print("0"); } %>;
		width: <%= scrollerWidth %>px;
	}
	
	#thumbnails_container {
		width: <%= thumbItemSize * (totalThumbnailCount-1) + selectedThumbItemSize %>px;
	}
	
	#scroller_container,
	#image_scroller,
	#thumbnails_container {
		height: <% if (selectedThumbItemSize > thumbItemSize) { out.print(selectedThumbItemSize); } else { out.print(thumbItemSize); } %>px;
	}
	
	#right_arrow,
	#left_arrow,
	#right_fast_arrow,
	#left_fast_arrow {
		height: <%= arrowHeight %>px;
		width: <%= arrowWidth %>px;
	}
	
	#right_fast_arrow,
	#left_fast_arrow {
		margin: 0 <%= arrowMargin %>px;
	}
	
	#bottom_container {
		margin-top: <%= bottomMargin %>px;
	}
	
	#folders_container {
		<% if (!navigation) { out.print("border-bottom: none;"); } %>	
	}		
	
	.folders {
		width: <%= foldersWidth %>px;		
	}
	
	.folders li {
		width: <%= folderItemWidth %>px;
		height: <%= folderItemHeight %>px;	
	}
	
	.folders li a {				
		border-style: <%= folderIconBorderType %>;
		border-width: <%= folderIconBorderSize %>px;
		<% if (useCustomFolderIconBorderColor) { out.print("border-color: " + folderIconBorderColor + ";"); } %>
		margin-right: <%= folderMargin %>px;				
		height: <%= maxThumbHeight %>px; 
		width: <%= maxThumbWidth %>px;
	}
</style>