<ja:if test="<%= navigation %>">	
	<script src="${resPath}/jquery.hotkeys.js" type="text/javascript"></script>
	<script src="${resPath}/galleria/jquery.galleria.js" type="text/javascript"></script>
	<script src="${resPath}/jquery.scrollimages.js" type="text/javascript"></script>
	<script type="text/javascript">		
		$(function() {
			$("#thumbnails_container").imageScroller({
				onBeforeScroll: function() { $.galleria.stop() },
				onScroll: function() { $.galleria.start() }, 
				duration: <%= scrollDuration %>, 
				imageWidth: <%= thumbItemSize %>, 
				size: <%= scrollerSize %>,
				fastSteps: <%= fastNavigationStep %>
			});
			
			$(".thumbnails_unstyled").addClass("thumbnails");
			$("ul.thumbnails").galleria({
				history: false,
				clickNext: true,
				insert: "#main_image",
				onImage: function(image, caption, thumb) {
					image.css("display", "none").fadeIn(<%= mainImageFadeIn %>);
					caption.css("display", "none").fadeIn(<%= mainImageFadeIn %>);
					var _li = thumb.parents("li");
					_li.siblings().children("img.selected").fadeTo(<%= selectedThumbnailFadeOut %>, <%= thumbnailOpacity %>);
					thumb.fadeTo("fast", 1).addClass("selected");
					image.attr("title", "$text.content.nextImage");
					var original = thumb.data("original");
					if (original) {
						var originalLink = $("<a></a>").attr("href", original).text("$text.content.downloadOriginal");
						caption.append(" (").append(originalLink).append(")");
					}
				},
				onThumb: function(thumb) {
					var _li = thumb.parents("li");
					var _fadeTo = _li.is(".active") ? "1" : <%= thumbnailOpacity %>;
					thumb.css({display: "none", opacity: _fadeTo}).fadeIn(<%= selectedThumbnailFadeIn %>);
					thumb.hover(
						function() { 
							thumb.fadeTo("fast", 1);		
						},
						function() {
							_li.not(".active").children("img").fadeTo("fast", <%= thumbnailOpacity %>);
						}
					)
				},
				preloads: <%= preloads %>,
				fastSteps: <%= fastNavigationStep %>,
				onPrev: function() {
					$.imageScroller.scrollLeft();
				},
				onNext: function() {
					$.imageScroller.scrollRight();
				},
				onPrevFast: function() {
					$.imageScroller.fastScrollLeft();
				},
				onNextFast: function() {
					$.imageScroller.fastScrollRight();
				}
			});
			
			$.galleria.loader = $("<div></div>").addClass("loader").append($(new Image()).attr("src","${resPath}/loader.gif").attr("title","$text.content.loading"));
			
			prepareArrow = function(arrow) {
				arrow.css({display: "none", opacity: <%= arrowOpacity %>, "padding-top": "<%= (thumbItemSize - thumbnailMargin) > arrowHeight ? ((thumbItemSize - thumbnailMargin) - arrowHeight)/2 : 0 %>px"}).fadeIn( <%= arrowFadeIn %>);			
				arrow.hover(
					function() {
						arrow.fadeTo("fast", 1);
					},
					function() {
						arrow.fadeTo("fast", <%= arrowOpacity %>);			
					}
				);	
			}
			
			var leftArrow = $("#left_arrow");
			prepareArrow(leftArrow);
			leftArrow.click(function() {
				$.galleria.prev();	
			});
			
			var rightArrow = $("#right_arrow");
			prepareArrow(rightArrow);
			rightArrow.click(function() {
				$.galleria.next();
			});
			
			var fastNavigation = <%= fastNavigation %>;
			if (fastNavigation) {
				var leftFastArrow = $("#left_fast_arrow");
				prepareArrow(leftFastArrow);
				leftFastArrow.click(function() {
					$.galleria.prevFast();
				});
				
				var rightFastArrow = $("#right_fast_arrow");
				prepareArrow(rightFastArrow);
				rightFastArrow.click(function() {
					$.galleria.nextFast();
				});
			}
		});

		$(document).bind("keydown", "left", function() {
			if (!KeyboardNavigation.widgetHasFocus()) {
				$.galleria.prev();
			}
		});
		$(document).bind("keydown", "right", function() {
			if (!KeyboardNavigation.widgetHasFocus()) {
				$.galleria.next();
			}
		});

		var KeyboardNavigation = {
			widgetHasFocus: function() {
				if(typeof _jaWidgetFocus != 'undefined' && _jaWidgetFocus) {
					return true;
				}
				return false;
			}
		}
	</script>
</ja:if>
<ja:if test="<%= folders %>">
	<script type="text/javascript">			
		$(function() {
			$("ul.folders li a").css({display: "none", opacity: <%= folderOpacity %>}).fadeIn(<%= folderFadeIn %>).hover(
				function() { 
					$(this).fadeTo("fast", 1);		
				},
				function() {
					$(this).fadeTo("fast", <%= folderOpacity %>);
				}
			);
		});
	</script>
</ja:if>