import se.datadosen.jalbum.*;

import java.awt.*;
import java.awt.image.BufferedImage;

import java.util.*;

/**
 * Crop images to specified dimension
 * @author David Ekholm, Jalbum 2009
 * @since 8.4.2
 * @version 1.0
 */
public class CropFilter implements JAFilter, ModifiesSize {
	
	private Dimension bounds = new Dimension(120,120);
    private float xWeight = 0.5f;
    private float yWeight = 0.3f;    
    
	public String getName() {
	    return "Crop filter";
	}

    // Implements JAFilter
    public String getDescription() {
        return "Crops images to specified dimension";
    }

    public Dimension getBounds() {
        return bounds;
    }

    public void setBounds(Dimension bounds) {
        this.bounds = bounds;
    }

    public float getXWeight() {
        return xWeight;
    }

    public void setXWeight(float weight) {
        this.xWeight = weight;
    }
    
    public float getYWeight() {
        return yWeight;
    }

    public void setYWeight(float weight) {
        this.yWeight = weight;
    }

    private Dimension minDimension(Dimension d1, Dimension d2) {
        return new Dimension(
            Math.min(d1.width, d2.width),
            Math.min(d1.height, d2.height));
    }

    // Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        Dimension dDim = minDimension(sDim, bounds);

        return bi.getSubimage(
            (int)((sDim.width-dDim.width)*xWeight),
            (int)((sDim.height-dDim.height)*yWeight),
            dDim.width, dDim.height);
    }

    // Implements ModifiesSize
    public Dimension getModifiedSize(Dimension originalSize, Map vars) {
        return minDimension(originalSize, bounds);
    }
}
