/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Segment;

public class RotationSupport {
    public static final int LEFT_ROTATED = 6;
    public static final int NOT_ROTATED = 1;
    public static final int RIGHT_ROTATED = 8;

    public static BufferedImage rotateLeft(BufferedImage bi) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi, null);
    }

    public static BufferedImage rotateRight(BufferedImage bi) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi, null);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, Metadata meta) {
        if (meta == null) {
            return ii;
        }
        BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi = RotationSupport.adjustOrientation(bi, meta);
        return new ImageIcon(bi);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, File file) {
        try {
            BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
            bi = RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
            return new ImageIcon(bi);
        }
        catch (IOException ex) {
            return ii;
        }
    }

    private static BufferedImage createBufferedImage(Image img, int iw, int ih) {
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, Metadata meta) {
        if (meta == null) {
            return bi;
        }
        try {
            if (meta.containsDirectory(ExifDirectory.class)) {
                Directory exif = meta.getDirectory(ExifDirectory.class);
                int existingOrientation = exif.getInt(274);
                return RotationSupport.adjustOrientation(bi, existingOrientation);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, File file) {
        try {
            return RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
        }
        catch (IOException ex) {
            return bi;
        }
    }

    public static int getOrientation(Metadata meta) {
        try {
            if (meta.containsDirectory(ExifDirectory.class)) {
                Directory exif = meta.getDirectory(ExifDirectory.class);
                return exif.getInt(274);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return 1;
    }

    public static String getOrientationAsString(Metadata meta) {
        return RotationSupport.asString(RotationSupport.getOrientation(meta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOrientation(File file) throws IOException {
        JpegFile f = null;
        try {
            Segment s;
            f = new JpegFile(file);
            for (s = f.getFirstSegment(); s != null && s.getId() != -31; s = s.getNextSegment()) {
            }
            if (s != null) {
                APP1Segment app1 = new APP1Segment(s);
                boolean ifdNum = false;
                do {
                    for (int i = 0; i < app1.getEntryCount(); ++i) {
                        APP1Segment.Entry ifd = app1.getEntry(i);
                        if (ifd.getTagNr() != 274) continue;
                        int n = ifd.getValue();
                        return n;
                    }
                } while (app1.nextIFD());
            }
            int n = 1;
            return n;
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
    }

    public static String getOrientationAsString(File file) throws IOException {
        return RotationSupport.asString(RotationSupport.getOrientation(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setOrientation(int orientation, File file) throws IOException {
        JpegFile f = null;
        boolean reoriented = false;
        try {
            Segment s;
            f = new JpegFile(file, "rw");
            for (s = f.getFirstSegment(); s != null && s.getId() != -31; s = s.getNextSegment()) {
            }
            if (s != null) {
                APP1Segment app1 = new APP1Segment(s);
                boolean ifdNum = false;
                block4: do {
                    for (int i = 0; i < app1.getEntryCount(); ++i) {
                        APP1Segment.Entry ifd = app1.getEntry(i);
                        if (ifd.getTagNr() != 274) continue;
                        ifd.setValue(orientation);
                        reoriented = true;
                        continue block4;
                    }
                } while (app1.nextIFD());
            }
            if (!reoriented) {
                throw new IOException("Couldn't find orientation tag in APP1 segment");
            }
            boolean bl = reoriented;
            return bl;
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
    }

    private static int asCode(String orientation) {
        if ("left".equals(orientation)) {
            return 6;
        }
        if ("right".equals(orientation)) {
            return 8;
        }
        return 1;
    }

    private static String asString(int orientation) {
        switch (orientation) {
            case 6: {
                return "left";
            }
            case 8: {
                return "right";
            }
        }
        return "normal";
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, String existingOrientation) {
        return RotationSupport.adjustOrientation(bi, RotationSupport.asCode(existingOrientation));
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, int existingOrientation) {
        if (existingOrientation == 6) {
            return RotationSupport.rotateRight(bi);
        }
        if (existingOrientation == 8) {
            return RotationSupport.rotateLeft(bi);
        }
        return bi;
    }
}

