/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import se.datadosen.jalbum.Config;
import se.datadosen.util.Multilingual;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.annotations.TabTitle;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

public class Msg {
    static final String BUNDLE_NAME = "texts/texts";
    private static SmartResourceBundle RESOURCE_BUNDLE = SmartResourceBundle.getBundle(Config.getConfig().progDir, "texts/texts");
    private static final String[] charsetNames = new String[]{"ISO-8859-1", "MacRoman", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "windows-1252", Msg.get("ui.internationalJavaInfo"), "Big5", "Big5-HKSCS", "EUC-CN", "EUC-JP", "euc-jp-linux", "EUC-KR", "EUC-TW", "GB18030", "GBK", "ISCII91", "ISO-2022-CN-CNS", "ISO-2022-CN-GB", "ISO-2022-KR", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "JIS0201", "JIS0208", "JIS0212", "Johab", "KOI8-R", "Shift_JIS", "TIS-620", "windows-1250", "windows-1251", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "windows-936", "windows-949", "windows-950"};
    protected static Package lastCallerPackage;
    protected static SmartResourceBundle temporaryBundle;
    protected static Set toTranslate;
    protected static boolean debugMode;
    private static String[] extensions;

    private Msg() {
    }

    public static void reloadBundle() {
        RESOURCE_BUNDLE = SmartResourceBundle.getBundle(Config.getConfig().progDir, BUNDLE_NAME);
    }

    static String[] getCharsetNames() {
        return charsetNames;
    }

    @Deprecated
    public static String getString(String key) {
        return Msg.get(key);
    }

    public static String get(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            if (debugMode) {
                throw e;
            }
            return '!' + key + '!';
        }
    }

    public static Locale getLocale() {
        Locale locale = RESOURCE_BUNDLE.getLocale();
        return locale != null ? locale : Locale.US;
    }

    public static String get(String key, Object ... params) {
        return MessageFormat.format(Msg.get(key), params);
    }

    public static String getString(Object caller, String key) {
        try {
            Package pkg = caller.getClass().getPackage();
            if (!pkg.equals(lastCallerPackage)) {
                lastCallerPackage = pkg;
                temporaryBundle = SmartResourceBundle.getBundle(caller.getClass(), BUNDLE_NAME);
            }
            return temporaryBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static void maintainTranslated(Object o) {
        toTranslate.add(o);
        Msg.setTexts(o);
    }

    public static void releaseFromTranslation(Object o) {
        toTranslate.remove(o);
    }

    public static void setTexts() {
        for (Object o : toTranslate) {
            Msg.setTexts(o);
        }
    }

    public static void setTexts(Object o) {
        try {
            for (Field f : o.getClass().getDeclaredFields()) {
                Multilingual ml;
                TabTitle ttk;
                Title tk;
                ToolTipText tttk;
                f.setAccessible(true);
                Text nk = f.getAnnotation(Text.class);
                if (nk != null) {
                    String key = Msg.makeKey(nk.value(), f);
                    String result = Msg.get(key) + nk.postfix();
                    if (Action.class.isAssignableFrom(f.getType())) {
                        Action a = (Action)f.get(o);
                        a.putValue("Name", result);
                    } else if (JComponent.class.isAssignableFrom(f.getType())) {
                        Method method = f.get(o).getClass().getMethod("setText", String.class);
                        method.invoke(f.get(o), result);
                    } else {
                        throw new RuntimeException("Annotated element " + f.getName() + " is not an Action or JComponent");
                    }
                }
                if ((tttk = f.getAnnotation(ToolTipText.class)) != null) {
                    String key = Msg.makeKey(tttk.value(), f, "ToolTip");
                    String result = Msg.get(key);
                    if (Action.class.isAssignableFrom(f.getType())) {
                        Action a = (Action)f.get(o);
                        a.putValue("ShortDescription", result);
                    } else if (JComponent.class.isAssignableFrom(f.getType())) {
                        JComponent comp = (JComponent)f.get(o);
                        comp.setToolTipText(result);
                    } else {
                        throw new RuntimeException("Annotated element " + f.getName() + " is not an Action or JComponent");
                    }
                }
                if ((tk = f.getAnnotation(Title.class)) != null) {
                    String key = Msg.makeKey(tk.value(), f);
                    String result = Msg.get(key);
                    Method method = f.get(o).getClass().getMethod("setTitle", String.class);
                    method.invoke(f.get(o), result);
                }
                if ((ttk = f.getAnnotation(TabTitle.class)) != null) {
                    JTabbedPane tabs;
                    int index;
                    String key = Msg.makeKey(ttk.value(), f);
                    String result = Msg.get(key);
                    Component comp = (Component)f.get(o);
                    if (comp.getParent() instanceof JTabbedPane && (index = (tabs = (JTabbedPane)comp.getParent()).indexOfComponent(comp)) != -1) {
                        tabs.setTitleAt(index, result);
                    }
                }
                if (!Multilingual.class.isAssignableFrom(f.getType()) || (ml = (Multilingual)f.get(o)) == null) continue;
                ml.languageUpdated();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String makeKey(String raw, Field f) {
        return Msg.makeKey(raw, f, "");
    }

    private static String makeKey(String raw, Field f, String defaultExtension) {
        if (raw.length() == 0) {
            return "ui." + Msg.baseNameOf(f) + defaultExtension;
        }
        String s = raw.replaceAll("~", Msg.baseNameOf(f));
        return s;
    }

    private static String baseNameOf(Field f) {
        String s = f.getName();
        for (String ext : extensions) {
            if (!s.endsWith(ext)) continue;
            return s.substring(0, s.length() - ext.length());
        }
        return s;
    }

    static {
        toTranslate = new HashSet();
        debugMode = true;
        extensions = new String[]{"Action", "Label"};
    }
}

