/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JDirectoryChooser;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.buttonbar.JButtonBarPane;
import se.datadosen.component.buttonbar.PercentLayout;
import se.datadosen.dnd.FileDropEvent;
import se.datadosen.dnd.FileDropListener;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JGeneralSettingsPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NumericVerifier;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.util.Item;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;

public class JSettingsWindow
extends JSmartDialog {
    private JAlbumFrame parent;
    JButtonBarPane buttonBarPane = new JButtonBarPane();
    private ControlPanel generalPanel = new ControlPanel();
    private ControlPanel imagesPanel = new ControlPanel();
    private ControlPanel pagesPanel = new ControlPanel();
    private JTabbedPane advancedPanel = new JTabbedPane();
    private ControlPanel advGeneralPanel = new ControlPanel();
    private ControlPanel advMetadataPanel = new ControlPanel();
    private ControlPanel advNamingPanel = new ControlPanel();
    private ControlPanel advUserVariablesPanel = new ControlPanel();
    JPanel skinSettingsPanel = new JPanel();
    private ImageIcon thumbnailsSlideIcon = new ImageIcon(this.getClass().getResource("images/linking/thsd.png"));
    private ImageIcon thumbnailsSlideOriginalIcon = new ImageIcon(this.getClass().getResource("images/linking/thsdor.png"));
    private ImageIcon thumbnailsOriginalIcon = new ImageIcon(this.getClass().getResource("images/linking/thor.png"));
    private ImageIcon thumbnailsOriginalsNoSlidesIcon = new ImageIcon(this.getClass().getResource("images/linking/thorns.png"));
    private ImageIcon thumbnailsScaledNoSlidesIcon = new ImageIcon(this.getClass().getResource("images/linking/thsdns.png"));
    private ImageIcon bboxIcon = new ImageIcon(this.getClass().getResource("images/bbox.png"));
    private Component currentPanel;
    ControlPanel skinUI = null;
    public JGeneralSettingsPanel generalSettings = new JGeneralSettingsPanel();
    JLabel directoryLabel = new JLabel();
    public JTextField directory = new JSmartTextField(30);
    JButton chooseDirectoryButton = new JButton();
    JLabel outputDirectoryLabel = new JLabel();
    JTextField outputDirectory = new JSmartTextField(30);
    JButton chooseOutputDirectoryButton = new JButton();
    JFileDropPanel outputDirectoryPanel = new JFileDropPanel();
    JCheckBox sameDirectory = new JCheckBox();
    JCheckBox copyOriginals = new JCheckBox();
    JCheckBox subdirs = new JCheckBox();
    JCheckBox slides = new JCheckBox();
    ControlPanel imageLinkingPanel = new ControlPanel();
    JLabel linkingGuide = new JLabel(this.thumbnailsSlideOriginalIcon);
    ButtonGroup imageLinking = new ButtonGroup();
    JRadioButton linkOriginals = new JRadioButton();
    JRadioButton linkOriginalsViaScaled = new JRadioButton();
    JRadioButton linkScaled = new JRadioButton();
    ControlPanel imageBoundsPanel = new ControlPanel();
    JLabel thumbSizeLabel = new JLabel();
    JComboBox thumbSize = new JComboBox<String>(new String[]{"240x240", "180x180", "160x160", "124x124", "90x90"});
    JLabel imageSizeLabel = new JLabel();
    JComboBox imageSize = new JComboBox<String>(new String[]{"1024x1024", "800x800", "720x720", "640x640", "512x512", "400x400"});
    ControlPanel thumbnailLayoutPanel = new ControlPanel();
    JCollapsiblePanel advancedImagesPanel = new JCollapsiblePanel();
    JLabel imageBackgroundColorLabel = new JLabel();
    JColorSelector imageBackgroundColor = new JColorSelector(new JTextField(6));
    JLabel colsLabel = new JLabel();
    JTextField cols = new JSmartTextField(4);
    JLabel rowsLabel = new JLabel();
    JTextField rows = new JSmartTextField(4);
    ControlPanel imageOrderingPanel = new ControlPanel();
    JComboBox imageOrdering = new JComboBox();
    JCheckBox reverseOrder = new JCheckBox();
    JCheckBox directoriesFirst = new JCheckBox();
    DeferredChooser directoryChooser = new DeferredChooser(JDirectoryChooser.class);
    DeferredChooser outputDirectoryChooser = new DeferredChooser(JDirectoryChooser.class);
    JFileDropPanel jFileDropPanel1 = new JFileDropPanel();
    JLabel qualityPercentLabel = new JLabel();
    JSlider qualityPercent = new JSlider(0, 0, 100, 75);
    JLabel sharpenPercentLabel = new JLabel();
    JSlider sharpenPercent = new JSlider(0, 0, 100, 50);
    JLabel scalingMethodLabel = new JLabel();
    JComboBox scalingMethod = new JComboBox();
    JCheckBox hardwareScaling = new JCheckBox();
    JCheckBox progressiveMode = new JCheckBox();
    JCheckBox keepMetaData = new JCheckBox();
    JCheckBox mediaRSS = new JCheckBox();
    ControlPanel commentSourcesPanel = new ControlPanel();
    JCheckBox textFileComment = new JCheckBox();
    JCheckBox jpegComment = new JCheckBox();
    JCheckBox iptcCaption = new JCheckBox();
    JCheckBox exifUserComment = new JCheckBox();
    JCheckBox exifImageDescription = new JCheckBox();
    JTextField dateFormat = new JSmartTextField(16);
    JLabel dateFormatLabel = new JLabel();
    JCheckBox urlEncode = new JCheckBox();
    JTextField indexPageName = new JTextField(20);
    JLabel indexPageNameLabel = new JLabel();
    JCheckBox metaData = new JCheckBox();
    JCheckBox updatedDirsOnly = new JCheckBox();
    JCheckBox excludeByDefault = new JCheckBox();
    JCheckBox useThumbForFolderIcon = new JCheckBox();
    JLabel dateFormatTemplateLabel = new JLabel();
    JTextField pageExtension = new JTextField(20);
    JLabel pageExtensionLabel = new JLabel();
    JTextField thumbnailDirectory = new JTextField(20);
    JLabel thumbnailDirectoryLabel = new JLabel();
    JTextField closeupDirectory = new JTextField(20);
    JLabel closeupDirectoryLabel = new JLabel();
    JTextField slideDirectory = new JTextField(20);
    JLabel slideDirectoryLabel = new JLabel();
    JTextField thumbnailPrefix = new JTextField(20);
    JLabel thumbnailPrefixLabel = new JLabel();
    JTextField closeupPrefix = new JTextField(20);
    JLabel closeupPrefixLabel = new JLabel();
    JCheckBox includeDirectories = new JCheckBox();
    JLabel encodingLabel = new JLabel();
    JComboBox textEncoding = new JComboBox<String>(Msg.getCharsetNames());
    JCheckBox writeUTF8 = new JCheckBox();
    JScrollPane userVariablesScrollPane = new JScrollPane();
    JMapTable userVariablesTable = new JMapTable();
    JLabel ignorePatternLabel = new JLabel();
    JTextField ignorePattern = new JSmartTextField(16);
    JCheckBox widgetInjection = new JCheckBox();
    JCheckBox suppressIEWarnings = new JCheckBox();
    private Object skinUIMonitor = new Object();

    JSettingsWindow(JAlbumFrame frame) {
        super(frame);
        this.parent = frame;
        this.init();
    }

    private void init() {
        this.directoryLabel.setLabelFor(this.directory);
        this.chooseDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dir = JSettingsWindow.this.directory.getText();
                if (dir.length() > 0) {
                    File d = new File(dir);
                    if (d.isDirectory()) {
                        JSettingsWindow.this.directoryChooser.setCurrentDirectory(d);
                    }
                } else {
                    String myPicturesPath = System.getProperty("my.pictures.path");
                    if (myPicturesPath != null) {
                        File myPicturesDir = new File(myPicturesPath);
                        JSettingsWindow.this.directoryChooser.setCurrentDirectory(myPicturesDir);
                    }
                }
                int returnVal = JSettingsWindow.this.directoryChooser.showOpenDialog(JSettingsWindow.this);
                if (returnVal == 0) {
                    JSettingsWindow.this.directory.setText(JSettingsWindow.this.directoryChooser.getSelectedFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                    JSettingsWindow.this.parent.scanImageDirectory();
                }
            }
        });
        this.colsLabel.setLabelFor(this.cols);
        this.thumbSizeLabel.setLabelFor(this.thumbSize);
        this.imageSizeLabel.setLabelFor(this.imageSize);
        this.cols.setInputVerifier(new NumericVerifier());
        this.directory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JSettingsWindow.this.directorySelected();
            }
        });
        this.directoryChooser.setTitle(Msg.get("ui.chooseDirectoryToolTip"));
        this.outputDirectoryChooser.setTitle(Msg.get("ui.chooseDirectoryToolTip"));
        this.directoryChooser.setFileSelectionMode(1);
        this.outputDirectoryChooser.setFileSelectionMode(1);
        this.chooseDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseDirectoryButton.setIcon(this.parent.icons.openIcon);
        this.outputDirectoryPanel.addComponent(this.outputDirectory);
        this.outputDirectoryPanel.addComponent(this.outputDirectoryPanel);
        this.jFileDropPanel1.addComponent(this.directory);
        this.jFileDropPanel1.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e) {
                File droppedFile = e.getFirstFile();
                if (droppedFile.isDirectory()) {
                    JSettingsWindow.this.directory.setText(e.getFirstFile().getAbsolutePath());
                }
            }
        });
        this.imageSize.setEditable(true);
        this.thumbSize.setEditable(true);
        this.rowsLabel.setLabelFor(this.rows);
        this.outputDirectoryPanel.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e) {
                if (e.getFirstFile().isDirectory()) {
                    JSettingsWindow.this.outputDirectory.setText(e.getFirstFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                } else {
                    JSettingsWindow.this.parent.messageBox(Msg.get("ui.filesDroppedError2"));
                }
            }
        });
        this.outputDirectoryPanel.setLayout(new RiverLayout());
        this.outputDirectoryLabel.setLabelFor(this.outputDirectory);
        this.chooseOutputDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseOutputDirectoryButton.setIcon(this.parent.icons.openIcon);
        this.chooseOutputDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if (JSettingsWindow.this.outputDirectory.getText().length() > 0) {
                    File dir = new File(JSettingsWindow.this.outputDirectory.getText());
                    if (!dir.isAbsolute()) {
                        dir = new File(JSettingsWindow.this.directory.getText(), JSettingsWindow.this.outputDirectory.getText());
                    }
                    JSettingsWindow.this.outputDirectoryChooser.setCurrentDirectory(dir);
                }
                if ((returnVal = JSettingsWindow.this.outputDirectoryChooser.showOpenDialog(JSettingsWindow.this)) == 0) {
                    JSettingsWindow.this.outputDirectory.setText(JSettingsWindow.this.outputDirectoryChooser.getSelectedFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                }
            }
        });
        ComponentUtilities.whenSelectedDisable((AbstractButton)this.sameDirectory, this.outputDirectoryLabel, this.outputDirectory);
        this.sameDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.parent.fixUIdisabling();
            }
        });
        this.linkOriginals.setActionCommand("LinkOriginals");
        this.linkOriginals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.copyOriginals.setSelected(true);
                JSettingsWindow.this.parent.fixUIdisabling();
            }
        });
        this.linkOriginalsViaScaled.setActionCommand("LinkOriginalsViaScaled");
        this.linkOriginalsViaScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.copyOriginals.setSelected(true);
                JSettingsWindow.this.parent.fixUIdisabling();
            }
        });
        this.linkScaled.setSelected(true);
        this.linkScaled.setActionCommand("LinkScaled");
        this.linkScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.parent.fixUIdisabling();
            }
        });
        ActionListener linkingGuideListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.updateLinkingGuide();
            }
        };
        this.linkScaled.addActionListener(linkingGuideListener);
        this.linkOriginalsViaScaled.addActionListener(linkingGuideListener);
        this.linkOriginals.addActionListener(linkingGuideListener);
        this.slides.addActionListener(linkingGuideListener);
        this.outputDirectory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JSettingsWindow.this.directorySelected();
            }
        });
        this.keepMetaData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JSettingsWindow.this.keepMetaData.isSelected()) {
                    JOptionPane.showMessageDialog(JSettingsWindow.this, Msg.get("ui.keepMetaDataWarning"), Msg.get("ui.keepMetaDataInfo"), 2);
                }
            }
        });
        if (Platform.isMac()) {
            this.generalPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        this.generalPanel.add("br hfill", this.generalSettings);
        JPanel cp = new JCollapsiblePanel(Msg.get("ui.editFolderSettings"));
        ((JCollapsiblePanel)cp).setExpanded(this.parent.preferencesWindow.expandedFolderSettings.isSelected());
        ControlPanel directoriesPanel = new ControlPanel();
        directoriesPanel.add(this.directoryLabel);
        directoriesPanel.add("tab hfill", this.directory);
        directoriesPanel.add(this.chooseDirectoryButton);
        directoriesPanel.add("br", this.outputDirectoryLabel);
        directoriesPanel.add("tab hfill", this.outputDirectory);
        directoriesPanel.add(this.chooseOutputDirectoryButton);
        directoriesPanel.add("p", this.sameDirectory);
        ((JCollapsiblePanel)cp).setContentPanel(directoriesPanel);
        cp.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ((JSettingsWindow)JSettingsWindow.this).parent.preferencesWindow.expandedFolderSettings.setSelected((Boolean)evt.getNewValue());
                ((JSettingsWindow)JSettingsWindow.this).parent.preferencesWindow.savePreferences();
                JSettingsWindow.this.pack();
            }
        });
        this.generalPanel.add("br hfill", cp);
        if (Platform.isMac()) {
            this.pagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        ComponentUtilities.whenSelectedDisable((AbstractButton)this.linkOriginals, this.imageSizeLabel, this.imageSize);
        this.imageLinking.add(this.linkScaled);
        this.imageLinking.add(this.linkOriginals);
        this.imageLinking.add(this.linkOriginalsViaScaled);
        this.imageLinkingPanel.add("br", this.linkingGuide);
        this.imageLinkingPanel.add("p hfill", this.linkScaled);
        this.imageLinkingPanel.add("br hfill", this.linkOriginals);
        this.imageLinkingPanel.add("br hfill", this.linkOriginalsViaScaled);
        this.imageLinkingPanel.add("p hfill", this.copyOriginals);
        this.imageLinkingPanel.add("br hfill", this.slides);
        this.pagesPanel.add("br", this.imageLinkingPanel);
        cp = new ControlPanel();
        cp.setLayout(new PercentLayout(1, 9));
        this.thumbnailLayoutPanel.add("br", this.colsLabel);
        this.thumbnailLayoutPanel.add("tab", this.cols);
        this.thumbnailLayoutPanel.add("br", this.rowsLabel);
        this.thumbnailLayoutPanel.add("tab", this.rows);
        ((ControlPanel)cp).add(this.thumbnailLayoutPanel);
        this.imageOrderingPanel.add("hfill", this.imageOrdering);
        this.imageOrderingPanel.add("p hfill", this.reverseOrder);
        this.imageOrderingPanel.add("br hfill", this.directoriesFirst);
        ((ControlPanel)cp).add(this.imageOrderingPanel);
        this.pagesPanel.add(cp);
        this.pagesPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                JSettingsWindow.this.updateLinkingGuide();
            }
        });
        if (Platform.isMac()) {
            this.imagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        ControlPanel imageGenerationGroup = new ControlPanel();
        imageGenerationGroup.add("br", this.scalingMethodLabel);
        imageGenerationGroup.add("tab", this.scalingMethod);
        imageGenerationGroup.add("p hfill", this.sharpenPercentLabel);
        imageGenerationGroup.add("tab", this.sharpenPercent);
        imageGenerationGroup.add("br hfill", this.qualityPercentLabel);
        imageGenerationGroup.add("tab", this.qualityPercent);
        this.imagesPanel.add("br", imageGenerationGroup);
        JPanel left = new JPanel();
        left.setLayout(new RiverLayout());
        left.add("", this.thumbSizeLabel);
        left.add("tab", this.thumbSize);
        left.add("br", this.imageSizeLabel);
        left.add("tab", this.imageSize);
        this.imageBoundsPanel.add(left);
        this.imageBoundsPanel.add("", new JLabel(this.bboxIcon));
        this.imagesPanel.add("br", this.imageBoundsPanel);
        this.advancedImagesPanel.getContentPanel().setLayout(new RiverLayout());
        this.advancedImagesPanel.getContentPanel().add("br", this.hardwareScaling);
        this.advancedImagesPanel.getContentPanel().add("br", this.progressiveMode);
        this.advancedImagesPanel.getContentPanel().add("br", this.imageBackgroundColorLabel);
        this.advancedImagesPanel.getContentPanel().add(this.imageBackgroundColor);
        this.advancedImagesPanel.getContentPanel().add(this.imageBackgroundColor.getTextComponent());
        this.imagesPanel.add("p hfill", this.advancedImagesPanel);
        this.advancedImagesPanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JSettingsWindow.this.pack();
            }
        });
        this.qualityPercent.setMajorTickSpacing(25);
        this.qualityPercent.setMinorTickSpacing(5);
        this.qualityPercent.setSnapToTicks(true);
        this.qualityPercent.setPaintTicks(true);
        this.qualityPercent.setPaintLabels(true);
        this.qualityPercentLabel.setLabelFor(this.qualityPercent);
        this.sharpenPercent.setMajorTickSpacing(25);
        this.sharpenPercent.setMinorTickSpacing(5);
        this.sharpenPercent.setSnapToTicks(true);
        this.sharpenPercent.setPaintTicks(true);
        this.sharpenPercent.setPaintLabels(true);
        this.sharpenPercentLabel.setLabelFor(this.sharpenPercent);
        this.textEncoding.setEditable(true);
        this.dateFormatLabel.setLabelFor(this.dateFormat);
        this.indexPageNameLabel.setLabelFor(this.indexPageName);
        this.dateFormatTemplateLabel.setFont(new Font("Dialog", 0, 10));
        this.pageExtensionLabel.setLabelFor(this.pageExtension);
        this.thumbnailDirectoryLabel.setLabelFor(this.thumbnailDirectory);
        this.thumbnailDirectoryLabel.setEnabled(false);
        this.thumbnailDirectory.setEnabled(false);
        this.closeupDirectoryLabel.setLabelFor(this.closeupDirectory);
        this.closeupDirectoryLabel.setEnabled(false);
        this.closeupDirectory.setEnabled(false);
        this.slideDirectoryLabel.setLabelFor(this.slideDirectory);
        this.slideDirectoryLabel.setEnabled(false);
        this.slideDirectory.setEnabled(false);
        this.thumbnailPrefixLabel.setLabelFor(this.thumbnailPrefix);
        this.thumbnailPrefixLabel.setEnabled(false);
        this.thumbnailPrefix.setEnabled(false);
        this.closeupPrefixLabel.setLabelFor(this.closeupPrefix);
        this.closeupPrefixLabel.setEnabled(false);
        this.closeupPrefix.setEnabled(false);
        this.advancedPanel.setBorder(BorderFactory.createEmptyBorder(12, 9, 6, 9));
        this.advGeneralPanel.add("p", this.encodingLabel);
        this.advGeneralPanel.add("tab", this.textEncoding);
        this.advGeneralPanel.add("hfill", this.writeUTF8);
        this.advGeneralPanel.add("br", this.dateFormatLabel);
        this.advGeneralPanel.add("tab", this.dateFormat);
        this.advGeneralPanel.add("hfill", this.dateFormatTemplateLabel);
        this.advGeneralPanel.add("br", this.ignorePatternLabel);
        this.advGeneralPanel.add("tab", this.ignorePattern);
        this.advGeneralPanel.add("br", new JLabel());
        this.advGeneralPanel.add("br hfill", this.subdirs);
        this.advGeneralPanel.add("br hfill", this.updatedDirsOnly);
        this.advGeneralPanel.add("br hfill", this.includeDirectories);
        this.advGeneralPanel.add("br hfill", this.useThumbForFolderIcon);
        this.advGeneralPanel.add("br hfill", this.excludeByDefault);
        this.advancedPanel.addTab(Msg.get("ui.mainPanel"), this.advGeneralPanel);
        this.advMetadataPanel.add("br", this.commentSourcesPanel);
        this.advMetadataPanel.add("p hfill", this.metaData);
        this.advMetadataPanel.add("br hfill", this.keepMetaData);
        this.advMetadataPanel.add("br hfill", this.widgetInjection);
        this.advMetadataPanel.add("br hfill", this.suppressIEWarnings);
        this.advMetadataPanel.add("br hfill", this.mediaRSS);
        this.advancedPanel.addTab(Msg.get("ui.metadataPanel"), this.advMetadataPanel);
        this.advNamingPanel.add("p hfill", this.indexPageNameLabel);
        this.advNamingPanel.add("tab", this.indexPageName);
        this.advNamingPanel.add("br hfill", this.pageExtensionLabel);
        this.advNamingPanel.add("tab", this.pageExtension);
        this.advNamingPanel.add("br hfill", this.thumbnailDirectoryLabel);
        this.advNamingPanel.add("tab", this.thumbnailDirectory);
        this.advNamingPanel.add("br hfill", this.closeupDirectoryLabel);
        this.advNamingPanel.add("tab", this.closeupDirectory);
        this.advNamingPanel.add("br hfill", this.slideDirectoryLabel);
        this.advNamingPanel.add("tab", this.slideDirectory);
        this.advNamingPanel.add("br hfill", this.thumbnailPrefixLabel);
        this.advNamingPanel.add("tab", this.thumbnailPrefix);
        this.advNamingPanel.add("br hfill", this.closeupPrefixLabel);
        this.advNamingPanel.add("tab", this.closeupPrefix);
        this.advNamingPanel.add("p hfill", this.urlEncode);
        this.advancedPanel.addTab(Msg.get("ui.namingPanel"), this.advNamingPanel);
        this.commentSourcesPanel.add("hfill", this.textFileComment);
        this.commentSourcesPanel.add("br hfill", this.jpegComment);
        this.commentSourcesPanel.add("br hfill", this.iptcCaption);
        this.commentSourcesPanel.add("br hfill", this.exifUserComment);
        this.commentSourcesPanel.add("br hfill", this.exifImageDescription);
        this.userVariablesScrollPane.getViewport().add(this.userVariablesTable);
        this.userVariablesScrollPane.setPreferredSize(new Dimension(50, 50));
        if (Platform.isMac()) {
            this.userVariablesScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.advUserVariablesPanel.setLayout(new BorderLayout());
        this.advUserVariablesPanel.add((Component)this.userVariablesScrollPane, "Center");
        this.advUserVariablesPanel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.advancedPanel.addTab(Msg.get("ui.varsPanel"), this.advUserVariablesPanel);
        this.skinSettingsPanel.setLayout(new BorderLayout());
        this.buttonBarPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component previousPanel = JSettingsWindow.this.currentPanel;
                JSettingsWindow.this.currentPanel = JSettingsWindow.this.buttonBarPane.getSelectedComponent();
                if (previousPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.parent.fireSkinUIHidden(new JAlbumEvent(this));
                } else if (JSettingsWindow.this.currentPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.parent.fireSkinUIDisplayed(new JAlbumEvent(this));
                }
            }
        });
        Container c = this.getContentPane();
        c.add((Component)this.buttonBarPane, "Center");
        AbstractAction closeAction = new AbstractAction(Msg.get("ok")){

            public void actionPerformed(ActionEvent e) {
                JSettingsWindow.this.setVisible(false);
                if (!JSettingsWindow.this.directory.getText().equals(((JSettingsWindow)JSettingsWindow.this).parent.engine.getDirectory())) {
                    JSettingsWindow.this.parent.initView();
                }
                JSettingsWindow.this.parent.ui2Engine();
            }
        };
        this.registerActions(closeAction);
    }

    boolean isSkinUISelected() {
        return this.buttonBarPane.getSelectedComponent() == this.skinSettingsPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSkinUI(ControlPanel ui) {
        Object object = this.skinUIMonitor;
        synchronized (object) {
            if (this.skinUI != null) {
                this.skinSettingsPanel.remove(this.skinUI);
            }
            this.skinUI = ui;
            if (ui != null) {
                this.skinSettingsPanel.add(ui);
                PropertyBinder.syncUI(this.parent.engine.getUserVariables(), ui);
                PropertyBinder.syncUI(this.parent.engine.getSkinVariables(), ui);
            }
            this.buttonBarPane.remove(this.skinSettingsPanel);
            this.parent.actions.skinSettingsAction.setEnabled(false);
            if (ui != null) {
                this.buttonBarPane.addTab(this.parent.mainSettingsPanel.getSelectedSkin(), Icons.getIcon("settings.skin"), this.skinSettingsPanel);
                this.buttonBarPane.validate();
                this.parent.actions.skinSettingsAction.setEnabled(true);
            }
        }
    }

    private void updateLinkingGuide() {
        ImageIcon icon = null;
        if (this.slides.isSelected()) {
            if (this.linkScaled.isSelected()) {
                icon = this.thumbnailsSlideIcon;
            } else if (this.linkOriginalsViaScaled.isSelected()) {
                icon = this.thumbnailsSlideOriginalIcon;
            } else if (this.linkOriginals.isSelected()) {
                icon = this.thumbnailsOriginalIcon;
            }
        } else if (this.linkScaled.isSelected()) {
            icon = this.thumbnailsScaledNoSlidesIcon;
        } else if (this.linkOriginalsViaScaled.isSelected()) {
            icon = this.thumbnailsScaledNoSlidesIcon;
        } else if (this.linkOriginals.isSelected()) {
            icon = this.thumbnailsOriginalsNoSlidesIcon;
        }
        this.linkingGuide.setIcon(icon);
    }

    void populateWithDefaultTabs() {
        this.buttonBarPane.addTab(Msg.get("ui.mainPanel"), Icons.getIcon("settings.general"), this.generalPanel);
        this.buttonBarPane.addTab(Msg.get("ui.pagesPanel"), Icons.getIcon("settings.pages"), this.pagesPanel);
        this.buttonBarPane.addTab(Msg.get("ui.imagesPanel"), Icons.getIcon("settings.images"), this.imagesPanel);
        this.buttonBarPane.addTab(Msg.get("ui.advancedPanel"), Icons.getIcon("settings.advanced"), this.advancedPanel);
    }

    void setTexts() {
        this.renameTab(this.generalPanel, Msg.get("ui.mainPanel"));
        this.renameTab(this.imagesPanel, Msg.get("ui.imagesPanel"));
        this.renameTab(this.pagesPanel, Msg.get("ui.navigationPanel"));
        this.renameTab(this.advancedPanel, Msg.get("ui.advancedPanel"));
        this.renameAdvancedTab(this.advGeneralPanel, Msg.get("ui.mainPanel"));
        this.renameAdvancedTab(this.advMetadataPanel, Msg.get("ui.metadataPanel"));
        this.renameAdvancedTab(this.advNamingPanel, Msg.get("ui.namingPanel"));
        this.renameAdvancedTab(this.advUserVariablesPanel, Msg.get("ui.varsPanel"));
        this.generalSettings.setTexts();
        this.directoryLabel.setText(Msg.get("ui.imageDirectoryLabel"));
        this.imageBoundsPanel.setTitle(Msg.get("ui.imageBoundsBorder"));
        this.imageOrderingPanel.setTitle(Msg.get("ui.imageOrderingBorder"));
        this.imageLinkingPanel.setTitle(Msg.get("ui.imageLinkingBorder"));
        this.thumbnailLayoutPanel.setTitle(Msg.get("ui.thumbnailLayoutBorder"));
        this.subdirs.setText(Msg.get("ui.processSubdirectoriesCheckbox"));
        this.subdirs.setToolTipText(Msg.get("ui.processSubdirectoriesToolTip"));
        this.imageSizeLabel.setText(Msg.get("ui.imagesLabel"));
        this.colsLabel.setText(Msg.get("ui.columnsLabel"));
        this.thumbSizeLabel.setText(Msg.get("ui.thumbnailsLabel"));
        this.advancedImagesPanel.setTitle(Msg.get("ui.advancedPanel"));
        this.imageBackgroundColorLabel.setText(Msg.get("ui.imageBackgroundColor"));
        this.imageBackgroundColor.setTitle(Msg.get("ui.imageBackgroundColor"));
        this.chooseDirectoryButton.setToolTipText(Msg.get("ui.chooseDirectoryToolTip"));
        this.directory.setToolTipText(Msg.get("ui.imageDirectoryToolTip"));
        this.imageSize.setToolTipText(Msg.get("ui.imageSizeToolTip"));
        this.thumbSize.setToolTipText(Msg.get("ui.thumbSizeToolTip"));
        this.slides.setText(Msg.get("ui.makeSlides"));
        this.slides.setToolTipText(Msg.get("ui.makeSlidesToolTip"));
        this.rowsLabel.setText(Msg.get("ui.rows"));
        this.outputDirectoryLabel.setText(Msg.get("ui.outputDirectory"));
        this.chooseOutputDirectoryButton.setToolTipText(Msg.get("ui.outputDirectoryToolTip"));
        this.copyOriginals.setText(Msg.get("ui.copyOriginals"));
        this.copyOriginals.setToolTipText(Msg.get("ui.copyOriginalsToolTip"));
        this.sameDirectory.setText(Msg.get("ui.sameDirectory"));
        this.linkOriginals.setText(Msg.get("ui.linkToOriginals"));
        this.linkOriginalsViaScaled.setText(Msg.get("ui.linkToOriginalsViaScaledImages"));
        this.linkScaled.setText(Msg.get("ui.linkToScaledImagesOnly"));
        this.scalingMethod.removeAllItems();
        HashMap<String, String> sm = new HashMap<String, String>();
        sm.put("ScaleFast", Msg.get("ui.scaleFast"));
        sm.put("ScaleMedium", Msg.get("ui.scaleMedium"));
        sm.put("ScaleSmooth", Msg.get("ui.scaleSmooth"));
        for (String methodName : ImageScaler.getScalerNames()) {
            String translated = (String)sm.get(methodName);
            if (translated == null) {
                translated = methodName;
            }
            this.scalingMethod.addItem(new Item(methodName, translated));
        }
        this.imageOrdering.removeAllItems();
        this.imageOrdering.addItem(new Item("OrderByDate", Msg.get("ui.dateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByName", Msg.get("ui.nameOrdering")));
        this.imageOrdering.addItem(new Item("OrderBySimpleName", Msg.get("ui.simpleNameOrdering")));
        this.rows.setToolTipText(Msg.get("ui.rowsToolTip") + Msg.get("ui.rowsToolTip2"));
        this.reverseOrder.setText(Msg.get("ui.reverseOrder"));
        this.directoriesFirst.setText(Msg.get("ui.directoriesFirst"));
        this.directoriesFirst.setToolTipText(Msg.get("ui.directoriesFirstToolTip"));
        this.outputDirectory.setToolTipText(Msg.get("ui.outputDirectoryToolTip"));
        this.dateFormatLabel.setText(Msg.get("ui.dateFormat"));
        this.urlEncode.setText(Msg.get("ui.urlEncode"));
        this.urlEncode.setToolTipText(Msg.get("ui.urlEncodeToolTip"));
        this.indexPageNameLabel.setText(Msg.get("ui.indexPageName"));
        this.metaData.setText(Msg.get("ui.metaData"));
        this.metaData.setToolTipText(Msg.get("ui.metaDataToolTip"));
        this.updatedDirsOnly.setText(Msg.get("ui.updatedDirsOnly"));
        this.updatedDirsOnly.setToolTipText(Msg.get("ui.updatedDirsOnlyToolTip"));
        this.excludeByDefault.setText(Msg.get("ui.excludeByDefault"));
        this.excludeByDefault.setToolTipText(Msg.get("ui.excludeByDefaultToolTip"));
        this.useThumbForFolderIcon.setText(Msg.get("ui.useThumbForFolderIcon"));
        this.useThumbForFolderIcon.setToolTipText(Msg.get("ui.useThumbForFolderIconToolTip"));
        this.dateFormatTemplateLabel.setText(Msg.get("ui.dateFormatTemplate"));
        this.dateFormat.setToolTipText(Msg.get("ui.dateFormatTemplateToolTip"));
        this.ignorePatternLabel.setText(Msg.get("ui.ignorePattern"));
        this.commentSourcesPanel.setTitle(Msg.get("ui.commentSourcesBorder"));
        this.commentSourcesPanel.setToolTipText(Msg.get("ui.commentSourcesToolTip"));
        this.textFileComment.setText(Msg.get("ui.textFileComment"));
        this.jpegComment.setText(Msg.get("ui.jpegComment"));
        this.iptcCaption.setText(Msg.get("ui.iptcCaption"));
        this.exifUserComment.setText(Msg.get("ui.exifUserComment"));
        this.exifImageDescription.setText(Msg.get("ui.exifImageDescription"));
        this.ignorePattern.setToolTipText(Msg.get("ui.ignorePatternToolTip"));
        this.qualityPercentLabel.setText(Msg.get("ui.jpegQuality"));
        this.sharpenPercentLabel.setText(Msg.get("ui.sharpenAmount"));
        this.scalingMethodLabel.setText(Msg.get("ui.scalingMethod"));
        this.hardwareScaling.setText(Msg.get("ui.hardwareScaling"));
        this.hardwareScaling.setToolTipText(Msg.get("ui.hardwareScalingToolTip"));
        this.progressiveMode.setText(Msg.get("ui.progressiveMode"));
        this.progressiveMode.setToolTipText(Msg.get("ui.progressiveModeToolTip"));
        this.keepMetaData.setText(Msg.get("ui.keepMetaDataInfo"));
        this.keepMetaData.setToolTipText(Msg.get("ui.metaDataToolTip"));
        this.widgetInjection.setText(Msg.get("ui.widgetSupport"));
        this.suppressIEWarnings.setText(Msg.get("ui.suppressIEWarnings"));
        this.suppressIEWarnings.setToolTipText(Msg.get("ui.suppressIEWarningsToolTip"));
        this.mediaRSS.setText(Msg.get("ui.mediaRSS"));
        this.mediaRSS.setToolTipText(Msg.get("ui.mediaRSSToolTip"));
        this.qualityPercent.setToolTipText(Msg.get("ui.qualityPercentToolTip"));
        this.pageExtensionLabel.setText(Msg.get("ui.pageExtension"));
        this.thumbnailDirectoryLabel.setText(Msg.get("ui.thumbnailDirectory"));
        this.closeupDirectoryLabel.setText(Msg.get("ui.closeupDirectory"));
        this.slideDirectoryLabel.setText(Msg.get("ui.slideDirectory"));
        this.thumbnailPrefixLabel.setText(Msg.get("ui.thumbnailPrefix"));
        this.closeupPrefixLabel.setText(Msg.get("ui.closeupPrefix"));
        this.includeDirectories.setText(Msg.get("ui.includeDirectories"));
        this.userVariablesTable.setToolTipText(Msg.get("ui.userVariablesToolTip"));
        this.encodingLabel.setText(Msg.get("ui.encoding"));
        this.writeUTF8.setText(Msg.get("ui.writeUTF8"));
        this.writeUTF8.setToolTipText(Msg.get("ui.writeUTF8ToolTip"));
        this.textEncoding.setToolTipText(Msg.get("ui.textEncodingToolTip"));
        this.userVariablesTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
    }

    private void renameTab(JComponent comp, String newName) {
        int index = this.buttonBarPane.indexOfTab(comp);
        if (index != -1) {
            this.buttonBarPane.setTitleAt(index, newName);
        }
    }

    private void renameAdvancedTab(Component comp, String newName) {
        for (int i = 0; i < this.advancedPanel.getTabCount(); ++i) {
            Component c = this.advancedPanel.getComponentAt(i);
            if (c != comp) continue;
            this.advancedPanel.setTitleAt(i, newName);
            break;
        }
    }

    String getImageSize() {
        return this.imageSize.getSelectedItem().toString();
    }

    void setImageSize(String size) {
        this.imageSize.setSelectedItem(size);
    }

    String getThumbsSize() {
        return this.thumbSize.getSelectedItem().toString();
    }

    void setThumbsSize(String size) {
        this.thumbSize.setSelectedItem(size);
    }

    boolean getSameDirectory() {
        return this.sameDirectory.isSelected();
    }

    boolean getLinkScaled() {
        return this.linkScaled.isSelected();
    }

    boolean getLinkOriginals() {
        return this.linkOriginals.isSelected();
    }

    boolean getCopyOriginals() {
        return this.copyOriginals.isSelected();
    }

    String getDirectory() {
        return this.directory.getText();
    }

    String getOutputDirectory() {
        return this.outputDirectory.getText();
    }

    void directorySelected() {
        this.parent.directorySelected();
    }
}

