/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.CompoundAction;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartTextComponentSupport;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.JWizard;
import se.datadosen.component.JWizardStep;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAddAccountDialog;
import se.datadosen.jalbum.JAdvancedAccountSettingsDialog;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JToolBarButton;
import se.datadosen.jalbum.JUploadProgressDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.RemoteFSContext;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.RemoteFSTreeCellRenderer;
import se.datadosen.jalbum.RemoteFSTreeTransferHandler;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Callback;
import se.datadosen.util.Debug;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;

public class JPublishWizard
extends JWizard {
    private static Callback onCreate;
    AccountManager accountManager = AccountManager.getInstance();
    AccountProfile currentAccount;
    AlbumBean engine;
    JAlbumContext context;
    UploadBean uploadBean = new UploadBean();
    RemoteFSNode rootNode;
    Set<String> protectedPaths;
    AccountsStep accountsStep;
    PublishStep publishStep;

    public JPublishWizard(JAlbumContext context) {
        super(context.getFrame(), Msg.get("ui.publishPanel"), false, new ImageIcon(JPublishWizard.class.getResource("images/publish/dor-publish.png")));
        this.context = context;
        this.engine = context.getEngine();
        this.allowFinish(false);
        this.backAction.putValue("Name", Msg.get("wiz.back"));
        this.cancelAction.putValue("Name", Msg.get("close"));
        this.accountsStep = new AccountsStep();
        this.publishStep = new PublishStep();
        this.addStep(this.accountsStep);
        this.addStep(this.publishStep);
        if (onCreate != null) {
            onCreate.call(this);
        }
    }

    public static void setOnCreate(Callback callback) {
        onCreate = callback;
    }

    protected void updateTitle() {
        if (this.steps.size() > 1) {
            this.setTitle(this.title + " - " + Msg.get("wiz.stepInfo", this.stepIndex + 1, this.steps.size()));
        } else {
            this.setTitle(this.title);
        }
    }

    public void onHide() {
        try {
            this.uploadBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onHide();
    }

    static String showPasswordInputDialog(Component parent, String message, String title, String initialValue) {
        JPasswordField jpf = new JPasswordField();
        if (initialValue != null) {
            jpf.setText(initialValue);
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new RiverLayout());
        messagePanel.add(new JLabel(message));
        messagePanel.add("br hfill", jpf);
        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.setVisible(true);
        Object val = pane.getValue();
        if (val instanceof Integer && (Integer)val == 0) {
            return new String(jpf.getPassword());
        }
        return null;
    }

    String getFtpWebRootDirectory() {
        if (this.currentAccount.getFtpWebRootDirectory().equals("VALUE_UNSET")) {
            return "VALUE_UNSET";
        }
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.currentAccount.getFtpWebRootDirectory()) : this.toRelative(this.currentAccount.getFtpWebRootDirectory());
    }

    void setFtpWebRootDirectory(String path) {
        this.currentAccount.setFtpWebRootDirectory(this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(path) : this.toRelative(path));
    }

    String getRemoteDirectory() {
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.engine.getRemoteDirectory()) : this.toRelative(this.engine.getRemoteDirectory());
    }

    void setRemoteDirectory(String path) {
        this.engine.setRemoteDirectory(this.currentAccount.isShowServerRootDirectory() ? path : this.toRelative(path));
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.uploadBean.getBaseDirectory(), path);
    }

    private String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.uploadBean.getBaseDirectory());
        if (rel.startsWith("..")) {
            return path;
        }
        if (".".equals(rel)) {
            return "";
        }
        return rel;
    }

    abstract class DiskSpaceReporter {
        private final File albumRoot;
        private final String userName;
        private boolean interrupted = false;
        private long size = 0L;
        protected long remoteAlbumSize;
        private DecimalFormat twoDec = new DecimalFormat("0.##");
        private int clusterSize = 1;

        public DiskSpaceReporter(File albumRoot, String myJAlbumUserName, long remoteAlbumSize) {
            this.albumRoot = albumRoot;
            this.userName = myJAlbumUserName;
            this.remoteAlbumSize = remoteAlbumSize;
            this.clusterSize = JAlbumSite.getInstance().getMyJAlbumFileClusterSize();
            this.size += (long)this.clusterSize;
            new Thread("calculate local album size"){

                public void run() {
                    DiskSpaceReporter.this.processDir(DiskSpaceReporter.this.albumRoot);
                    DiskSpaceReporter.this.localAlbumSizeCalculated(DiskSpaceReporter.this.size);
                }
            }.start();
            if (this.userName == null) {
                return;
            }
            new Thread("calculate quota"){

                public void run() {
                    try {
                        URL quotaURL = new URL(JAlbumSite.getTrueInstance().getMyJAlbumQuotaUrl());
                        HttpConnection conn = new HttpConnection(quotaURL);
                        Properties data = new Properties();
                        data.setProperty("userName", DiskSpaceReporter.this.userName);
                        HttpResponse resp = conn.Post(data);
                        if (resp.getStatusCode() != 200) {
                            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
                        }
                        String content = resp.getContentAsString();
                        Element result = Elements.getElementByName("result", content, false);
                        if (result != null) {
                            DiskSpaceReporter.this.quotaCalculated(Long.parseLong(result.getAttribute("usage")) * 1024L, Long.parseLong(result.getAttribute("quota")) * 1024L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }

        public void interrupt() {
            this.interrupted = true;
        }

        protected String formatAsMB(long bytes) {
            return this.twoDec.format((double)bytes / 1024.0 / 1024.0);
        }

        public abstract void localAlbumSizeCalculated(long var1);

        public abstract void quotaCalculated(long var1, long var3);

        private long toClusterSize(long size) {
            return (size + (long)this.clusterSize - 1L) / (long)this.clusterSize * (long)this.clusterSize;
        }

        private void processDir(File dir) {
            if (this.interrupted) {
                return;
            }
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (this.interrupted) {
                    return;
                }
                File f = files[i];
                if (f.isDirectory()) {
                    this.size += (long)this.clusterSize;
                    this.processDir(f);
                    continue;
                }
                this.size += this.toClusterSize(f.length());
            }
        }
    }

    class ConfirmDialog
    extends JDialog
    implements ActionListener {
        private Object source;
        JButton okButton;
        JButton cancelButton;
        JButton changeLocationButton;

        public ConfirmDialog(JDialog parent, Object[] message, String title) {
            super(parent, title, true);
            this.okButton = new JButton(Msg.get("ok"));
            this.cancelButton = new JButton(Msg.get("cancel"));
            this.changeLocationButton = new JButton(Msg.get("ui.changeLocation"));
            this.getRootPane().setDefaultButton(this.okButton);
            Container c = this.getContentPane();
            c.setLayout((LayoutManager)new MigLayout("fill, insets dialog"));
            for (Object o : message) {
                if (o == null) continue;
                c.add((Component)o, "wrap");
            }
            c.add((Component)this.changeLocationButton, "split 3,");
            c.add((Component)this.okButton, "tag ok");
            c.add((Component)this.cancelButton, "tag cancel");
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.changeLocationButton.addActionListener(this);
            if (JPublishWizard.this.isVisible()) {
                this.changeLocationButton.setVisible(false);
            }
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        public int showConfirmDialog() {
            this.setVisible(true);
            return this.source == this.okButton ? 0 : 2;
        }

        public void actionPerformed(ActionEvent e) {
            this.source = e.getSource();
            this.setVisible(false);
        }

        public boolean isChangeLocation() {
            return this.source == this.changeLocationButton;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PublishStep
    extends JWizardStep
    implements RemoteFSContext {
        ImageIcon folderEarthIcon;
        ImageIcon folderNewIcon;
        ImageIcon deleteIcon;
        ImageIcon folderRefreshIcon;
        ImageIcon editIcon;
        ImageIcon uploadIcon;
        ImageIcon lockIcon;
        ImageIcon gaugeIcon;
        ImageIcon advancedIcon;
        ImageIcon copyIcon;
        Action newDirectoryAction;
        Action deleteAction;
        Action renameAction;
        Action refreshDirectoryAction;
        Action markAsWebRootAction;
        Action passwordProtectAction;
        Action getQuotaAction;
        JToggleButton advancedModeButton;
        Action advancedModeAction;
        Action copyURLAction;
        Action smartUploadAction;
        Action uploadAllAction;
        Action uploadAction;
        JToolBar remoteToolBar;
        JTree tree;
        DefaultTreeModel treeModel;
        RemoteFSTreeCellRenderer customRenderer;
        JPopupMenu treeMenu;
        JScrollPane remoteTreeScrollPane;
        JLabel previewLinkLabel;
        JLinkLabel previewLink;
        JButton copyURLButton;
        Notifier notifier;

        PublishStep() {
            super(Msg.get("publish.selectDirectory"));
            this.folderEarthIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/folder_earth.png"));
            this.folderNewIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/folder_new.png"));
            this.deleteIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/delete.png"));
            this.folderRefreshIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/folder_refresh.png"));
            this.editIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/edit.png"));
            this.uploadIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/server_from_client.png"));
            this.lockIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/lock.png"));
            this.gaugeIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/gauge.png"));
            this.advancedIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/wrench.png"));
            this.copyIcon = new ImageIcon(JSmartTextComponentSupport.class.getResource("images/copy.png"));
            this.newDirectoryAction = new AbstractAction(Msg.get("publish.newDirectory"), this.folderNewIcon){

                public void actionPerformed(ActionEvent e) {
                    RemoteFSNode selNode = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (selNode != null) {
                        String defaultAlbumName = Msg.get("publish.newDirectory");
                        JPublishWizard.this.context.getFrame().ui2Engine();
                        String projectName = PublishStep.this.getProjectName();
                        if (projectName.length() > 0) {
                            defaultAlbumName = projectName;
                        }
                        RemoteFSNode newNode = new RemoteFSNode(PublishStep.this.uniqueName(selNode, defaultAlbumName), null, (RemoteFSContext)JPublishWizard.this.publishStep);
                        PublishStep.this.treeModel.insertNodeInto(newNode, selNode, 0);
                        Object[] nodes = PublishStep.this.treeModel.getPathToRoot(newNode);
                        TreePath path = new TreePath(nodes);
                        PublishStep.this.tree.expandPath(path);
                        PublishStep.this.tree.setSelectionPath(path);
                        PublishStep.this.tree.startEditingAtPath(path);
                    }
                }
            };
            this.deleteAction = new AbstractAction(Msg.get("edit.delete"), this.deleteIcon){

                public void actionPerformed(ActionEvent e) {
                    final RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (!node.isLink() && !node.isLeaf()) {
                        try {
                            int answer;
                            RemoteFile[] files = JPublishWizard.this.uploadBean.getRemoteFS().getFiles(node.remotePath(), RemoteFSBean.noDotDotDotFileFilter);
                            if (files.length > 0 && (answer = JOptionPane.showConfirmDialog(JPublishWizard.this, Msg.get("publish.DeleteDirectoryWarning", node), Msg.get("publish.deleteDirectory"), 0, 2)) != 0) {
                                return;
                            }
                        }
                        catch (Exception ex) {
                            Debug.showStackTraceDialog(JPublishWizard.this, ex);
                            return;
                        }
                    }
                    final JProgressDialog progressDialog = new JProgressDialog((Dialog)JPublishWizard.this, Msg.get("publish.deletingDirectoryInfo", node), true, true);
                    progressDialog.setSize(new Dimension(350, 180));
                    progressDialog.setIndeterminate(true);
                    JPublishWizard.this.uploadBean.addAlbumBeanListener(progressDialog);
                    new Thread("DirectoryDeletingThread"){
                        {
                            super(x0);
                            this.setDaemon(true);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                if (node.isLink() || node.isLeaf()) {
                                    JPublishWizard.this.uploadBean.getRemoteFS().removeFile(node.remotePath());
                                } else {
                                    JPublishWizard.this.uploadBean.deleteDirectory(node.remotePath());
                                    JPublishWizard.this.protectedPaths = null;
                                    if (PublishStep.this.notifier != null) {
                                        PublishStep.this.notifier.albumDeletedBg(JPublishWizard.this.currentAccount, PublishStep.this.getUrl(node.remotePath()));
                                    }
                                }
                                PublishStep.this.tree.setSelectionPath(new TreePath(node.getParent()));
                                PublishStep.this.treeModel.removeNodeFromParent(node);
                            }
                            catch (OperationAbortedException ex) {
                                PublishStep.this.refreshFrom(node);
                            }
                            catch (Exception ex) {
                                Debug.showErrorDialog(JPublishWizard.this, ex);
                                PublishStep.this.tree.setSelectionPath(new TreePath(node.getParent()));
                                PublishStep.this.refreshFrom((RemoteFSNode)node.getParent());
                            }
                            finally {
                                JPublishWizard.this.uploadBean.removeAlbumBeanListener(progressDialog);
                                progressDialog.updateStateAndSetVisible(false);
                            }
                        }
                    }.start();
                    progressDialog.updateStateAndSetVisible(true);
                }
            };
            this.renameAction = new AbstractAction(Msg.get("edit.renameFile"), this.editIcon){

                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                }
            };
            this.refreshDirectoryAction = new AbstractAction(Msg.get("publish.refreshDirectory"), this.folderRefreshIcon){

                public void actionPerformed(ActionEvent e) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (node != null && node.isLeaf()) {
                        node = (RemoteFSNode)node.getParent();
                    }
                    if (node == null) {
                        node = (RemoteFSNode)PublishStep.this.tree.getModel().getRoot();
                    }
                    PublishStep.this.refreshFrom(node);
                }
            };
            this.markAsWebRootAction = new AbstractAction(Msg.get("publish.markAsWebRoot"), this.folderEarthIcon){

                public void actionPerformed(ActionEvent e) {
                    String answer = (String)JOptionPane.showInputDialog(JPublishWizard.this, Msg.get("publish.markAsWebRootInfo"), Msg.get("publish.markAsWebRoot"), 1, null, null, JPublishWizard.this.currentAccount.getWebRootURL());
                    if (answer != null) {
                        JPublishWizard.this.currentAccount.setWebRootURL(answer);
                        JPublishWizard.this.setFtpWebRootDirectory(JPublishWizard.this.toRelative(((RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent()).remotePath()));
                        JPublishWizard.this.accountsStep.saveAccounts();
                        TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), PublishStep.this.treeModel);
                        PublishStep.this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
                        PublishStep.this.tree.repaint();
                        PublishStep.this.updateView();
                    }
                }
            };
            this.passwordProtectAction = new AbstractAction(Msg.get("publish.passwordProtect"), this.lockIcon){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = JAlbumSite.getTrueInstance().getMyJAlbumPasswordProtectUrl(JPublishWizard.this.currentAccount.getFtpServer());
                        if (s == null) {
                            return;
                        }
                        URL passwordProtectURL = new URL(s);
                        HttpConnection conn = new HttpConnection(passwordProtectURL);
                        ControlPanel messagePanel = new ControlPanel();
                        final JPasswordField jpf = new JPasswordField();
                        ((Container)messagePanel).add("br", new JLabel(Msg.get("ui.password")));
                        ((Container)messagePanel).add("tab hfill", jpf);
                        ((Container)messagePanel).add("br", new JLabel(Msg.get("publish.leaveBlankHint")));
                        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
                        JDialog dialog = pane.createDialog(JPublishWizard.this, Msg.get("publish.passwordProtect"));
                        dialog.addWindowListener(new WindowAdapter(){

                            public void windowOpened(WindowEvent e) {
                                jpf.requestFocusInWindow();
                            }
                        });
                        dialog.setVisible(true);
                        Object val = pane.getValue();
                        if (val instanceof Integer && (Integer)val != 0) {
                            return;
                        }
                        if (!(val instanceof Integer)) {
                            return;
                        }
                        Properties data = new Properties();
                        data.setProperty("ownerUserName", JPublishWizard.this.currentAccount.getFtpUser());
                        data.setProperty("ownerPassword", DigestUtil.md5(JPublishWizard.this.currentAccount.getFtpPassword()));
                        data.setProperty("password", new String(jpf.getPassword()));
                        data.setProperty("path", ((RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent()).remotePath());
                        HttpResponse resp = conn.Post(data);
                        if (resp.getStatusCode() != 200) {
                            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
                        }
                        String content = resp.getContentAsString();
                        if (!content.trim().equals("OK")) {
                            throw new Exception(content);
                        }
                        JPublishWizard.this.protectedPaths = null;
                        RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                        node.invalidateNodeOnly();
                        PublishStep.this.treeModel.nodeChanged(node);
                    }
                    catch (Exception ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.getQuotaAction = new AbstractAction(Msg.get("publish.getQuota"), this.gaugeIcon){

                public void actionPerformed(ActionEvent e) {
                    try {
                        URL quotaURL = new URL(JAlbumSite.getTrueInstance().getMyJAlbumQuotaUrl());
                        HttpConnection conn = new HttpConnection(quotaURL);
                        Properties data = new Properties();
                        data.setProperty("userName", JPublishWizard.this.currentAccount.getFtpUser());
                        HttpResponse resp = conn.Post(data);
                        if (resp.getStatusCode() != 200) {
                            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
                        }
                        String content = resp.getContentAsString();
                        Element result = Elements.getElementByName("result", content, false);
                        if (result != null) {
                            float usage = (float)Long.parseLong(result.getAttribute("usage")) / 1024.0f;
                            float quota = (float)Long.parseLong(result.getAttribute("quota")) / 1024.0f;
                            JProgressBar meter = new JProgressBar(0, (int)quota);
                            meter.setValue((int)usage);
                            meter.setStringPainted(true);
                            DecimalFormat twoDec = new DecimalFormat("0.##");
                            meter.setString(Msg.get("publish.quotaInfo", twoDec.format(usage), twoDec.format(quota)));
                            JOptionPane.showMessageDialog(JPublishWizard.this, new Object[]{meter, PublishStep.this.getPromoteMyJAlbumLabel()}, Msg.get("publish.getQuota"), 1);
                        }
                    }
                    catch (Exception ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.advancedModeButton = null;
            this.advancedModeAction = new AbstractAction(null, this.advancedIcon){
                {
                    this.putValue("ShortDescription", Msg.get("ui.advancedPanel"));
                }

                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.refreshFrom((RemoteFSNode)PublishStep.this.treeModel.getRoot());
                    TreePath tp = RemoteFSNode.treePath(JPublishWizard.this.getRemoteDirectory(), PublishStep.this.treeModel);
                    if (tp.getLastPathComponent() == PublishStep.this.treeModel.getRoot()) {
                        tp = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), PublishStep.this.treeModel);
                    }
                    PublishStep.this.tree.setSelectionPath(tp);
                    PublishStep.this.tree.scrollPathToVisible(tp);
                    PublishStep.this.updateView();
                }
            };
            this.copyURLAction = new AbstractAction(null, this.copyIcon){

                public void actionPerformed(ActionEvent e) {
                    StringSelection stringSelection = new StringSelection(PublishStep.this.previewLink.getURL());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            };
            this.smartUploadAction = new AbstractAction(Msg.get("ui.smartUpload"), this.uploadIcon){
                {
                    this.putValue("ShortDescription", Msg.get("ui.smartUploadToolTip"));
                }

                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(false);
                }
            };
            this.uploadAllAction = new AbstractAction(Msg.get("ui.uploadAll"), this.uploadIcon){
                {
                    this.putValue("ShortDescription", Msg.get("ui.uploadAllToolTip"));
                }

                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(true);
                }
            };
            this.uploadAction = new CompoundAction(Msg.get("ui.upload"), this.uploadIcon){
                {
                    this.setSubActions(new Action[]{PublishStep.this.smartUploadAction, PublishStep.this.uploadAllAction});
                }

                public void actionPerformed(ActionEvent e) {
                    PublishStep.this.doUploadAlbum(false);
                }
            };
            this.remoteToolBar = new JToolBar();
            this.tree = new NonCollapsableJTree((TreeModel)null);
            this.remoteTreeScrollPane = new JScrollPane(this.tree);
            this.previewLinkLabel = new JLabel(Msg.get("share.url"));
            this.previewLink = new JLinkLabel();
            this.copyURLButton = new JButton(this.copyURLAction);
            try {
                this.notifier = new Notifier(JPublishWizard.this.context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.advancedModeButton = new JToggleButton(this.advancedModeAction);
            this.copyURLAction.putValue("ShortDescription", Msg.get("share.urlToolTip"));
            this.treeMenu = new JPopupMenu();
            this.treeMenu.add(this.newDirectoryAction);
            this.treeMenu.add(this.renameAction);
            this.treeMenu.add(this.deleteAction);
            this.treeMenu.add(this.refreshDirectoryAction);
            this.treeMenu.add(this.markAsWebRootAction);
            this.treeMenu.add(this.passwordProtectAction);
            this.tree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    TreePath selPath = PublishStep.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (e.getButton() != 1) {
                        PublishStep.this.tree.getSelectionModel().setSelectionPath(selPath);
                    }
                    if (e.isPopupTrigger() && selPath != null) {
                        PublishStep.this.treeMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    TreePath path = PublishStep.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (e.isPopupTrigger() && path != null) {
                        PublishStep.this.treeMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.tree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127 || Platform.isMac() && e.getKeyCode() == 8 && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                        PublishStep.this.deleteAction.actionPerformed(null);
                    } else if (e.getKeyCode() == 116) {
                        PublishStep.this.refreshDirectoryAction.actionPerformed(null);
                    }
                }
            });
            this.remoteTreeScrollPane.setPreferredSize(new Dimension(150, 150));
            this.remoteToolBar.setFloatable(false);
            this.remoteToolBar.setOpaque(false);
            this.remoteToolBar.setBorderPainted(false);
            this.remoteToolBar.add(new JToolBarButton(this.newDirectoryAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.renameAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.deleteAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.refreshDirectoryAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.markAsWebRootAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.passwordProtectAction, false));
            this.remoteToolBar.add(new JToolBarButton(this.getQuotaAction, false));
            this.remoteToolBar.addSeparator();
            this.remoteToolBar.add(this.advancedModeButton);
            this.add(this.remoteToolBar);
            this.add("br hfill vfill", this.remoteTreeScrollPane);
            this.add("p", this.previewLinkLabel);
            this.add("tab", this.previewLink);
            this.add(this.copyURLButton);
        }

        private String uniqueName(RemoteFSNode node, String name) {
            node.getChildCount();
            Enumeration<TreeNode> en = node.children();
            HashSet<String> names = new HashSet<String>();
            while (en.hasMoreElements()) {
                RemoteFSNode child = (RemoteFSNode)en.nextElement();
                names.add(child.getRemoteName());
            }
            int index = 1;
            String newName = name;
            while (names.contains(newName)) {
                newName = name + index;
                ++index;
            }
            return newName;
        }

        private String getProjectName() {
            if (JPublishWizard.this.engine.getDirectory() != null) {
                return new File(JPublishWizard.this.engine.getDirectory()).getName();
            }
            return "";
        }

        private void refreshFrom(RemoteFSNode node) {
            node.invalidate();
            this.treeModel.nodeStructureChanged(node);
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
        }

        private String discoverWebRoot(TreeModel model) {
            TreePath tp = new TreePath(model.getRoot());
            TreeNode tn = (TreeNode)tp.getLastPathComponent();
            tn.getChildCount();
            Enumeration<? extends TreeNode> children = tn.children();
            HashSet<String> webRootNames = new HashSet<String>();
            webRootNames.add("public_html");
            webRootNames.add("htdocs");
            webRootNames.add("wwwroot");
            webRootNames.add("httpdocs");
            webRootNames.add("www");
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!webRootNames.contains(child.toString())) continue;
                return child.toString();
            }
            return null;
        }

        @Override
        public Action[] getActions() {
            if (Platform.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, JPublishWizard.this.backAction, this.uploadAction};
            }
            return new Action[]{JPublishWizard.this.backAction, this.uploadAction, JPublishWizard.this.cancelAction};
        }

        @Override
        public void onShow() {
            this.markAsWebRootAction.setEnabled(!JPublishWizard.this.currentAccount.isMyjalbum());
            this.passwordProtectAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum());
            this.getQuotaAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum());
            this.treeModel = new DefaultTreeModel(JPublishWizard.this.rootNode);
            this.tree.setModel(this.treeModel);
            this.tree.setEditable(true);
            this.tree.getSelectionModel().setSelectionMode(1);
            new RemoteFSTreeTransferHandler(this.tree, JPublishWizard.this, JPublishWizard.this.uploadBean, 3);
            this.treeModel.addTreeModelListener(new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent e) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    node.setUserObject(((String)node.getUserObject()).trim());
                    try {
                        if (!node.isRealDirectory()) {
                            JPublishWizard.this.uploadBean.getRemoteFS().createDirectory(node.remotePath());
                        } else if (!node.oldRemotePath().equals(node.remotePath())) {
                            JPublishWizard.this.uploadBean.getRemoteFS().rename(node.oldRemotePath(), node.remotePath());
                            if (PublishStep.this.notifier != null) {
                                PublishStep.this.notifier.albumMovedBg(JPublishWizard.this.currentAccount, PublishStep.this.getUrl(node.oldRemotePath()), PublishStep.this.getUrl(node.remotePath()));
                            }
                        }
                        node.setRemoteName(node.toString());
                        JPublishWizard.this.setRemoteDirectory(node.remotePath());
                        PublishStep.this.updateView();
                    }
                    catch (RemoteFSException ex) {
                        UploadBean.showErrorDialog(JPublishWizard.this, ex, Msg.get("publish.serverReportedInfo"), Msg.get("publish.renameDirectory"));
                        ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                        PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                        ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                        PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                    }
                }

                public void treeNodesInserted(TreeModelEvent e) {
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                }

                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    String remotePath = RemoteFSNode.remotePath(e.getPath(), PublishStep.this);
                    JPublishWizard.this.setRemoteDirectory(JPublishWizard.this.toRelative(remotePath));
                    PublishStep.this.updateView();
                }
            });
            this.customRenderer = new RemoteFSTreeCellRenderer();
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot.equals("VALUE_UNSET")) {
                webRoot = this.discoverWebRoot(this.treeModel);
                if (webRoot == null) {
                    webRoot = JPublishWizard.this.currentAccount.isShowServerRootDirectory() ? JPublishWizard.this.uploadBean.getBaseDirectory() : "";
                }
                JPublishWizard.this.setFtpWebRootDirectory(webRoot);
            }
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
            this.tree.setCellRenderer(this.customRenderer);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, this.customRenderer);
            this.tree.setCellEditor(editor);
            this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent e) {
                    RemoteFSNode lastNode = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (lastNode != null && !lastNode.isRealDirectory()) {
                        PublishStep.this.tree.setSelectionPath(new TreePath(lastNode.getParent()));
                        PublishStep.this.treeModel.removeNodeFromParent(lastNode);
                    }
                }

                public void editingStopped(ChangeEvent e) {
                }
            });
            TreePath tp = RemoteFSNode.treePath(JPublishWizard.this.getRemoteDirectory(), this.treeModel);
            if (tp.getLastPathComponent() == this.treeModel.getRoot()) {
                tp = RemoteFSNode.treePath(IO.combinePaths(JPublishWizard.this.getFtpWebRootDirectory(), this.getProjectName()), this.treeModel);
            }
            boolean notFound = false;
            if (tp.getLastPathComponent() == this.treeModel.getRoot()) {
                notFound = true;
                tp = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            }
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
            this.updateView();
            if (notFound && this.getProjectName().length() > 0) {
                this.newDirectoryAction.actionPerformed(null);
            }
        }

        @Override
        public void onHide() {
            this.tree.setModel(null);
            try {
                ToolTipManager.sharedInstance().unregisterComponent(this.tree);
                JPublishWizard.this.uploadBean.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateView() {
            String uri;
            boolean underWebDir = false;
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot == null) {
                webRoot = "";
            }
            if ((uri = IO.relativePath(JPublishWizard.this.getRemoteDirectory(), webRoot)).startsWith("..")) {
                this.previewLink.setText(Msg.get("publish.NoWebDirectorySelected"));
                this.previewLink.setURL(null);
                this.copyURLAction.setEnabled(false);
            } else {
                underWebDir = true;
                if (uri.equals(".")) {
                    uri = "";
                }
                if (!"index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                    uri = IO.combinePaths(uri, JPublishWizard.this.engine.getIndexPageName() + JPublishWizard.this.engine.getPageExtension());
                }
                String url = IO.combinePaths(JPublishWizard.this.currentAccount.getWebRootURL(), uri);
                this.previewLink.setText(url);
                if ("index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                    this.previewLink.setURL(url + '/');
                } else {
                    this.previewLink.setURL(url);
                }
                this.copyURLAction.setEnabled(true);
            }
            RemoteFSNode node = (RemoteFSNode)this.tree.getLastSelectedPathComponent();
            boolean isRootSelected = node == null || node.isRoot();
            boolean isFolderSelected = node != null && !node.isLeaf();
            this.renameAction.setEnabled(!isRootSelected);
            this.deleteAction.setEnabled(!isRootSelected);
            this.passwordProtectAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum() && node != null && !node.isLeaf());
            boolean enableUpload = isFolderSelected && underWebDir && (this.isAdvancedMode() || !JPublishWizard.this.currentAccount.isMyjalbum() || !isRootSelected);
            this.uploadAction.setEnabled(enableUpload);
        }

        public String getUrl(String path) {
            String uri;
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot == null) {
                webRoot = "";
            }
            if ((uri = IO.relativePath(path, webRoot)).startsWith("..")) {
                return null;
            }
            if (uri.equals(".")) {
                uri = "";
            }
            if (!"index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                uri = IO.combinePaths(uri, JPublishWizard.this.engine.getIndexPageName() + JPublishWizard.this.engine.getPageExtension());
            }
            String url = IO.combinePaths(JPublishWizard.this.currentAccount.getWebRootURL(), uri);
            if ("index".equals(JPublishWizard.this.engine.getIndexPageName())) {
                url = url + '/';
            }
            return url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUploadAlbum(final boolean fullUpdate) {
            Thread uploadThread = null;
            try {
                int answer;
                JPublishWizard.this.context.getFrame().ui2Engine();
                File dir = JPublishWizard.this.engine.getInterpretedOutputDirectory();
                if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(this, Msg.get("publish.invalidOutputDirectoryError"), Msg.get("publish.publishAlbumTitle"), 0);
                    return;
                }
                if (this.treeModel == null) {
                    return;
                }
                if (this.tree.getLastSelectedPathComponent() == RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel).getLastPathComponent() && (JAlbum.mainFrame.preferencesWindow.showWarnings.isSelected() || fullUpdate) && (answer = JOptionPane.showConfirmDialog(this, Msg.get("publish.publishToRootWarning"), Msg.get("publish.publishAlbumTitle"), 0, 2)) != 0) {
                    return;
                }
                final JLabel publishConfirmationLabel = new JLabel(Msg.get("publish.uploadConfirmation", this.previewLink.getURL()));
                final JLabel albumSizeLabel = new JLabel(Msg.get("publish.albumSize") + ": ---");
                final JLabel quotaLabel = new JLabel(Msg.get("publish.accountSpace") + ": ---");
                long remoteAlbumSize = 0L;
                try {
                    Set<RemoteFile> existingFiles = JPublishWizard.this.uploadBean.getExistingAlbumFiles(JPublishWizard.this.engine.getRemoteDirectory());
                    remoteAlbumSize = UploadBean.getTotalSize(existingFiles, JAlbumSite.getInstance().getMyJAlbumFileClusterSize());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Object[] message = JPublishWizard.this.currentAccount.isMyjalbum() ? new Object[]{publishConfirmationLabel, albumSizeLabel, quotaLabel, this.getPromoteMyJAlbumLabel()} : new Object[]{publishConfirmationLabel, albumSizeLabel};
                final ConfirmDialog cd = new ConfirmDialog(JPublishWizard.this, message, Msg.get("ui.uploadConfirmationTitle"));
                if (JPublishWizard.this.currentAccount.isMyjalbum()) {
                    cd.okButton.setEnabled(false);
                }
                DiskSpaceReporter reporter = new DiskSpaceReporter(JPublishWizard.this.engine.getInterpretedOutputDirectory(), JPublishWizard.this.currentAccount.isMyjalbum() ? JPublishWizard.this.currentAccount.getFtpUser() : null, remoteAlbumSize){
                    Long albumSize;
                    Long quota;
                    Long spaceUsed;

                    public void localAlbumSizeCalculated(long albumSize) {
                        this.albumSize = albumSize;
                        albumSizeLabel.setText(Msg.get("publish.albumSize") + ": " + this.formatAsMB(albumSize) + " MB");
                        this.updateOkButtonState();
                    }

                    public void quotaCalculated(long spaceUsed, long quota) {
                        this.spaceUsed = spaceUsed;
                        this.quota = quota;
                        this.updateOkButtonState();
                        quotaLabel.setText(Msg.get("publish.accountSpace") + ": " + Msg.get("publish.quotaInfo2", this.formatAsMB(quota - spaceUsed), this.formatAsMB(quota)));
                    }

                    void updateOkButtonState() {
                        if (this.albumSize != null && this.spaceUsed != null && this.quota != null) {
                            long spaceLeft = this.quota - this.spaceUsed - (this.albumSize - this.remoteAlbumSize);
                            if (spaceLeft > 102400L) {
                                cd.okButton.setEnabled(true);
                            } else {
                                publishConfirmationLabel.setText(Msg.get("publish.albumTooLarge"));
                                quotaLabel.setForeground(Color.red);
                            }
                        }
                    }
                };
                int res = cd.showConfirmDialog();
                reporter.interrupt();
                if (res != 0) {
                    if (cd.isChangeLocation()) {
                        JPublishWizard.this.backAction.actionPerformed(null);
                        JPublishWizard.this.setVisible(true);
                    }
                    return;
                }
                RemoteFSNode node = (RemoteFSNode)this.tree.getLastSelectedPathComponent();
                node.setUserObject(((String)node.getUserObject()).trim());
                if (!node.isRealDirectory()) {
                    JPublishWizard.this.uploadBean.getRemoteFS().createDirectory(node.remotePath());
                }
                final JUploadProgressDialog uploadProgress = new JUploadProgressDialog(JPublishWizard.this, Msg.get("ui.uploadingAlbumTitle"), false);
                uploadThread = new Thread("Upload thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            JPublishWizard.this.uploadBean.addUploadListener(uploadProgress);
                            JPublishWizard.this.uploadBean.setAbsoluteURL(IO.urlEncode(PublishStep.this.previewLink.getText()));
                            JPublishWizard.this.uploadBean.uploadAlbum(JPublishWizard.this.engine, fullUpdate);
                            PublishStep.this.refreshDirectoryAction.actionPerformed(null);
                            String afterPublishing = Config.getConfig().getAfterPublishing();
                            String albumIdString = null;
                            String cid = AccountManager.resolveCid(JPublishWizard.this.currentAccount);
                            if (PublishStep.this.notifier != null && cid != null) {
                                if (afterPublishing.equals("openPublishedAlbum")) {
                                    PublishStep.this.notifier.albumAddedBg(JPublishWizard.this.currentAccount, PublishStep.this.previewLink.getURL(), true);
                                } else {
                                    String doc;
                                    if (Config.getConfig().isUpdateProfilePage()) {
                                        uploadProgress.directory.setText(Msg.get("publish.updatingProfilePage") + "...");
                                        uploadProgress.file.setText(" ");
                                    }
                                    if ((doc = PublishStep.this.notifier.albumAdded(JPublishWizard.this.currentAccount, PublishStep.this.previewLink.getURL(), true)) != null) {
                                        albumIdString = Elements.contentOfElement("albumId", doc);
                                    }
                                }
                            }
                            uploadProgress.setVisible(false);
                            uploadProgress.dispose();
                            if (afterPublishing.equals("openPublishingSuccessfulPage")) {
                                String language = Config.getConfig().getLanguage();
                                if (language.equals("default")) {
                                    language = System.getProperty("user.language");
                                }
                                if (albumIdString != null) {
                                    String publishLandingUrl = JAlbumSite.getInstance().getPublishLandingUrl();
                                    publishLandingUrl = publishLandingUrl + "?albumId=" + albumIdString;
                                    publishLandingUrl = publishLandingUrl + "&language=" + language;
                                    if (cid != null) {
                                        publishLandingUrl = publishLandingUrl + "&cid=" + cid;
                                    }
                                    BrowserLauncher.openURL(publishLandingUrl);
                                    return;
                                }
                                String publishLandingUrl = JAlbumSite.getInstance().getPublishedExternalAlbumUrl();
                                if (publishLandingUrl != null) {
                                    String albumUrl = PublishStep.this.previewLink.getURL();
                                    publishLandingUrl = publishLandingUrl + "?albumUrl=" + URLEncoder.encode(albumUrl, "UTF-8");
                                    AlbumObject root = JPublishWizard.this.context.getFrame().albumExplorer.getRootFolder();
                                    String thumbnailPath = root.getThumbnailPath();
                                    if (thumbnailPath != null) {
                                        String thumbnailUrl = IO.combinePaths(albumUrl, thumbnailPath);
                                        publishLandingUrl = publishLandingUrl + "&thumbnailUrl=" + URLEncoder.encode(thumbnailUrl, "UTF-8");
                                    }
                                    publishLandingUrl = publishLandingUrl + "&albumTitle=" + URLEncoder.encode(root.getName(), "UTF-8");
                                    publishLandingUrl = publishLandingUrl + "&language=" + language;
                                    BrowserLauncher.openURL(publishLandingUrl);
                                    return;
                                }
                            }
                            if (!afterPublishing.equals("doNothing")) {
                                PublishStep.this.previewLink.doClick();
                            }
                        }
                        catch (OperationAbortedException ex) {
                        }
                        catch (Throwable t2) {
                            if ("2: No such file".equals(t2.getMessage())) {
                                JOptionPane.showMessageDialog(JPublishWizard.this, new Object[]{Msg.get("publish.quotaExceeded"), PublishStep.this.getPromoteMyJAlbumLabel()}, Msg.get("ui.uploadingAlbumTitle"), 0);
                                return;
                            }
                            Debug.showErrorDialog(JPublishWizard.this, t2);
                        }
                        finally {
                            JPublishWizard.this.uploadBean.removeUploadListener(uploadProgress);
                            if (!JPublishWizard.this.isVisible()) {
                                JPublishWizard.this.uploadBean.disconnect();
                            }
                        }
                    }
                };
                uploadThread.setDaemon(true);
                uploadThread.start();
                this.enableActions(false);
                uploadProgress.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        PublishStep.this.enableActions(true);
                    }

                    public void windowClosed(WindowEvent e) {
                        PublishStep.this.enableActions(true);
                    }
                });
                uploadProgress.setVisible(true);
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
            finally {
                if (!(uploadThread != null && uploadThread.isAlive() || JPublishWizard.this.isVisible())) {
                    JPublishWizard.this.uploadBean.disconnect();
                }
            }
        }

        private JLinkLabel getPromoteMyJAlbumLabel() {
            try {
                if (JPublishWizard.this.currentAccount.isMyjalbum()) {
                    return new JLinkLabel(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?cid=" + AccountManager.getCid(JPublishWizard.this.currentAccount), Msg.get("publish.upgradeAccount"));
                }
                return new JLinkLabel(JAlbumSite.getTrueInstance().getMyJAlbumInfoUrl(), Msg.get("publish.getAMyJAlbumAccount"));
            }
            catch (Exception ex) {
                return null;
            }
        }

        void doUploadFiles(final List<File> filesDirs) {
            final JUploadProgressDialog uploadProgress = new JUploadProgressDialog(JPublishWizard.this, Msg.get("ui.uploadingFilesTitle"), false);
            Thread uploadThread = new Thread("Upload thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JPublishWizard.this.uploadBean.addUploadListener(uploadProgress);
                        JPublishWizard.this.uploadBean.uploadFiles(filesDirs.toArray(new File[0]), JPublishWizard.this.engine.getRemoteDirectory());
                        uploadProgress.setVisible(false);
                        uploadProgress.dispose();
                        PublishStep.this.refreshDirectoryAction.actionPerformed(null);
                    }
                    catch (OperationAbortedException ex) {
                    }
                    catch (Throwable t2) {
                        if ("2: No such file".equals(t2.getMessage())) {
                            JOptionPane.showMessageDialog(JPublishWizard.this, new Object[]{Msg.get("publish.quotaExceeded"), PublishStep.this.getPromoteMyJAlbumLabel()}, Msg.get("ui.uploadingAlbumTitle"), 0);
                            return;
                        }
                        Debug.showErrorDialog(JPublishWizard.this, t2);
                    }
                    finally {
                        JPublishWizard.this.uploadBean.removeUploadListener(uploadProgress);
                    }
                }
            };
            uploadThread.start();
            this.enableActions(false);
            uploadProgress.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }

                public void windowClosed(WindowEvent e) {
                    PublishStep.this.enableActions(true);
                }
            });
            uploadProgress.setVisible(true);
        }

        private void enableActions(boolean enable) {
            if (!enable) {
                JPublishWizard.this.setDefaultCloseOperation(0);
            } else {
                JPublishWizard.this.setDefaultCloseOperation(1);
            }
            JPublishWizard.this.backAction.setEnabled(enable);
            JPublishWizard.this.finishAction.setEnabled(enable);
            JPublishWizard.this.cancelAction.setEnabled(enable);
            this.newDirectoryAction.setEnabled(enable);
            this.renameAction.setEnabled(enable);
            this.deleteAction.setEnabled(enable);
            this.refreshDirectoryAction.setEnabled(enable);
            this.markAsWebRootAction.setEnabled(enable && !JPublishWizard.this.currentAccount.isMyjalbum());
            this.advancedModeAction.setEnabled(enable);
            this.tree.setEnabled(enable);
            this.uploadAction.setEnabled(enable);
        }

        @Override
        public boolean isAdvancedMode() {
            return this.advancedModeButton.isSelected();
        }

        @Override
        public Window getOwningWindow() {
            return JPublishWizard.this;
        }

        @Override
        public RemoteFSDelegate getRemoteFS() {
            return JPublishWizard.this.uploadBean.getRemoteFS();
        }

        @Override
        public String getBasePath() {
            return JPublishWizard.this.currentAccount.isShowServerRootDirectory() ? "" : JPublishWizard.this.uploadBean.getBaseDirectory();
        }

        @Override
        public Set<String> getProtectedPaths() {
            if (JPublishWizard.this.protectedPaths == null) {
                try {
                    JPublishWizard.this.protectedPaths = AccountManager.getProtectedPaths(JPublishWizard.this.currentAccount);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                    JPublishWizard.this.protectedPaths = new TreeSet<String>();
                }
            }
            return JPublishWizard.this.protectedPaths;
        }
    }

    class AccountsStep
    extends JWizardStep {
        ImageIcon addAccountIcon;
        ImageIcon deleteAccountIcon;
        ImageIcon advancedIcon;
        ImageIcon plugIcon;
        ImageIcon serverIcon;
        ImageIcon serverConnectionIcon;
        JButton addAccountButton;
        JButton removeAccountButton;
        JList accountList;
        JScrollPane accountsScrollPane;
        ControlPanel currentAccountPanel;
        JLabel ftpServerLabel;
        JTextField ftpServer;
        JLabel ftpUserNameLabel;
        JTextField ftpUser;
        JLabel ftpPasswordLabel;
        JPasswordField ftpPassword;
        JButton advancedAccountSettingsButton;
        JAdvancedAccountSettingsDialog advancedSettingsDialog;
        Action connectAction;

        AccountsStep() {
            super(Msg.get("acc.profilesLabel"));
            this.addAccountIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/user1_add.png"));
            this.deleteAccountIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/user1_delete.png"));
            this.advancedIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/wrench16.png"));
            this.plugIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/plug.png"));
            this.serverIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/server_large.png"));
            this.serverConnectionIcon = new ImageIcon(JPublishWizard.class.getResource("images/publish/server_connection_large.png"));
            this.addAccountButton = new JIconButton();
            this.removeAccountButton = new JIconButton();
            this.accountList = new JList(JPublishWizard.this.accountManager.getAccounts());
            this.accountsScrollPane = new JScrollPane(this.accountList);
            this.currentAccountPanel = new ControlPanel(Msg.get("publish.currentAccountBorder"));
            this.ftpServerLabel = new JLabel(Msg.get("ui.ftpServer"));
            this.ftpServer = new JSmartTextField(16);
            this.ftpUserNameLabel = new JLabel(Msg.get("ui.userName"));
            this.ftpUser = new JSmartTextField(16);
            this.ftpPasswordLabel = new JLabel(Msg.get("ui.password"));
            this.ftpPassword = new JPasswordField(16);
            this.advancedAccountSettingsButton = new JIconButton(Msg.get("ui.advancedPanel"), this.advancedIcon);
            this.advancedSettingsDialog = new JAdvancedAccountSettingsDialog(JPublishWizard.this, false);
            this.connectAction = new AbstractAction(Msg.get("publish.connect"), this.plugIcon){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void actionPerformed(ActionEvent e) {
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this);
                    BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this.advancedSettingsDialog);
                    if (AccountsStep.this.ftpPassword.getPassword().length == 0) {
                        String password = JPublishWizard.showPasswordInputDialog(JPublishWizard.this, Msg.get("publish.enterPasswordInfo"), Msg.get("publish.connect"), null);
                        if (password == null) return;
                        JPublishWizard.this.uploadBean.setFtpPassword(password);
                    }
                    SlowOperation connectOp = new SlowOperation(){

                        public void operation() throws Throwable {
                            JPublishWizard.this.uploadBean.connect(JPublishWizard.this.currentAccount);
                            RemoteFSNode.setLateDiscovery(!AccountsStep.this.isShowing() || !JPublishWizard.this.currentAccount.isMyjalbum());
                            if (JPublishWizard.this.currentAccount.isShowServerRootDirectory()) {
                                JPublishWizard.this.uploadBean.getRemoteFS().setDirectory("/");
                            }
                            JPublishWizard.this.engine.setAccountProfileName(JPublishWizard.this.currentAccount.getName());
                            JPublishWizard.this.rootNode = new RemoteFSNode(AccountsStep.this.ftpServer.getText(), false, false, JPublishWizard.this.publishStep);
                            JPublishWizard.this.protectedPaths = null;
                            this.getMessageLabel().setText(Msg.get("edit.preparingPreviewInfo"));
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    JPublishWizard.this.nextAction.actionPerformed(null);
                                }
                            });
                        }

                        public void abort() {
                            try {
                                JPublishWizard.this.uploadBean.getRemoteFS().abortConnect();
                                if (JPublishWizard.this.stepIndex > 0) {
                                    JPublishWizard.this.backAction.actionPerformed(null);
                                }
                            }
                            catch (RemoteFSException ex) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    try {
                        boolean done = connectOp.launch(JPublishWizard.this, new JLabel(Msg.get("ui.connectingToServer") + " " + AccountsStep.this.ftpServer.getText() + "...", AccountsStep.this.serverIcon, 10), (Icon)AccountsStep.this.serverConnectionIcon, Msg.get("publish.connect"));
                        if (!done) return;
                    }
                    catch (RemoteFSException ex) {
                        if (JPublishWizard.this.currentAccount.isMyjalbum()) {
                            try {
                                AccountManager.AccountStatus status = AccountManager.getJalbumAccountStatus(JPublishWizard.this.currentAccount);
                                Date accountExpires = status.getAccountExpires();
                                if (accountExpires != null && new Date().after(accountExpires)) {
                                    JOptionPane.showMessageDialog(JPublishWizard.this, new Object[]{Msg.get("publish.accountExpiredMessage", status.get("accountType"), status.getFormattedAccountExpires()), new JLinkLabel(JAlbumSite.getInstance().getMyJAlbumUpgradeUrl() + "/?cid=" + AccountManager.getCid(JPublishWizard.this.currentAccount), Msg.get("publish.extendAccount"))}, Msg.get("publish.accountExpiredTitle"), 0);
                                    return;
                                }
                            }
                            catch (IOException ex1) {
                            }
                            catch (AuthenticationException ex1) {
                                // empty catch block
                            }
                        }
                        UploadBean.showErrorDialog(JPublishWizard.this, ex, Msg.get("publish.connectionError") + ". " + Msg.get("publish.serverReportedInfo"), Msg.get("publish.connect"));
                        return;
                    }
                    catch (Throwable ex) {
                        JPublishWizard.this.uploadBean.disconnect();
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.addAccountButton.setText(Msg.get("add"));
            this.addAccountButton.setIcon(this.addAccountIcon);
            this.addAccountButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsStep.this.addAccountButton_actionPerformed(e);
                }
            });
            this.removeAccountButton.setText(Msg.get("remove"));
            this.removeAccountButton.setIcon(this.deleteAccountIcon);
            this.removeAccountButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsStep.this.removeAccountButton_actionPerformed(e);
                }
            });
            this.advancedAccountSettingsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsStep.this.advancedSettingsDialog.setVisible(true);
                }
            });
            this.ftpServer.setToolTipText(Msg.get("ui.ftpServerToolTip"));
            this.ftpUser.setToolTipText(Msg.get("ui.userNameToolTip"));
            this.ftpPassword.setToolTipText(Msg.get("ui.passwordToolTip"));
            this.ftpServer.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (c == ':' || c == '/' || c == ' ' || c == ',') {
                        e.consume();
                    }
                }

                public void keyReleased(KeyEvent e) {
                    AccountsStep.this.modifyAccountName();
                }
            });
            this.ftpUser.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AccountsStep.this.modifyAccountName();
                }
            });
            this.add(this.addAccountButton);
            this.add(this.removeAccountButton);
            this.add("br hfill vfill", this.accountsScrollPane);
            this.currentAccountPanel.add(this.ftpServerLabel);
            this.currentAccountPanel.add("tab", this.ftpServer);
            this.currentAccountPanel.add("br", this.ftpUserNameLabel);
            this.currentAccountPanel.add("tab", this.ftpUser);
            this.currentAccountPanel.add("br", this.ftpPasswordLabel);
            this.currentAccountPanel.add("tab", this.ftpPassword);
            this.currentAccountPanel.add("tab", this.advancedAccountSettingsButton);
            this.add("br hfill", this.currentAccountPanel);
            this.accountList.setSelectionMode(0);
            this.accountList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    AccountProfile newProfile = (AccountProfile)AccountsStep.this.accountList.getSelectedValue();
                    if (JPublishWizard.this.stepIndex > 0) {
                        return;
                    }
                    if (JPublishWizard.this.currentAccount != null) {
                        BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this);
                        BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, AccountsStep.this.advancedSettingsDialog);
                        JPublishWizard.this.engine.setAccountProfileName(JPublishWizard.this.currentAccount.getName());
                    }
                    if (newProfile != null) {
                        JPublishWizard.this.currentAccount = newProfile;
                    }
                    AccountsStep.this.updateView();
                }
            });
            this.accountList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AccountsStep.this.connectAction.actionPerformed(null);
                    }
                }
            });
            try {
                this.accountList.setSelectedValue(new AccountProfile(JPublishWizard.this.engine.getAccountProfileName()), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.accountList.getSelectedIndex() == -1 && this.accountList.getModel().getSize() > 0) {
                this.accountList.setSelectedIndex(0);
            }
            this.updateView();
        }

        private void modifyAccountName() {
            String finalName = this.ftpServer.getText();
            String userName = this.ftpUser.getText();
            if (userName.length() > 0) {
                finalName = finalName + " - " + userName;
            }
            if (finalName.length() > 0) {
                JPublishWizard.this.currentAccount.setName(finalName);
            } else {
                JPublishWizard.this.currentAccount.setName(Msg.get("publish.NewAccount"));
            }
            this.accountList.updateUI();
        }

        public Action[] getActions() {
            if (Platform.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, this.connectAction};
            }
            return new Action[]{this.connectAction, JPublishWizard.this.cancelAction};
        }

        public Action getDefaultAction() {
            return this.connectAction;
        }

        private void updateView() {
            this.removeAccountButton.setEnabled(this.accountList.getSelectedIndex() >= 0);
            if (JPublishWizard.this.accountManager.getAccounts().getSize() > 0) {
                AccountProfile a = (AccountProfile)this.accountList.getSelectedValue();
                if (a == null) {
                    this.accountList.setSelectedIndex(JPublishWizard.this.accountManager.getAccounts().getSize() - 1);
                    a = (AccountProfile)this.accountList.getSelectedValue();
                }
                BeanBinder.getProperties((Object)a, this);
                BeanBinder.getProperties((Object)a, this.advancedSettingsDialog);
                this.accountList.setEnabled(true);
                this.currentAccountPanel.setEnabled(true);
                this.connectAction.setEnabled(true);
                this.currentAccountPanel.setEnabled(!a.isProtected());
                this.advancedAccountSettingsButton.setEnabled(!a.isProtected());
                this.ftpPasswordLabel.setEnabled(true);
                this.ftpPassword.setEnabled(true);
            } else {
                this.accountList.setEnabled(false);
                this.currentAccountPanel.setEnabled(false);
                this.connectAction.setEnabled(false);
            }
        }

        void addAccountButton_actionPerformed(ActionEvent e) {
            try {
                String activationUrl;
                JAlbumSite theSite = JAlbumSite.getTrueInstance();
                String string = activationUrl = (e.getModifiers() & 8) != 0 ? theSite.getMyJAlbumAltActivationUrl() : theSite.getMyJAlbumActivationUrl();
                if (activationUrl != null && activationUrl.length() > 0) {
                    JAddAccountDialog dialog = new JAddAccountDialog(JPublishWizard.this, true, (e.getModifiers() & 8) != 0);
                    dialog.setVisible(true);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Msg.get("ui.softwareFirewallInfo"), Msg.get("publish.connectionError"), 0);
                return;
            }
            this.addAccount(new AccountProfile(Msg.get("publish.NewAccount")));
        }

        void removeAccountButton_actionPerformed(ActionEvent e) {
            AccountProfile account = (AccountProfile)this.accountList.getSelectedValue();
            if (account == null) {
                return;
            }
            int answer = JOptionPane.showConfirmDialog(this, Msg.get("acc.removeAccountInfo", account.getName()), Msg.get("acc.removeAccountTitle"), 0);
            if (answer == 0) {
                this.removeAccount(account);
            }
        }

        public void addAccount(AccountProfile newAccount) {
            JPublishWizard.this.accountManager.addAccount(newAccount);
            this.accountList.setSelectedIndex(JPublishWizard.this.accountManager.getAccounts().getSize() - 1);
            this.updateView();
            this.ftpServer.requestFocusInWindow();
        }

        void saveAccounts() {
            try {
                JPublishWizard.this.accountManager.saveAccounts();
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }

        public void removeAccount(AccountProfile oldAccount) {
            int oldIndex = this.accountList.getSelectedIndex();
            JPublishWizard.this.accountManager.removeAccount(oldAccount);
            if (oldIndex < JPublishWizard.this.accountManager.getAccounts().size()) {
                this.accountList.setSelectedIndex(oldIndex);
            }
        }

        public void onShow() {
            if (JPublishWizard.this.accountManager.getAccounts().size() == 0) {
                this.addAccountButton.doClick();
            }
        }

        public void onHide() {
            if (JPublishWizard.this.currentAccount != null) {
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this);
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this.advancedSettingsDialog);
            }
            this.saveAccounts();
        }
    }
}

