/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComboBox;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.util.IO;
import se.datadosen.util.Item;

public class JAlbumUtilities {
    private JAlbumUtilities() {
    }

    public static void fillCombo(JComboBox combo, File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            return;
        }
        JAlbumUtilities.fillCombo(combo, new ChainedDirectory(dir), filter);
    }

    public static void fillCombo(JComboBox combo, ChainedDirectory dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(((File)o1).getName(), ((File)o2).getName());
            }
        });
        for (File f : files) {
            if (f.getName().toLowerCase().endsWith(".css")) {
                combo.addItem(new Item(f.getName(), IO.baseName(f)));
                continue;
            }
            combo.addItem(f.getName());
        }
    }

    public static Map getUserVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "user.");
    }

    public static Map getSkinVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "skin.");
    }

    static Map getPrefixedVariables(Map props, String prefix) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        for (Map.Entry item : props.entrySet()) {
            String name = item.getKey().toString();
            if (!name.startsWith(prefix)) continue;
            theMap.put(name.substring(prefix.length()), item.getValue().toString());
        }
        return theMap;
    }
}

