/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import se.datadosen.dnd.AbstractTreeTransferHandler;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerTreeTransferHandler
extends AbstractTreeTransferHandler {
    private JAlbumExplorer context;
    private JComponent albumRootComponent;

    public ExplorerTreeTransferHandler(JTree tree, JAlbumExplorer context) {
        this(tree, null, context);
    }

    public ExplorerTreeTransferHandler(JTree tree, JComponent albumRootComponent, JAlbumExplorer context) {
        super(tree, 3, true);
        this.context = context;
        if (albumRootComponent != null) {
            this.albumRootComponent = albumRootComponent;
            new DropTarget(albumRootComponent, this);
        }
    }

    @Override
    protected DefaultMutableTreeNode resolveTargetNode(Point pt, DropTargetContext dtc) {
        if (dtc != null && dtc.getComponent() == this.albumRootComponent) {
            return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        }
        return super.resolveTargetNode(pt, dtc);
    }

    @Override
    public boolean canDropNode(DropTargetContext dtc, DefaultMutableTreeNode draggedNode, int action, Point location) {
        DefaultMutableTreeNode parentNode = this.resolveTargetNode(location, dtc);
        if (parentNode == null) {
            return false;
        }
        if (draggedNode != null && (draggedNode.isRoot() || parentNode == draggedNode.getParent() || draggedNode.isNodeDescendant(parentNode))) {
            return false;
        }
        this.tree.setSelectionPath(new TreePath(parentNode.getPath()));
        return true;
    }

    @Override
    public int filesDragged(DropTargetContext dtc, int action, Point location) {
        DefaultMutableTreeNode targetNode = this.resolveTargetNode(location, dtc);
        if (targetNode == null) {
            this.tree.setSelectionPath(null);
            return 0;
        }
        this.tree.setSelectionPath(new TreePath(targetNode.getPath()));
        return 1;
    }

    @Override
    public boolean executeDrop(DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int action) {
        AlbumObject moved = this.getAlbumObject(draggedNode);
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (moved != null && target != null) {
            return this.move(moved, target);
        }
        return false;
    }

    @Override
    public boolean executeDrop(List<File> droppedFiles, DefaultMutableTreeNode newParentNode, int action) {
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (target != null) {
            return this.add(droppedFiles, target);
        }
        return false;
    }

    @Override
    public boolean executeAlbumObjectDrop(DefaultMutableTreeNode newParentNode, int action) {
        List<JAlbumObject> draggedObjects = this.context.explorer.getDraggedObjects();
        AlbumObject[] moved = new AlbumObject[draggedObjects.size()];
        for (int i = 0; i < draggedObjects.size(); ++i) {
            moved[i] = draggedObjects.get((int)i).ao;
        }
        AlbumObject target = this.getAlbumObject(newParentNode);
        if (moved != null && target != null) {
            return this.move(moved, target);
        }
        return false;
    }

    private AlbumObject getAlbumObject(DefaultMutableTreeNode node) {
        AlbumObject ao = null;
        if (node instanceof JAlbumExplorer.FolderTreeNode) {
            JAlbumExplorer.FolderTreeNode ftn = (JAlbumExplorer.FolderTreeNode)node;
            ao = ftn.getAlbumObject();
        }
        return ao;
    }

    private boolean move(AlbumObject moved, AlbumObject target) {
        return this.move(new AlbumObject[]{moved}, target);
    }

    private boolean move(AlbumObject[] moved, AlbumObject target) {
        try {
            for (AlbumObject ao : moved) {
                ao.moveTo(target);
            }
            this.context.refreshAction.actionPerformed(null);
            return true;
        }
        catch (IOException ex) {
            Debug.showErrorDialog(null, ex);
            return false;
        }
    }

    private boolean add(List<File> files, AlbumObject target) {
        try {
            target.add(files);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(null, ex);
        }
        this.context.refreshAction.actionPerformed(null);
        return true;
    }
}

