/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.Serializable;

public class Entry
implements Serializable {
    private int type;
    private String str;
    private Object[] value;

    public Entry(int type) {
        this.type = type;
    }

    public Entry(String value) {
        this(2, value);
    }

    public Entry(int type, String value) {
        this.type = type;
        this.str = value;
    }

    public Entry(int type, Object[] value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.value.length; ++i) {
            buff.append(this.type != 7 ? this.value[i] : Integer.toHexString((Integer)this.value[i]));
        }
        return buff.toString();
    }

    public Object[] getValues() {
        return this.value;
    }

    public Object getValue(int index) {
        if (this.value != null) {
            return this.value[index];
        }
        if (this.str != null) {
            return this.str;
        }
        return null;
    }

    public void setValue(int index, Object newValue) {
        if (newValue instanceof String) {
            this.str = (String)newValue;
        } else if (this.value != null && index <= this.value.length) {
            this.value[index] = newValue;
        } else {
            Object[] tempHolder = new Object[index + 1];
            if (this.value != null) {
                System.arraycopy(this.value, 0, tempHolder, 0, this.value.length);
            }
            tempHolder[index] = newValue;
            this.value = tempHolder;
        }
    }
}

