/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class KeyPair {
    public static final int ERROR = 0;
    public static final int DSA = 1;
    public static final int RSA = 2;
    public static final int UNKNOWN = 3;
    static final int VENDOR_OPENSSH = 0;
    static final int VENDOR_FSECURE = 1;
    int vendor = 0;
    private static final byte[] cr = "\n".getBytes();
    JSch jsch = null;
    private Cipher cipher;
    private HASH hash;
    private Random random;
    private byte[] passphrase;
    static byte[][] header = new byte[][]{"Proc-Type: 4,ENCRYPTED".getBytes(), "DEK-Info: DES-EDE3-CBC,".getBytes()};
    private static byte[] space = " ".getBytes();
    private boolean encrypted = false;
    private byte[] data = null;
    private byte[] iv = null;
    private byte[] publickeyblob = null;

    public static KeyPair genKeyPair(JSch jsch, int type) throws JSchException {
        return KeyPair.genKeyPair(jsch, type, 1024);
    }

    public static KeyPair genKeyPair(JSch jsch, int type, int key_size) throws JSchException {
        KeyPair kpair = null;
        if (type == 1) {
            kpair = new KeyPairDSA(jsch);
        } else if (type == 2) {
            kpair = new KeyPairRSA(jsch);
        }
        if (kpair != null) {
            ((KeyPair)kpair).generate(key_size);
        }
        return kpair;
    }

    abstract void generate(int var1) throws JSchException;

    abstract byte[] getBegin();

    abstract byte[] getEnd();

    abstract int getKeySize();

    public KeyPair(JSch jsch) {
        this.jsch = jsch;
    }

    abstract byte[] getPrivateKey();

    public void writePrivateKey(OutputStream out) {
        byte[][] _iv;
        byte[] plain = this.getPrivateKey();
        byte[] encoded = this.encrypt(plain, _iv = new byte[1][]);
        if (encoded != plain) {
            Util.bzero(plain);
        }
        byte[] iv = _iv[0];
        byte[] prv = Util.toBase64(encoded, 0, encoded.length);
        try {
            int i;
            out.write(this.getBegin());
            out.write(cr);
            if (this.passphrase != null) {
                out.write(header[0]);
                out.write(cr);
                out.write(header[1]);
                for (i = 0; i < iv.length; ++i) {
                    out.write(KeyPair.b2a((byte)(iv[i] >>> 4 & 0xF)));
                    out.write(KeyPair.b2a((byte)(iv[i] & 0xF)));
                }
                out.write(cr);
                out.write(cr);
            }
            for (i = 0; i < prv.length; i += 64) {
                if (i + 64 < prv.length) {
                    out.write(prv, i, 64);
                    out.write(cr);
                    continue;
                }
                out.write(prv, i, prv.length - i);
                out.write(cr);
                break;
            }
            out.write(this.getEnd());
            out.write(cr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    abstract byte[] getKeyTypeName();

    public abstract int getKeyType();

    public byte[] getPublicKeyBlob() {
        return this.publickeyblob;
    }

    public void writePublicKey(OutputStream out, String comment) {
        byte[] pubblob = this.getPublicKeyBlob();
        byte[] pub = Util.toBase64(pubblob, 0, pubblob.length);
        try {
            out.write(this.getKeyTypeName());
            out.write(space);
            out.write(pub, 0, pub.length);
            out.write(space);
            out.write(comment.getBytes());
            out.write(cr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writePublicKey(String name, String comment) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePublicKey(fos, comment);
        fos.close();
    }

    public void writeSECSHPublicKey(OutputStream out, String comment) {
        byte[] pubblob = this.getPublicKeyBlob();
        byte[] pub = Util.toBase64(pubblob, 0, pubblob.length);
        try {
            int len;
            out.write("---- BEGIN SSH2 PUBLIC KEY ----".getBytes());
            out.write(cr);
            out.write(("Comment: \"" + comment + "\"").getBytes());
            out.write(cr);
            for (int index = 0; index < pub.length; index += len) {
                len = 70;
                if (pub.length - index < len) {
                    len = pub.length - index;
                }
                out.write(pub, index, len);
                out.write(cr);
            }
            out.write("---- END SSH2 PUBLIC KEY ----".getBytes());
            out.write(cr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writeSECSHPublicKey(String name, String comment) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writeSECSHPublicKey(fos, comment);
        fos.close();
    }

    public void writePrivateKey(String name) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePrivateKey(fos);
        fos.close();
    }

    public String getFingerPrint() {
        byte[] kblob;
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        if ((kblob = this.getPublicKeyBlob()) == null) {
            return null;
        }
        return this.getKeySize() + " " + Util.getFingerPrint(this.hash, kblob);
    }

    private byte[] encrypt(byte[] plain, byte[][] _iv) {
        if (this.passphrase == null) {
            return plain;
        }
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        _iv[0] = new byte[this.cipher.getIVSize()];
        byte[] iv = _iv[0];
        if (this.random == null) {
            this.random = this.genRandom();
        }
        this.random.fill(iv, 0, iv.length);
        byte[] key = this.genKey(this.passphrase, iv);
        byte[] encoded = plain;
        int bsize = this.cipher.getIVSize();
        byte[] foo = new byte[(encoded.length / bsize + 1) * bsize];
        System.arraycopy(encoded, 0, foo, 0, encoded.length);
        int padding = bsize - encoded.length % bsize;
        for (int i = foo.length - 1; foo.length - padding <= i; --i) {
            foo[i] = (byte)padding;
        }
        encoded = foo;
        try {
            this.cipher.init(0, key, iv);
            this.cipher.update(encoded, 0, encoded.length, encoded, 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        Util.bzero(key);
        return encoded;
    }

    abstract boolean parse(byte[] var1);

    private byte[] decrypt(byte[] data, byte[] passphrase, byte[] iv) {
        try {
            byte[] key = this.genKey(passphrase, iv);
            this.cipher.init(1, key, iv);
            Util.bzero(key);
            byte[] plain = new byte[data.length];
            this.cipher.update(data, 0, data.length, plain, 0);
            return plain;
        }
        catch (Exception e) {
            return null;
        }
    }

    int writeSEQUENCE(byte[] buf, int index, int len) {
        buf[index++] = 48;
        index = this.writeLength(buf, index, len);
        return index;
    }

    int writeINTEGER(byte[] buf, int index, byte[] data) {
        buf[index++] = 2;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    int countLength(int len) {
        int i = 1;
        if (len <= 127) {
            return i;
        }
        while (len > 0) {
            len >>>= 8;
            ++i;
        }
        return i;
    }

    int writeLength(byte[] data, int index, int len) {
        int i = this.countLength(len) - 1;
        if (i == 0) {
            data[index++] = (byte)len;
            return index;
        }
        data[index++] = (byte)(0x80 | i);
        int j = index + i;
        while (i > 0) {
            data[index + i - 1] = (byte)(len & 0xFF);
            len >>>= 8;
            --i;
        }
        return j;
    }

    private Random genRandom() {
        if (this.random == null) {
            try {
                Class<?> c = Class.forName(JSch.getConfig("random"));
                this.random = (Random)c.newInstance();
            }
            catch (Exception e) {
                System.err.println("connect: random " + e);
            }
        }
        return this.random;
    }

    private HASH genHash() {
        try {
            Class<?> c = Class.forName(JSch.getConfig("md5"));
            this.hash = (HASH)c.newInstance();
            this.hash.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hash;
    }

    private Cipher genCipher() {
        try {
            Class<?> c = Class.forName(JSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cipher;
    }

    synchronized byte[] genKey(byte[] passphrase, byte[] iv) {
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        byte[] key = new byte[this.cipher.getBlockSize()];
        int hsize = this.hash.getBlockSize();
        byte[] hn = new byte[key.length / hsize * hsize + (key.length % hsize == 0 ? 0 : hsize)];
        try {
            byte[] tmp = null;
            if (this.vendor == 0) {
                int index = 0;
                while (index + hsize <= hn.length) {
                    if (tmp != null) {
                        this.hash.update(tmp, 0, tmp.length);
                    }
                    this.hash.update(passphrase, 0, passphrase.length);
                    this.hash.update(iv, 0, iv.length);
                    tmp = this.hash.digest();
                    System.arraycopy(tmp, 0, hn, index, tmp.length);
                    index += tmp.length;
                }
                System.arraycopy(hn, 0, key, 0, key.length);
            } else if (this.vendor == 1) {
                int index = 0;
                while (index + hsize <= hn.length) {
                    if (tmp != null) {
                        this.hash.update(tmp, 0, tmp.length);
                    }
                    this.hash.update(passphrase, 0, passphrase.length);
                    tmp = this.hash.digest();
                    System.arraycopy(tmp, 0, hn, index, tmp.length);
                    index += tmp.length;
                }
                System.arraycopy(hn, 0, key, 0, key.length);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return key;
    }

    public void setPassphrase(String passphrase) {
        if (passphrase == null || passphrase.length() == 0) {
            this.setPassphrase((byte[])null);
        } else {
            this.setPassphrase(Util.str2byte(passphrase));
        }
    }

    public void setPassphrase(byte[] passphrase) {
        if (passphrase != null && passphrase.length == 0) {
            passphrase = null;
        }
        this.passphrase = passphrase;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean decrypt(String _passphrase) {
        if (_passphrase == null || _passphrase.length() == 0) {
            return !this.encrypted;
        }
        return this.decrypt(Util.str2byte(_passphrase));
    }

    public boolean decrypt(byte[] _passphrase) {
        if (!this.encrypted) {
            return true;
        }
        if (_passphrase == null) {
            return !this.encrypted;
        }
        byte[] bar = new byte[_passphrase.length];
        System.arraycopy(_passphrase, 0, bar, 0, bar.length);
        _passphrase = bar;
        byte[] foo = this.decrypt(this.data, _passphrase, this.iv);
        Util.bzero(_passphrase);
        if (this.parse(foo)) {
            this.encrypted = false;
        }
        return !this.encrypted;
    }

    public static KeyPair load(JSch jsch, String prvkey) throws JSchException {
        String pubkey = prvkey + ".pub";
        if (!new File(pubkey).exists()) {
            pubkey = null;
        }
        return KeyPair.load(jsch, prvkey, pubkey);
    }

    public static KeyPair load(JSch jsch, String prvkey, String pubkey) throws JSchException {
        int vendor;
        int type;
        byte[] publickeyblob;
        byte[] data;
        boolean encrypted;
        byte[] iv;
        block58: {
            iv = new byte[8];
            encrypted = true;
            data = null;
            publickeyblob = null;
            type = 0;
            vendor = 0;
            try {
                int i;
                File file = new File(prvkey);
                FileInputStream fis = new FileInputStream(prvkey);
                byte[] buf = new byte[(int)file.length()];
                int len = 0;
                while ((i = fis.read(buf, len, buf.length - len)) > 0) {
                    len += i;
                }
                fis.close();
                i = 0;
                while (i < len) {
                    if (buf[i] == 66 && buf[i + 1] == 69 && buf[i + 2] == 71 && buf[i + 3] == 73) {
                        if (buf[i += 6] == 68 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                            type = 1;
                        } else if (buf[i] == 82 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                            type = 2;
                        } else if (buf[i] == 83 && buf[i + 1] == 83 && buf[i + 2] == 72) {
                            type = 3;
                            vendor = 1;
                        } else {
                            throw new JSchException("invalid privatekey: " + prvkey);
                        }
                        i += 3;
                        continue;
                    }
                    if (buf[i] == 67 && buf[i + 1] == 66 && buf[i + 2] == 67 && buf[i + 3] == 44) {
                        i += 4;
                        for (int ii = 0; ii < iv.length; ++ii) {
                            iv[ii] = (byte)((KeyPair.a2b(buf[i++]) << 4 & 0xF0) + (KeyPair.a2b(buf[i++]) & 0xF));
                        }
                        continue;
                    }
                    if (buf[i] == 13 && i + 1 < buf.length && buf[i + 1] == 10) {
                        ++i;
                        continue;
                    }
                    if (buf[i] == 10 && i + 1 < buf.length) {
                        if (buf[i + 1] == 10) {
                            i += 2;
                            break;
                        }
                        if (buf[i + 1] == 13 && i + 2 < buf.length && buf[i + 2] == 10) {
                            i += 3;
                            break;
                        }
                        boolean inheader = false;
                        for (int j = i + 1; j < buf.length && buf[j] != 10; ++j) {
                            if (buf[j] != 58) continue;
                            inheader = true;
                            break;
                        }
                        if (!inheader) {
                            ++i;
                            encrypted = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (type == 0) {
                    throw new JSchException("invalid privatekey: " + prvkey);
                }
                int start = i;
                while (i < len) {
                    if (buf[i] == 10) {
                        boolean xd = buf[i - 1] == 13;
                        System.arraycopy(buf, i + 1, buf, i - (xd ? 1 : 0), len - i - 1 - (xd ? 1 : 0));
                        if (xd) {
                            --len;
                        }
                        --len;
                        continue;
                    }
                    if (buf[i] == 45) break;
                    ++i;
                }
                if ((data = Util.fromBase64(buf, start, i - start)).length > 4 && data[0] == 63 && data[1] == 111 && data[2] == -7 && data[3] == -21) {
                    Buffer _buf = new Buffer(data);
                    _buf.getInt();
                    _buf.getInt();
                    byte[] _type = _buf.getString();
                    byte[] _cipher = _buf.getString();
                    String cipher = new String(_cipher);
                    if (cipher.equals("3des-cbc")) {
                        _buf.getInt();
                        byte[] foo = new byte[data.length - _buf.getOffSet()];
                        _buf.getByte(foo);
                        data = foo;
                        encrypted = true;
                        throw new JSchException("unknown privatekey format: " + prvkey);
                    }
                    if (cipher.equals("none")) {
                        _buf.getInt();
                        _buf.getInt();
                        encrypted = false;
                        byte[] foo = new byte[data.length - _buf.getOffSet()];
                        _buf.getByte(foo);
                        data = foo;
                    }
                }
                if (pubkey == null) break block58;
                try {
                    file = new File(pubkey);
                    fis = new FileInputStream(pubkey);
                    buf = new byte[(int)file.length()];
                    len = 0;
                    while ((i = fis.read(buf, len, buf.length - len)) > 0) {
                        len += i;
                    }
                    fis.close();
                    if (buf.length > 4 && buf[0] == 45 && buf[1] == 45 && buf[2] == 45 && buf[3] == 45) {
                        boolean valid = true;
                        i = 0;
                        while (buf.length > ++i && buf[i] != 10) {
                        }
                        if (buf.length <= i) {
                            valid = false;
                        }
                        while (valid) {
                            if (buf[i] == 10) {
                                boolean inheader = false;
                                for (int j = i + 1; j < buf.length && buf[j] != 10; ++j) {
                                    if (buf[j] != 58) continue;
                                    inheader = true;
                                    break;
                                }
                                if (!inheader) {
                                    ++i;
                                    break;
                                }
                            }
                            ++i;
                        }
                        if (buf.length <= i) {
                            valid = false;
                        }
                        start = i;
                        while (valid && i < len) {
                            if (buf[i] == 10) {
                                System.arraycopy(buf, i + 1, buf, i, len - i - 1);
                                --len;
                                continue;
                            }
                            if (buf[i] == 45) break;
                            ++i;
                        }
                        if (valid) {
                            publickeyblob = Util.fromBase64(buf, start, i - start);
                            if (type == 3) {
                                if (publickeyblob[8] == 100) {
                                    type = 1;
                                } else if (publickeyblob[8] == 114) {
                                    type = 2;
                                }
                            }
                        }
                    } else if (buf[0] == 115 && buf[1] == 115 && buf[2] == 104 && buf[3] == 45) {
                        for (i = 0; i < len && buf[i] != 32; ++i) {
                        }
                        if (++i < len) {
                            start = i;
                            while (i < len && buf[i] != 32) {
                                ++i;
                            }
                            publickeyblob = Util.fromBase64(buf, start, i - start);
                        }
                    }
                }
                catch (Exception ee) {}
            }
            catch (Exception e) {
                if (e instanceof JSchException) {
                    throw (JSchException)e;
                }
                if (e instanceof Throwable) {
                    throw new JSchException(e.toString(), e);
                }
                throw new JSchException(e.toString());
            }
        }
        KeyPair kpair = null;
        if (type == 1) {
            kpair = new KeyPairDSA(jsch);
        } else if (type == 2) {
            kpair = new KeyPairRSA(jsch);
        }
        if (kpair != null) {
            kpair.encrypted = encrypted;
            kpair.publickeyblob = publickeyblob;
            kpair.vendor = vendor;
            if (encrypted) {
                kpair.iv = iv;
                kpair.data = data;
            } else {
                if (kpair.parse(data)) {
                    return kpair;
                }
                throw new JSchException("invalid privatekey: " + prvkey);
            }
        }
        return kpair;
    }

    private static byte a2b(byte c) {
        if (48 <= c && c <= 57) {
            return (byte)(c - 48);
        }
        return (byte)(c - 97 + 10);
    }

    private static byte b2a(byte c) {
        if (0 <= c && c <= 9) {
            return (byte)(c + 48);
        }
        return (byte)(c - 10 + 65);
    }

    public void dispose() {
        Util.bzero(this.passphrase);
    }

    public void finalize() {
        this.dispose();
    }
}

