/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public class SyntaxHighlightingColorScheme {
    public SyntaxScheme[] syntaxSchemes = new SyntaxScheme[27];

    public SyntaxHighlightingColorScheme(boolean bl) {
        if (bl) {
            Font font;
            Color color = new Color(0, 128, 0);
            Color color2 = new Color(164, 0, 0);
            Color color3 = Color.BLUE;
            Color color4 = new Color(173, 128, 0);
            Color color5 = new Color(100, 0, 200);
            Color color6 = new Color(220, 0, 156);
            Color color7 = new Color(148, 148, 0);
            Font font2 = RSyntaxTextArea.getDefaultFont();
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            Font font3 = styleContext.getFont(font2.getFamily(), 1, font2.getSize());
            Font font4 = font = styleContext.getFont(font2.getFamily(), 2, font2.getSize());
            Font font5 = font3;
            this.syntaxSchemes[1] = null;
            this.syntaxSchemes[2] = new SyntaxScheme(color, null, font4);
            this.syntaxSchemes[3] = new SyntaxScheme(color, null, font4);
            this.syntaxSchemes[4] = new SyntaxScheme(color2, null, font4);
            this.syntaxSchemes[5] = new SyntaxScheme(color3, null, font5);
            this.syntaxSchemes[6] = new SyntaxScheme(color4, null);
            this.syntaxSchemes[7] = null;
            this.syntaxSchemes[8] = new SyntaxScheme(color5, null);
            this.syntaxSchemes[9] = new SyntaxScheme(color5, null);
            this.syntaxSchemes[10] = new SyntaxScheme(color5, null);
            this.syntaxSchemes[11] = new SyntaxScheme(color5, null);
            this.syntaxSchemes[12] = new SyntaxScheme(color6, null);
            this.syntaxSchemes[13] = new SyntaxScheme(color6, null);
            this.syntaxSchemes[14] = new SyntaxScheme(color6, null);
            this.syntaxSchemes[15] = new SyntaxScheme(new Color(0, 128, 128), null);
            this.syntaxSchemes[16] = new SyntaxScheme(new Color(255, 153, 0), null);
            this.syntaxSchemes[17] = new SyntaxScheme(null, null);
            this.syntaxSchemes[18] = new SyntaxScheme(null, null);
            this.syntaxSchemes[19] = new SyntaxScheme(Color.RED, null);
            this.syntaxSchemes[20] = new SyntaxScheme(new Color(128, 64, 64), null);
            this.syntaxSchemes[21] = new SyntaxScheme(new Color(128, 128, 128), null);
            this.syntaxSchemes[22] = null;
            this.syntaxSchemes[23] = new SyntaxScheme(color7, null);
            this.syntaxSchemes[24] = new SyntaxScheme(color7, null);
            this.syntaxSchemes[25] = new SyntaxScheme(color7, null);
            this.syntaxSchemes[26] = new SyntaxScheme(color7, null);
        }
    }

    public SyntaxHighlightingColorScheme(SyntaxHighlightingColorScheme syntaxHighlightingColorScheme) {
        for (int i = 0; i < 27; ++i) {
            SyntaxScheme syntaxScheme = syntaxHighlightingColorScheme.syntaxSchemes[i];
            if (syntaxScheme == null) continue;
            this.syntaxSchemes[i] = new SyntaxScheme(syntaxScheme.foreground, syntaxScheme.background, syntaxScheme.font, syntaxScheme.underline);
            this.syntaxSchemes[i].fontMetrics = syntaxScheme.fontMetrics;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntaxHighlightingColorScheme)) {
            return false;
        }
        SyntaxScheme[] syntaxSchemeArray = ((SyntaxHighlightingColorScheme)object).syntaxSchemes;
        int n = this.syntaxSchemes.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.syntaxSchemes[i] == null ? syntaxSchemeArray[i] != null : !this.syntaxSchemes[i].equals(syntaxSchemeArray[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.syntaxSchemes.length;
        for (int i = 0; i < n2; ++i) {
            if (this.syntaxSchemes[i] == null) continue;
            n = this.syntaxSchemes[i].hashCode();
            break;
        }
        return n;
    }

    public static SyntaxHighlightingColorScheme loadFromString(String string) {
        SyntaxHighlightingColorScheme syntaxHighlightingColorScheme = new SyntaxHighlightingColorScheme(true);
        try {
            if (string != null) {
                int n = 27;
                int n2 = n * 7;
                String[] stringArray = string.split(",", -1);
                if (stringArray.length != n2) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + n2 + ", found " + stringArray.length);
                }
                for (int i = 0; i < n; ++i) {
                    int n3 = i * 7;
                    int n4 = Integer.parseInt(stringArray[n3]);
                    if (n4 != i) {
                        throw new Exception("Expected " + i + ", found " + n4);
                    }
                    Color color = null;
                    String string2 = stringArray[n3 + 1];
                    color = "-".equals(string2) ? null : new Color(Integer.parseInt(string2));
                    Color color2 = null;
                    string2 = stringArray[n3 + 2];
                    color2 = "-".equals(string2) ? null : new Color(Integer.parseInt(string2));
                    string2 = stringArray[n3 + 3];
                    if (!"t".equals(string2) && !"f".equals(string2)) {
                        throw new Exception("Expected 't' or 'f', found " + string2);
                    }
                    boolean bl = "t".equals(string2);
                    Font font = null;
                    String string3 = stringArray[n3 + 4];
                    if (!"-".equals(string3)) {
                        font = new Font(string3, Integer.parseInt(stringArray[n3 + 5]), Integer.parseInt(stringArray[n3 + 6]));
                    }
                    syntaxHighlightingColorScheme.syntaxSchemes[i] = new SyntaxScheme(color, color2, font, bl);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return syntaxHighlightingColorScheme;
    }

    public String toCommaSeparatedString() {
        String string = "";
        for (int i = 0; i < 27; ++i) {
            string = string + i + ",";
            SyntaxScheme syntaxScheme = this.syntaxSchemes[i];
            if (syntaxScheme == null) {
                string = string + "-,-,f,-,,,";
                continue;
            }
            Color color = syntaxScheme.foreground;
            string = string + (color != null ? color.getRGB() + "," : "-,");
            color = syntaxScheme.background;
            string = string + (color != null ? color.getRGB() + "," : "-,");
            string = string + (syntaxScheme.underline ? "t," : "f,");
            Font font = syntaxScheme.font;
            string = font != null ? string + font.getFamily() + "," + font.getStyle() + "," + font.getSize() + "," : string + "-,,,";
        }
        return string.substring(0, string.length() - 1);
    }
}

