/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.CompletionProvider;

public abstract class CompletionProviderBase
implements CompletionProvider {
    private CompletionProvider parent;
    private ListCellRenderer listCellRenderer;
    private char paramListStart;
    private char paramListEnd;
    private String paramListSeparator;
    protected static final String EMPTY_STRING = "";

    public void clearParameterizedCompletionParams() {
        this.paramListStart = '\u0000';
        this.paramListEnd = '\u0000';
        this.paramListSeparator = null;
    }

    public List getCompletions(JTextComponent jTextComponent) {
        List list = this.getCompletionsImpl(jTextComponent);
        if (this.parent != null) {
            list.addAll(this.parent.getCompletions(jTextComponent));
            Collections.sort(list);
        }
        return list;
    }

    protected abstract List getCompletionsImpl(JTextComponent var1);

    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    public char getParameterListEnd() {
        return this.paramListEnd;
    }

    public String getParameterListSeparator() {
        return this.paramListSeparator;
    }

    public char getParameterListStart() {
        return this.paramListStart;
    }

    public CompletionProvider getParent() {
        return this.parent;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.listCellRenderer = listCellRenderer;
    }

    public void setParameterizedCompletionParams(char c, String string, char c2) {
        if (c < ' ' || c == '\u007f') {
            throw new IllegalArgumentException("Invalid listStart");
        }
        if (c2 < ' ' || c2 == '\u007f') {
            throw new IllegalArgumentException("Invalid listEnd");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid separator");
        }
        this.paramListStart = c;
        this.paramListSeparator = string;
        this.paramListEnd = c2;
    }

    public void setParent(CompletionProvider completionProvider) {
        this.parent = completionProvider;
    }
}

