/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.options;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.options.Options;
import com.adobe.xmp.options.PropertyOptions;

public final class AliasOptions
extends Options {
    public static final int PROP_DIRECT = 0;
    public static final int PROP_ARRAY = 512;
    public static final int PROP_ARRAY_ORDERED = 1024;
    public static final int PROP_ARRAY_ALTERNATE = 2048;
    public static final int PROP_ARRAY_ALT_TEXT = 4096;

    public AliasOptions() {
    }

    public AliasOptions(int n) throws XMPException {
        super(n);
    }

    public boolean isSimple() {
        return this.getOptions() == 0;
    }

    public boolean isArray() {
        return this.getOption(512);
    }

    public AliasOptions setArray(boolean bl) {
        this.setOption(512, bl);
        return this;
    }

    public boolean isArrayOrdered() {
        return this.getOption(1024);
    }

    public AliasOptions setArrayOrdered(boolean bl) {
        this.setOption(1536, bl);
        return this;
    }

    public boolean isArrayAlternate() {
        return this.getOption(2048);
    }

    public AliasOptions setArrayAlternate(boolean bl) {
        this.setOption(3584, bl);
        return this;
    }

    public boolean isArrayAltText() {
        return this.getOption(4096);
    }

    public AliasOptions setArrayAltText(boolean bl) {
        this.setOption(7680, bl);
        return this;
    }

    public PropertyOptions toPropertyOptions() throws XMPException {
        return new PropertyOptions(this.getOptions());
    }

    protected String defineOptionName(int n) {
        switch (n) {
            case 0: {
                return "PROP_DIRECT";
            }
            case 512: {
                return "ARRAY";
            }
            case 1024: {
                return "ARRAY_ORDERED";
            }
            case 2048: {
                return "ARRAY_ALTERNATE";
            }
            case 4096: {
                return "ARRAY_ALT_TEXT";
            }
        }
        return null;
    }

    protected int getValidOptions() {
        return 7680;
    }
}

