/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPSchemaRegistry;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.options.AliasOptions;
import com.adobe.xmp.properties.XMPAliasInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class XMPSchemaRegistryImpl
implements XMPSchemaRegistry,
XMPConst {
    private Map namespaceToPrefixMap = new HashMap();
    private Map prefixToNamespaceMap = new HashMap();
    private Map aliasMap = new HashMap();
    private Pattern p = Pattern.compile("[/*?\\[\\]]");

    public XMPSchemaRegistryImpl() {
        try {
            this.registerStandardNamespaces();
            this.registerStandardAliases();
        }
        catch (XMPException xMPException) {
            throw new RuntimeException("The XMPSchemaRegistry cannot be initialized!");
        }
    }

    public synchronized String registerNamespace(String string, String string2) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPrefix(string2);
        if (string2.charAt(string2.length() - 1) != ':') {
            string2 = string2 + ':';
        }
        if (!Utils.isXMLNameNS(string2.substring(0, string2.length() - 1))) {
            throw new XMPException("The prefix is a bad XML name", 201);
        }
        String string3 = (String)this.namespaceToPrefixMap.get(string);
        String string4 = (String)this.prefixToNamespaceMap.get(string2);
        if (string3 != null) {
            return string3;
        }
        if (string4 != null) {
            String string5 = string2;
            int n = 1;
            while (this.prefixToNamespaceMap.containsKey(string5)) {
                string5 = string2.substring(0, string2.length() - 1) + "_" + n + "_:";
                ++n;
            }
            string2 = string5;
        }
        this.prefixToNamespaceMap.put(string2, string);
        this.namespaceToPrefixMap.put(string, string2);
        return string2;
    }

    public synchronized void deleteNamespace(String string) {
        String string2 = this.getNamespacePrefix(string);
        if (string2 != null) {
            this.namespaceToPrefixMap.remove(string);
            this.prefixToNamespaceMap.remove(string2);
        }
    }

    public synchronized String getNamespacePrefix(String string) {
        return (String)this.namespaceToPrefixMap.get(string);
    }

    public synchronized String getNamespaceURI(String string) {
        if (string != null && !string.endsWith(":")) {
            string = string + ":";
        }
        return (String)this.prefixToNamespaceMap.get(string);
    }

    public synchronized Map getNamespaces() {
        return Collections.unmodifiableMap(new TreeMap(this.namespaceToPrefixMap));
    }

    public synchronized Map getPrefixes() {
        return Collections.unmodifiableMap(new TreeMap(this.prefixToNamespaceMap));
    }

    private void registerStandardNamespaces() throws XMPException {
        this.registerNamespace("http://www.w3.org/XML/1998/namespace", "xml");
        this.registerNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.registerNamespace("http://purl.org/dc/elements/1.1/", "dc");
        this.registerNamespace("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore");
        this.registerNamespace("adobe:ns:meta/", "x");
        this.registerNamespace("http://ns.adobe.com/iX/1.0/", "iX");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/", "xap");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/rights/", "xapRights");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/mm/", "xapMM");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/bj/", "xapBJ");
        this.registerNamespace("http://ns.adobe.com/xmp/note/", "xmpNote");
        this.registerNamespace("http://ns.adobe.com/pdf/1.3/", "pdf");
        this.registerNamespace("http://ns.adobe.com/pdfx/1.3/", "pdfx");
        this.registerNamespace("http://www.npes.org/pdfx/ns/id/", "pdfxid");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/type#", "pdfaType");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/field#", "pdfaField");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/id/", "pdfaid");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/extension/", "pdfaExtension");
        this.registerNamespace("http://ns.adobe.com/photoshop/1.0/", "photoshop");
        this.registerNamespace("http://ns.adobe.com/album/1.0/", "album");
        this.registerNamespace("http://ns.adobe.com/exif/1.0/", "exif");
        this.registerNamespace("http://ns.adobe.com/exif/1.0/aux/", "aux");
        this.registerNamespace("http://ns.adobe.com/tiff/1.0/", "tiff");
        this.registerNamespace("http://ns.adobe.com/png/1.0/", "png");
        this.registerNamespace("http://ns.adobe.com/jpeg/1.0/", "jpeg");
        this.registerNamespace("http://ns.adobe.com/jp2k/1.0/", "jp2k");
        this.registerNamespace("http://ns.adobe.com/camera-raw-settings/1.0/", "crs");
        this.registerNamespace("http://ns.adobe.com/StockPhoto/1.0/", "bmsp");
        this.registerNamespace("http://ns.adobe.com/asf/1.0/", "asf");
        this.registerNamespace("http://ns.adobe.com/xmp/wav/1.0/", "wav");
        this.registerNamespace("http://ns.adobe.com/xmp/1.0/DynamicMedia/", "xmpDM");
        this.registerNamespace("http://ns.adobe.com/xmp/transient/1.0/", "xmpx");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/t/", "xapT");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/t/pg/", "xapTPg");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/g/", "xapG");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/g/img/", "xapGImg");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Font#", "stFNT");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Dimensions#", "stDim");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#", "stEvt");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ResourceRef#", "stRef");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Version#", "stVer");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Job#", "stJob");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ManifestItem#", "stMfs");
        this.registerNamespace("http://ns.adobe.com/xmp/Identifier/qual/1.0/", "xmpidq");
    }

    public synchronized XMPAliasInfo resolveAlias(String string, String string2) {
        String string3 = this.getNamespacePrefix(string);
        if (string3 == null) {
            return null;
        }
        return (XMPAliasInfo)this.aliasMap.get(string3 + string2);
    }

    public synchronized XMPAliasInfo findAlias(String string) {
        return (XMPAliasInfo)this.aliasMap.get(string);
    }

    public synchronized XMPAliasInfo[] findAliases(String string) {
        String string2 = this.getNamespacePrefix(string);
        ArrayList<XMPAliasInfo> arrayList = new ArrayList<XMPAliasInfo>();
        if (string2 != null) {
            Iterator iterator = this.aliasMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string2)) continue;
                arrayList.add(this.findAlias(string3));
            }
        }
        return arrayList.toArray(new XMPAliasInfo[arrayList.size()]);
    }

    public synchronized void registerAlias(String string, String string2, final String string3, final String string4, AliasOptions aliasOptions) throws XMPException {
        AliasOptions aliasOptions2;
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertPropName(string2);
        ParameterAsserts.assertSchemaNS(string3);
        ParameterAsserts.assertPropName(string4);
        AliasOptions aliasOptions3 = aliasOptions2 = aliasOptions != null ? new AliasOptions(XMPNodeUtils.verifySetOptions(aliasOptions.toPropertyOptions(), null).getOptions()) : new AliasOptions();
        if (this.p.matcher(string2).find() || this.p.matcher(string4).find()) {
            throw new XMPException("Alias and actual property names must be simple", 102);
        }
        String string5 = this.getNamespacePrefix(string);
        final String string6 = this.getNamespacePrefix(string3);
        if (string5 == null) {
            throw new XMPException("Alias namespace is not registered", 101);
        }
        if (string6 == null) {
            throw new XMPException("Actual namespace is not registered", 101);
        }
        String string7 = string5 + string2;
        if (this.aliasMap.containsKey(string7)) {
            throw new XMPException("Alias is already existing", 4);
        }
        if (this.aliasMap.containsKey(string6 + string4)) {
            throw new XMPException("Actual property is already an alias, use the base property", 4);
        }
        XMPAliasInfo xMPAliasInfo = new XMPAliasInfo(){

            public String getNamespace() {
                return string3;
            }

            public String getPrefix() {
                return string6;
            }

            public String getPropName() {
                return string4;
            }

            public AliasOptions getAliasForm() {
                return aliasOptions2;
            }

            public String toString() {
                return string6 + string4 + " NS(" + string3 + "), FORM (" + this.getAliasForm() + ")";
            }
        };
        this.aliasMap.put(string7, xMPAliasInfo);
    }

    public synchronized void deleteAlias(String string, String string2) {
        String string3 = this.getNamespacePrefix(string);
        this.aliasMap.remove(string3 + string2);
    }

    public synchronized Map getAliases() {
        return Collections.unmodifiableMap(new TreeMap(this.aliasMap));
    }

    private void registerStandardAliases() throws XMPException {
        AliasOptions aliasOptions = new AliasOptions().setArrayOrdered(true);
        AliasOptions aliasOptions2 = new AliasOptions().setArrayAltText(true);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasOptions);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Authors", "http://purl.org/dc/elements/1.1/", "creator", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Description", "http://purl.org/dc/elements/1.1/", "description", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Format", "http://purl.org/dc/elements/1.1/", "format", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Keywords", "http://purl.org/dc/elements/1.1/", "subject", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Locale", "http://purl.org/dc/elements/1.1/", "language", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/rights/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasOptions);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "BaseURL", "http://ns.adobe.com/xap/1.0/", "BaseURL", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "CreationDate", "http://ns.adobe.com/xap/1.0/", "CreateDate", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Creator", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "ModDate", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Subject", "http://purl.org/dc/elements/1.1/", "description", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasOptions);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Caption", "http://purl.org/dc/elements/1.1/", "description", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Keywords", "http://purl.org/dc/elements/1.1/", "subject", null);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Marked", "http://ns.adobe.com/xap/1.0/rights/", "Marked", null);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "WebStatement", "http://ns.adobe.com/xap/1.0/rights/", "WebStatement", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Artist", "http://purl.org/dc/elements/1.1/", "creator", aliasOptions);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "DateTime", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "ImageDescription", "http://purl.org/dc/elements/1.1/", "description", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Software", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasOptions);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "CreationTime", "http://ns.adobe.com/xap/1.0/", "CreateDate", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Description", "http://purl.org/dc/elements/1.1/", "description", aliasOptions2);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "ModificationTime", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Software", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasOptions2);
    }
}

