/*	$Id: tables.c,v 1.1.1.1 2001/03/16 16:12:21 ad Exp $	*/

/*
 * Copyright (c) 2001 Andrew Doran.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Andrew Doran.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>

#include <stddef.h>

#include <dev/i2o/i2o.h>

#include "extern.h"

struct strtab {
	int	boo;
	const char	*caption;
};

static const char	*matchstrtab(const struct strtab *, int);

static const struct strtab i2o_class[] = {
	{ I2O_CLASS_EXECUTIVE, "executive" },
	{ I2O_CLASS_DDM, "device driver module" },
	{ I2O_CLASS_RANDOM_BLOCK_STORAGE, "random block storage" },
	{ I2O_CLASS_SEQUENTIAL_STORAGE,	"sequential storage" },
	{ I2O_CLASS_LAN, "LAN port" },
	{ I2O_CLASS_WAN, "WAN port" },
	{ I2O_CLASS_FIBRE_CHANNEL_PORT,	"fibrechannel port" },
	{ I2O_CLASS_FIBRE_CHANNEL_PERIPHERAL, "fibrechannel peripheral" },
 	{ I2O_CLASS_SCSI_PERIPHERAL, "SCSI peripheral" },
	{ I2O_CLASS_ATE_PORT, "ATE port" },
	{ I2O_CLASS_ATE_PERIPHERAL, "ATE peripheral" },
	{ I2O_CLASS_FLOPPY_CONTROLLER, "floppy controller" },
	{ I2O_CLASS_FLOPPY_DEVICE, "floppy device" },
	{ I2O_CLASS_BUS_ADAPTER_PORT, "bus adapter port" },
	{ 0, NULL },
};

static const char * const i2o_status[] = {
	"success",
	"abort (dirty)",
	"abort (no data transfer)",
	"abort (partial transfer)",
	"error (dirty)",
	"error (no data transfer)",
	"error (partial transfer)",
	"undefined error code",
	"process abort (dirty)",
	"process abort (no data transfer)",
	"process abort (partial transfer)",
	"transaction error",
};

static const struct strtab i2o_detail[] = {
	{ 0x0000, "success" },
	{ 0x0002, "bad key" },
	{ 0x0003, "tcl error" },
	{ 0x0004, "reply buffer full" },
	{ 0x0005, "no such page" },
	{ 0x0006, "insufficient resources (soft)" },
	{ 0x0007, "insufficient resources (hard)" },
	{ 0x0009, "chain buffer too large" },
	{ 0x000a, "unsupported function" },
	{ 0x000b, "device locked" },
	{ 0x000c, "device reset" },
	{ 0x000d, "inappropriate function" },
	{ 0x000e, "invalid initiator address" },
	{ 0x000f, "invalid message flags" },
	{ 0x0010, "invalid offset" },
	{ 0x0011, "invalid parameter" },
	{ 0x0012, "invalid request" },
	{ 0x0013, "invalid target address" },
	{ 0x0014, "message too large" },
	{ 0x0015, "message too small" },
	{ 0x0016, "missing parameter" },
	{ 0x0017, "timeout" },
	{ 0x0018, "unknown error" },
	{ 0x0019, "unknown function" },
	{ 0x001a, "unsupported version" },
	{ 0x001b, "device busy" },
	{ 0x001c, "device not available" },
	{ 0x0000, NULL },
};

static const char *
matchstrtab(const struct strtab *st, int val)
{
	int i;

	for (i = 0; st[i].caption != NULL; i++)
		if (val == st[i].boo)
			return (st[i].caption);

	return ("-- unknown --");
}

const char *
i2o_xlat_status(int code)
{

	if (code >= sizeof(i2o_status) / sizeof(i2o_status[0]))
		return ("-- unknown --");

	return (i2o_status[code]);
}		

const char *
i2o_xlat_class(int class)
{

	return (matchstrtab(i2o_class, class));
}

const char *
i2o_xlat_detail(int detail)
{

	return (matchstrtab(i2o_detail, detail));
}
