/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */
/* $Id: setdelay.c,v 1.10 2000/03/23 14:41:53 jwise Exp $ */

#include <time.h>
#include "externs.h"

void	setpolltimeout (int);
void	setpolldelay (int);


/* turn off input polling for a user */

void
setpolltimeout(int msecs)
{
	static struct timeval t;

	if (msecs < 0) {
		polltimeout = (struct timeval *) 0;
	} else {
		t.tv_sec = msecs / 1000;
		t.tv_usec = msecs - (t.tv_sec * 1000);
		polltimeout = &t;
	}
}

void
setpolldelay(int msecs)
{
	static struct itimerval it;

	if (msecs == 0)
		polldelay = (struct itimerval *) 0;
	else {
		it.it_interval.tv_sec = 0;
		it.it_interval.tv_usec = 0;
		it.it_value.tv_sec = (int) (msecs / 1000);
		it.it_value.tv_usec =
			(msecs * 1000) - (it.it_value.tv_sec * 1000000);
		polldelay = &it;
	}
}

