/* Copyright (c) 1991 by John Atwood deVries II. */
/* For copying and distribution information, see the file COPYING. */
/* $Id: globals.c,v 1.26 2001/10/31 05:16:59 jwise Exp $ */

/* "icb" global variables */

#include <sys/param.h>
#include <sys/types.h>
#include "server.h"
#include "config.h"
#include "ipcf.h"

int	icbd_log;

/* the world */
USER_ITEM	u_tab[MAX_USERS]; /* that many users possible */
GROUP_ITEM	g_tab[MAX_GROUPS]; /* only one group for now */

/* global defs */
long	TimeToDie = -1.0;
int	ShutdownNotify = 0;
int	restart = 0;
char	thishost1[MAXHOSTNAMELEN];	/* our hostname */
char	*thishost = thishost1;
int	S_kill[MAX_REAL_USERS];
int	S_bricks[MAX_REAL_USERS];

/* lookup tables */

/* commands */
const char *command_table[] =
{
	"drop",
	"shutdown",
	"wall",
	"beep",
	"cancel",
	"g",
	"invite",
	"pass",
	"boot",
	"status",
	"topic",
	"motd",
	"m",
	"echoback",
	"name",
	"v",
	"w",
	"whereis",
	"restart",
	"news",
	"hush",
	"shush",
	"s_help",
	"exclude",
	"shuttime",
	"notify",
	"talk",
	"ping",
	"nobeep",
	"brick",
	(char *) 0
};

const char *status_table[] =
{
        "r",	/* control: restricted */
        "m",	/* control: moderated */
        "p",	/* control: public */
        "i",	/* visibility: invisible */
        "s",	/* visibility: secret */
        "v",	/* visibility: visible */
	"q",	/* volume: quiet */
	"n",	/* volume: normal */
	"l",	/* volume: loud */
	"name", /* name of the group */
	"?",	/* list this table */
	"c",	/* control: controlled */
        (char *) 0
};

const char *auto_table[] =
{
        "read",		/* read messages left for you */
        "whois",	/* whois (lookup) */
        "p",		/* register (loginid, nodeid, nickname, password) */
        "rname",	/* set or change real name */
        "write",	/* leave a message for someone */
        "text",		/* text message */
	"addr",		/* snailmail address */
	"phone",	/* phone number */
        "delete",	/* delete some item */
        "info",		/* information on this service */
        "help",		/* help for use of the service */
        "?",		/* list this table */
	"cp",		/* change password */
	"email",	/* e-mail address */
	"secure", 	/* Secure more secure */
	"nosecure", 	/* Secure less secure */
	"www", 		/* www home pageinfo */
        (char *) 0
};

/* from libmurgil.a (now merged with icb server sources) */
struct Cbuf cbufs[MAX_USERS+1];/* user packet buffers (YECCH!) */
fd_set fdset;			/* player fd set for select() */
fd_set serversocks;
int highestfd = 0;

/* timeout value in usec for select() */
struct timeval *polltimeout = (struct timeval *)0;
struct itimerval *polldelay = (struct itimerval *)0;

char	*fields[MAX_FIELDS];
