/* $Id: icbdb.c,v 1.15.4.1 2003/10/24 20:52:24 jwise Exp $ */
/* 	Copyright (c) 2001 by Jim Wise	*/
/*	For copying and distribution information, see the file COPYING.	*/

#include <sys/types.h>
#include <limits.h>
#include <db.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "config.h"
#include "userdb.h"

const char *usage = "%s: usage: icbdb [-c | -d name | -f name | -h | -i] [dbfile]\n";

int
main (int argc, char **argv)
{
	int	c, initflag = 0, catflag = 0, delflag = 0, findflag = 0;
	char	*dbname, *uname;
	DB	*db;
	DBT	key, data;

	while ((c = getopt(argc, argv, "cd:f:hi")) != -1) {
		switch (c) {
		    case 'c':
			catflag++;
			break;
		    case 'd':
			delflag++;
			uname = optarg;
			break;
		    case 'f':
			findflag++;
			uname = optarg;
			break;
		    case 'h':
			fprintf(stderr, usage, argv[0]);
			exit(0);
			/* NOTREACHED */
			break;
		    case 'i':
			initflag++;
			break;
		    default:
			fprintf(stderr, "%s: unknown option %c\n", argv[0], c);
			fprintf(stderr, usage, argv[0]);
			exit(1);
		}
	}

	if ((initflag + catflag + delflag + findflag) != 1) {
		fprintf(stderr, "%s: you must specify exactly one of -c or -i\n", argv[0]);
		fprintf(stderr, usage, argv[0]);
		exit(1);
	}

	if ((dbname = argv[optind]) == NULL)
		dbname = USERDB;

	if (initflag) {
		if ((db = dbopen(dbname, O_RDWR|O_CREAT, 0600, DB_HASH, NULL)) == NULL) {
			fprintf(stderr, "%s: cannot open %s: %s\n", argv[0], dbname, strerror(errno));
			exit(1);
		}
		/* for backward compatibility, we don't store the trailing null */

		key.data="server.realname";
		key.size=strlen(key.data);
		data.data="ICB Server";
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);

		key.data="server.nick";
		key.size=strlen(key.data);
		data.data="Server";
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);
		
		key.data="server.home";
		key.size=strlen(key.data);
		data.data=SERVER_ADMIN;
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);

		key.data="server.email";
		key.size=strlen(key.data);
		data.data=SERVER_ADMIN;
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);
		
		key.data="server.text";
		key.size=strlen(key.data);
		data.data="Here to server you!";
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);
		
		key.data="server.nummsg";
		key.size=strlen(key.data);
		data.data="999";
		data.size=strlen(data.data);
		db->put(db, &key, &data, R_NOOVERWRITE);
		
		db->close(db);
	} else if (catflag) {
		if ((db = dbopen(dbname, O_RDONLY, 0600, DB_HASH, NULL)) == NULL) {
			fprintf(stderr, "%s: cannot open %s: %s\n", argv[0], dbname, strerror(errno));
			exit(1);
		}

		while(!db->seq(db, &key, &data, R_NEXT)) {
			fwrite(key.data, key.size, 1, stdout);
			printf(" = ");
			fwrite(data.data, data.size, 1, stdout);
			printf("\n");
		}

		db->close(db);
	} else if (delflag) {
		int i;
		char kbuf[KEY_SIZE];

		if ((db = dbopen(dbname, O_RDWR|O_CREAT, 0600, DB_HASH, NULL)) == NULL) {
			fprintf(stderr, "%s: cannot open %s: %s\n", argv[0], dbname, strerror(errno));
			exit(1);
		}

		for (i=0; userdbfields[i]; i++) {
			strlcpy(kbuf, uname, KEY_SIZE);
			strlcat(kbuf, userdbfields[i], KEY_SIZE);
			key.data = kbuf;
			key.size = strlen(key.data);

			db->del(db, &key, 0);
		}
		for (i = 1; i <= MAX_WRITES; i++) {
			snprintf(kbuf, KEY_SIZE, "%s.header%d", uname, i);
			key.data = kbuf;
			key.size = strlen(kbuf);
			db->del(db, &key, 0);

			snprintf(kbuf, KEY_SIZE, "%s.message%d", uname, i);
			key.data = kbuf;
			key.size = strlen(kbuf);
			db->del(db, &key, 0);

			snprintf(kbuf, KEY_SIZE, "%s.from%d", uname, i);
			key.data = kbuf;
			key.size = strlen(kbuf);
			db->del(db, &key, 0);
		}

		db->close(db);
	} else if (findflag) {
		int i;
		char kbuf[KEY_SIZE];

		if ((db = dbopen(dbname, O_RDONLY, 0600, DB_HASH, NULL)) == NULL) {
			fprintf(stderr, "%s: cannot open %s: %s\n", argv[0], dbname, strerror(errno));
			exit(1);
		}

		for (i=0; userdbfields[i]; i++) {
			strlcpy(kbuf, uname, KEY_SIZE);
			strlcat(kbuf, userdbfields[i], KEY_SIZE);
			key.data = kbuf;
			key.size = strlen(key.data);

			if(!db->get(db, &key, &data, 0)) {
				fwrite(key.data, key.size, 1, stdout);
				printf(" = ");
				fwrite(data.data, data.size, 1, stdout);
				printf("\n");
			}
		}

		db->close(db);
	}

	exit(0);
}
