/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_user.c,v 1.26 2001/10/30 19:14:59 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to change user info */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "externs.h"

void	s_help (int, int);
int	s_hush (int, int);
void	s_name (int, int);
int	s_notify (int, int);
void	s_echoback (int, int);
void	s_brick(int, int);
void	s_nobeep (int, int);

/*ARGSUSED*/
void
s_help(int n, int argc)
{
	int help_fd;
	char c;
	char line[LINE_SIZE];

	help_fd = open(ICBDHELP, O_RDONLY);

	/* if the file is there, list it, otherwise report error */
	if (help_fd >= 0) {
		line[0] = '\0';
		while (read(help_fd, &c, 1) > 0) {
			if (c == '\012') {
				sends_cmdout(n, line);
				line[0] = '\0';
			} else {
				int l;
			
				l = strlen(line);
				line[l] = c;
				line[l+1] = '\0';
			}
		}
		if (close(help_fd) != 0)
			error("Help File Close: %s", strerror(errno));
	} else {
		error("Help File Open: %s", strerror(errno));
		senderror(n, "No help file found.");
	}
}

/*ARGSUSED*/
int
s_hush(int n, int argc)
{
	int	i;
	int	personal = -1;
	int	public = -1;
	int	mode = -1;
	int	quiet = -1;
	char	*flags;
	char	*who;
	char	line[LINE_SIZE];

	who = fields[1];
	while (who[0] == '-') {
		flags = getword(who);
		for (i = 1; i < strlen(flags); i++)
			switch(flags[i]) {
			case 'q':
				if (quiet == -1)
					quiet = 1;
				else {
					senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
					return -1;
				}
				break;
			case 'n':
				if (mode == -1)
					mode = 0;
				else {
					senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
					return -1;
				}
				break;
			case 's':
				if (mode == -1)
					mode = 1;
				else {
					senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
					return -1;
				}
				break;
			case 'p':
				if (personal == -1)
					personal = 1;
				else {
					senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
					return -1;
				}
				break;
			case 'o':
				if (public == -1)
					public = 1;
				else {
					senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
					return -1;
				}
				break;
			default:
				senderror(n, "Usage: hush {-q} {-p} {-o} {-n nickname | -s address}");
				return -1;
				/* NOTREACHED */
				break;
			}
		who = get_tail(who);
		}
	if (quiet == -1) quiet = 0;
	if (mode == -1) mode = 0;
	if ((personal == -1) && (public == -1)) {
		personal = 1;
		public = 1;
	}

	if (strlen(who) > 0) {
		ucaseit(who);
		if (mode == 1) { /* site addr */
			if (personal == 1) {
				if (nlpresent(who, *u_tab[n].pri_s_hushed) == 0) {
					if (nlcount(*u_tab[n].pri_s_hushed) == MAX_HUSHED) {
						senderror(n, "Max number of site personal hushes reached.");
						return -1;
					}
					nlput(u_tab[n].pri_s_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s added to site personal hush list.", who);
						sendstatus(n, "Hush", line);
					}
				} else {
					nldelete(u_tab[n].pri_s_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s removed from site personal hush list.", who);
						sendstatus(n, "Hush", line);
					}
				}
			}
			if (public == 1) {
				if (nlpresent(who, *u_tab[n].pub_s_hushed) == 0) {
					if (nlcount(*u_tab[n].pub_s_hushed) == MAX_HUSHED) {
						senderror(n, "Max number of site open hushes reached.");
						return -1;
					}
					nlput(u_tab[n].pub_s_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s added to site open hush list.", who);
						sendstatus(n, "Hush", line);
					}
				} else {
					nldelete(u_tab[n].pub_s_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s removed from site open hush list.", who);
						sendstatus(n, "Hush", line);
					}
				}
			}
		} else {
			/* nickname */
			if (personal == 1) {
				if (nlpresent(who, *u_tab[n].pri_n_hushed) == 0) {
					if (nlcount(*u_tab[n].pri_n_hushed) == MAX_HUSHED) {
						senderror(n, "Max number of nickname personal hushes reached.");
						return -1;
					}
					nlput(u_tab[n].pri_n_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s added to nickname personal hush list.", who);
						sendstatus(n, "Hush", line);
					}
				} else {
					nldelete(u_tab[n].pri_n_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s removed from nickname personal hush list.", who);
						sendstatus(n, "Hush", line);
					}
				}
			}
			if (public == 1) {
				if (nlpresent(who, *u_tab[n].pub_n_hushed) == 0) {
					if (nlcount(*u_tab[n].pub_n_hushed) == MAX_HUSHED) {
						senderror(n, "Max number of nickname open hushes reached.");
						return -1;
					}
					nlput(u_tab[n].pub_n_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s added to nickname open hush list.", who);
						sendstatus(n, "Hush", line);
					}
				} else {
					nldelete(u_tab[n].pub_n_hushed, who);
					if (quiet == 0) {
						snprintf(line, LINE_SIZE, "%s removed from nickname open hush list.", who);
						sendstatus(n, "Hush", line);
					}
				}
			}
		}
	} else
		if ((nlcount(*u_tab[n].pri_n_hushed) == 0) && (nlcount(*u_tab[n].pub_n_hushed) == 0)
				&& (nlcount(*u_tab[n].pri_s_hushed) == 0) && (nlcount(*u_tab[n].pub_s_hushed) == 0))
			sendstatus(n, "Hush-List", "Empty List");
		else {
			if (nlcount(*u_tab[n].pri_n_hushed) > 0)
				for (i = 0; i < nlcount(*u_tab[n].pri_n_hushed); i++) 
					sendstatus(n, "Personal-Nick-Hushed", nlget(u_tab[n].pri_n_hushed));
			if (nlcount(*u_tab[n].pub_n_hushed) > 0)
				for (i = 0; i < nlcount(*u_tab[n].pub_n_hushed); i++) 
					sendstatus(n, "Open-Nick-Hushed", nlget(u_tab[n].pub_n_hushed));
			if (nlcount(*u_tab[n].pri_s_hushed) > 0)
				for (i = 0; i < nlcount(*u_tab[n].pri_s_hushed); i++) 
					sendstatus(n, "Personal-Site-Hushed", nlget(u_tab[n].pri_s_hushed));
			if (nlcount(*u_tab[n].pub_s_hushed) > 0)
				for (i = 0; i < nlcount(*u_tab[n].pub_s_hushed); i++) 
				     sendstatus(n, "Open-Site-Hushed", nlget(u_tab[n].pub_s_hushed));
	      }
	return 0;
}

void
s_name(int n, int argc)
{
	int	len, i, j;
	char	new_name[MAX_NICKLEN+1];
	char	line[LINE_SIZE];
	int	ret;

	if (argc == 2) {
		/* constraints:
			will only use the first max_nicklen letters of
			a nickname.
			nickname must be at least 1 character long.
			to use the nickname admin, must have password
			set to TheKey
		*/

	/* only use so much of it, but at least some of it */
		len = strlen(fields[1]);
		if (len <= 0) {
			/* oops, too short */
                	senderror(n,"The nickname may not be null.");
                	return;
		}

		strlcpy(new_name, fields[1], MAX_NICKLEN+1);
		filternickname(new_name);

	        /* make sure the nickname hasn't already been taken */

	        if ((find_user(new_name) >= 0) &&
		   (strcasecmp(new_name, u_tab[n].nickname) != 0)) {
			/* oops, someone already has this nick */
                	senderror(n,"Nickname already in use.");
                	return;
        	}

        /* make sure they are allowed to use this nickname */
		if (strcasecmp(new_name,"admin") == 0) {
		    if (strcmp(u_tab[n].password, TheKey) != 0) {
                        /* oops, password is wrong */
                        senderror(n,"Nickname already in use.");
                        return;
		    }
		}

		snprintf(line, LINE_SIZE, "%s changed nickname to %s", u_tab[n].nickname, new_name);
                s_status_group(1,0,n,"Name",line);
		nickwritetime(n, 1);
		strlcpy(u_tab[n].nickname, new_name, MAX_NICKLEN);

		/* side-effects:
			inform folx in same group of change
			if they are registered, set their real name.
		*/
		sendstatus(n,"Name",line);

        	/* check to see if we know this person */
		u_tab[n].realname[0] = '\0';
	        ret = nicklookup(-n, u_tab[n].nickname);
	        if (ret == 0) {
	                /* we know this person */
	                strlcpy(u_tab[n].realname, "registered", MAX_REALLEN);
			sends_cmdout(n, "Nick registered");
			nickwritetime(n, 0);
			for (i = 1; i < MAX_GROUPS; i++)
			if ((g_tab[i].modtimeout > 0.0) &&
			  (strcmp(g_tab[i].missingmod, u_tab[n].nickname)==0)){
			  g_tab[i].modtimeout = 0;
			  g_tab[i].mod = n;
			  g_tab[i].missingmod[0] = '\0';
			  snprintf(line, LINE_SIZE, "%s is the active moderator again.", u_tab[n].nickname);
			  for (j = 1; j < MAX_REAL_USERS; j++)
				if ((strcasecmp(u_tab[j].group, g_tab[i].name)
				    == 0) && (j != n))
				    sendstatus(j, "Mod", line);
			  snprintf(line, LINE_SIZE, "You are the moderator of group %s",
				g_tab[i].name);
			  sendstatus(n, "Mod", line);
			}
	                if ((i = nickckmsg(n)) > 0)
			{
                        	if (i == 1)
                                	sendstatus(n, 
					     "Message", "You have 1 message");
                        	else {
                                	snprintf(line, LINE_SIZE, "You have %d messages", i);
                                	sendstatus(n, "Message", line);
                                }
			}

			debug("person is known");
	        } 
		else if (ret == -2) 
			/* we know this person but they're not validated */
		{
		sendstatus(n, "Register", "Send password to authenticate your nickname.");
		j = 0;
		for (i = 0; i < MAX_GROUPS; i++)
	    	if (strcasecmp(u_tab[n].nickname, g_tab[i].missingmod) == 0) {
			snprintf(line, LINE_SIZE, "You are moderator of group %s", g_tab[i].name);
			sendstatus(n, "Mod", line);
			j++;
		    	}
		if (j == 1) sendstatus(n, "Mod", "You must register using /p <password> to regain mod of the above group.");
		if (j > 1) sendstatus(n, "Mod", "You must register using /p <password> to regain mod of the above groups.");
		}
		else {
	                /* we don't know this person */
	                u_tab[n].realname[0] = '\0';
			sendstatus(n, "No-Pass", "To register your nickname type /m server p mypassword");
			debug("person is unknown");
		}

		for (i = 0; i < MAX_GROUPS; i++)
		    talk_report (n, i);

		debug("finished checking on person");
        } else {
                error("name: wrong number of arguments");
        }
}

/*ARGSUSED*/
int
s_notify(int n, int argc)
{
	char	*who, *flags;
	char	line[LINE_SIZE];
	int	quiet = -1;
	int	mode = -1;
	int	i;

	who = fields[1];
	while (who[0] == '-') {
		flags = getword(who);
		for (i = 1; i < strlen(flags); i++)
			switch(flags[i]) {
			case 'q':
				if (quiet == -1)
					quiet = 1;
				else {
					senderror(n, "Usage: notify {-q} {-n nickname | -s address}");
					return -1;
					}
				break;
			case 'n':
				if (mode == -1)
					mode = 0;
				else {
					senderror(n, "Usage: notify {-q} {-n nickname | -s address}");
					return -1;
					}
				break;
			case 's':
				if (mode == -1)
					mode = 1;
				else {
					senderror(n, "Usage: notify {-q} {-n nickname | -s address}");
					return -1;
					}
				break;
			default:
				senderror(n, "Usage: notify {-q} {-n nickname | -s address}");
				return -1;
				/* NOTREACHED */
				break;
			}
		who = get_tail(who);
		}
	if (mode == -1) mode = 0;
	if (quiet == -1) quiet = 0;
	ucaseit(who);

	if (strlen(who) == 0)
	   if ((nlcount(*u_tab[n].n_notifies) == 0) &&
	      (nlcount(*u_tab[n].s_notifies) == 0))
		   sendstatus(n, "Notify-List", "Empty List");
	   else {
		if (nlcount(*u_tab[n].n_notifies) > 0)
		   for (i = 0; i < nlcount(*u_tab[n].n_notifies); i++)
		       sendstatus(n, "Notify-Nickname", nlget(u_tab[n].n_notifies));
		if (nlcount(*u_tab[n].s_notifies) > 0)
		   for (i = 0; i < nlcount(*u_tab[n].s_notifies); i++)
		       sendstatus(n, "Notify-Site", nlget(u_tab[n].s_notifies));
		}
	else 
	   if (mode == 1)
	      if (nlpresent(who, *u_tab[n].s_notifies) == 0) {
		if (nlcount(*u_tab[n].s_notifies) == MAX_NOTIFIES) {
			senderror(n, "Max number of site notifies reached.");
			return -1;
			}
		nlput(u_tab[n].s_notifies, who);
		if (quiet == 0) {
			snprintf(line, LINE_SIZE, "%s added to site notify list.", who);
			sendstatus(n, "Notify", line);
		}
		}
	      else {
		nldelete(u_tab[n].s_notifies, who);
		if (quiet == 0) {
			snprintf(line, LINE_SIZE, "%s removed from site notify list.", who);
			sendstatus(n, "Notify", line);
			}
		}
	   else 
	      if (nlpresent(who, *u_tab[n].n_notifies) == 0) {
		if (nlcount(*u_tab[n].n_notifies) == MAX_NOTIFIES) {
			senderror(n,"Max number of nickname notifies reached.");
			return -1;
			}
		nlput(u_tab[n].n_notifies, who);
		if (quiet == 0) {
			snprintf(line, LINE_SIZE, "%s added to nickname notify list.", who);
			sendstatus(n, "Notify", line);
			if ((i = find_user(who)) > 0) {
			   snprintf(line, LINE_SIZE, "%s is logged in now.", u_tab[i].nickname);
			   sendstatus(n, "Notify", line);
			   }
			}
		}
	      else {
		nldelete(u_tab[n].n_notifies, who);
		if (quiet == 0) {
			snprintf(line, LINE_SIZE, "%s removed from nickname notify list.", who);
			sendstatus(n, "Notify", line);
			}
		}
return 0;
}

void
s_echoback(int n, int argc)
{
       if (argc == 2) {
		if(strcasecmp(fields[1],"off") == 0) {
			u_tab[n].echoback = 0; /* off */
			sendstatus(n, "Echo","Echoback off");	
		} else if (strcasecmp(fields[1],"on") == 0) {
			u_tab[n].echoback = 1; /* on */
			sendstatus(n,"Echo","Echoback on");	
		} else if (strcasecmp(fields[1],"verbose") == 0) {
			u_tab[n].echoback = 2; /* verbose */
			sendstatus(n,"Echo","Echoback on verbose");
		} else {
			senderror(n,"Echoback: needs on/off/verbose");
		}
        } else {
                error("echoback: wrong number of arguments");
        }
}

/*
 * I got this code from Scott Reynold's hacked ICB, where it was marked
 * ifdef WARPED
 */
void
s_brick(int n, int argc)
{
        char    target[MAX_NICKLEN + 1];
	char	line[LINE_SIZE];
        int     t;

        if (argc == 2) {
                strlcpy(target, fields[1], MAX_NICKLEN+1);
                target[sizeof(target) - 1] = '\0';
                filternickname(target);
                t = find_user(target);
        } else {
                target[0] = '\0';
                t = (-1);
        }

        if (t < 0 && strcmp(target, "") == 0) {
                if (S_bricks[n] > 0) {
                        snprintf(line, LINE_SIZE, "You have %d brick%s remaining.", S_bricks[n], S_bricks[n] == 1 ? "" : "s");
                } else if (S_bricks[n] < 0) {
                        snprintf(line, LINE_SIZE, "You owe %d bricks.", (-S_bricks[n]));
                } else {
                        strlcpy(line, "You have no bricks remaining.", LINE_SIZE);
                }
                sendstatus(n, "Message", line);
                return;
        }

        S_bricks[n]--;
        if (S_bricks[n] < (-5)) {
                senderror(n, "You are out of bricks.  Good bye.");
                snprintf(line, LINE_SIZE, "[DROP] out of bricks; dropped %s (%d)", u_tab[n].nickname, n);
                error(line);
                S_kill[n]++;
        } else if (S_bricks[n] < (-4)) {
                snprintf(line, LINE_SIZE, "%s has fallen, and can't get up.", u_tab[n].nickname);
                s_status_group(1, 1, n, "FYI", line);
                senderror(n, "You are out of bricks.  Please desist.");
        } else if (S_bricks[n] < 0) {
                senderror(n, "You are out of bricks.");
        } else if (t < 0 || strcasecmp(target, "server") == 0) {
                s_status_group(1, 1, n, "FYI",
                    "A brick flies off into the ether.");
        } else {
                if (S_bricks[t] < MAX_BRICKS && t != n)
                        S_bricks[t]++;
                snprintf(line, LINE_SIZE, "%s has been bricked.", target);
                s_status_group(1, 1, n, "FYI", line);
                if (strcasecmp(u_tab[n].group, u_tab[t].group) != 0)
                        s_status_group(1, 1, t, "FYI", line);
        }
}

void
s_nobeep(int n, int argc)
{
       if (argc == 2) {
		if(strcasecmp(fields[1],"off") == 0) {
			u_tab[n].nobeep = 0; /* off */
			sendstatus(n, "No-Beep","No-Beep off");	
		} else if (strcasecmp(fields[1],"on") == 0) {
			u_tab[n].nobeep = 1; /* on */
			sendstatus(n,"No-Beep","No-Beep on");	
		} else if (strcasecmp(fields[1],"verbose") == 0) {
			u_tab[n].nobeep = 2; /* verbose */
			sendstatus(n,"No-Beep","No-Beep on (verbose)");
		} else {
			senderror(n,"No-Beep: needs off/on/verbose");
		}
        } else {
                error("nobeep: wrong number of arguments");
        }
}
