/* Copyright (c) 1991 by John Atwood deVries II. */
/* For copying and distribution information, see the file COPYING. */
/* $Id: dispatch.c,v 1.15 2001/10/31 05:16:59 jwise Exp $ */

/* handle a packet from the server */
#include "externs.h"

void	dispatch(int, char *);

void
dispatch(int n, char *pkt)
{
	/* n is socket on which the message arrived */
	/* pkt is packet buffer */
	switch(*pkt) {
	    case ICB_LOGIN:
		if(n >= MAX_REAL_USERS) {
			senderror(n, "ICB is full.");
			sendexit(n);
			disconnectuser(n);
		}
		if(loginmsg(n, ++pkt) < 0) {
			/* login failed.  dump them */
			sendexit(n);
		}
		break;

            case ICB_OPEN:
                openmsg(n, ++pkt);
                break;

            case ICB_COMMAND:
                cmdmsg(n, ++pkt);
                break;

	    case ICB_PONG:
		pong(n, pkt);
		break;

	    default:
		error("%d: Invalid packet type \"%c\"", n, *pkt);
	}
}
