#!/usr/bin/perl
# Quickhack script for doing opcode table conversions
# monkey with it as you like ...

my %A1_X = (
		call => "1",
		callf => "1",
		ja => "1",
		jbe => "1",
		jc => "1",
		jcxz => "1",
		jg => "1",
		jge => "1",
		jl => "1",
		jle => "1",
		jmp => "1",
		jnc => "1",
		jno => "1",
		jns => "1",
		jnz => "1",
		jo => "1",
		jpe => "1",
		jpo => "1",
		js => "1",
		jz => "1",
		loop => "1",
		loopnz => "1",
		loopz => "1"
);
my %A1_R = (
		arpl => "INS_SYSTEM",
		bound => "INS_ARRAY",
		bsf => "INS_FLAG",
		bsr => "INS_FLAG",
		bt => "INS_FLAG",
		btc => "INS_FLAG | INS_LOGIC",
		btr => "INS_FLAG",
		bts => "INS_FLAG",
		cflsh => "NULL",
		clc => "INS_FLAG",
		cld => "INS_FLAG",
		cli => "INS_FLAG | INS_SYSTEM",
		clts => "INS_FLAG | INS_SYSTEM",
		cmc => "INS_FLAG",
		cmp => "INS_FLAG",
		cmpeqps => "INS_FLAG",
		cmpleps => "INS_FLAG",
		cmpltps => "INS_FLAG",
		cmpneqps => "INS_FLAG",
		cmpnleps => "INS_FLAG",
		cmpnltps => "INS_FLAG",
		cmpordps => "INS_FLAG",
		cmpsb => "INS_FLAG | INS_ARRAY",
		cmpsd => "INS_FLAG | INS_ARRAY",
		cmpunordps => "INS_FLAG",
		cs => "NULL",
		cvtpi2ps => "NULL",
		cvtps2pi => "NULL",
		cvttps2pi => "NULL",
		div => 1,
		ds => "NULL",
		emms => "NULL",
		enter => "INS_FRAME",
		es => "NULL",
		fs => "NULL",
		gs => "NULL",
		hlt => "INS_SYSTEM",
		idiv => "INS_ARITH",
		imul => "INS_ARITH",
		inc => "INS_ARITH",
		insb => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		insd => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		int => "INS_SYSTEM",
		int3 => "INS_SYSTEM",
		into => "INS_SYSTEM",
		invd => "INS_SYSTEM",
		invlpg => "INS_SYSTEM",
		iret => "INS_BRANCH | INS_RET | INS_SYSTEM",
		lahf => "INS_FLAGS",
		leave => "INS_FRAME",
		lock => "NULL",
		lodsb => "INS_ARRAY",
		lodsd => "INS_ARRAY",
		mul => "INS_ARITH",
		mulps => "NULL",
		nop => "NULL",
		push => "INS_STACK",
		rep => "NULL",
		repne => "NULL",
		ret => "INS_RET | INS_BRANCH",
		retf => "INS_RET | INS_BRANCH",
		scasb => "INS_FLAG | INS_ARRAY",
		scasd => "INS_FLAG | INS_ARRAY",
		sgdt => "INS_SYSTEM",
		sidt => "INS_SYSTEM",
		sldt => "INS_SYSTEM",
		stc => "INS_FLAG",
		std => "INS_FLAG",
		sti => "INS_FLAG | INS_SYSTEM",
		stosb => "INS_ARRAY",
		stosd => "INS_ARRAY",
		test => "INS_FLAG",
		verr => "INS_SYSTEM",
		verw => "INS_SYSTEM",
		xlat => "INS_ARRAY",
);
my %A2_W = (
		cmpxch8b => "INS_FLAG | INS_MOVE",
		cmpxchg => "INS_FLAG | INS_MOVE",
		comiss => "NULL",
		xadd => "INS_ARITH",
		xchg => "INS_MOVE",
);

open(FILE, shift());
foreach (<FILE>){
   if ( /^ *{/ ) {
      chomp;
		#Flag|destType|srcType|auxType|cpuType|mnemType|mnem|dest|src|aux|cmt
		($f, $a1, $a2, $a3, $p, $t, $m, $w, $x, $y, $z) = split /,/;
		#$t = get_inst_type($m);
		$mnem = $m;
		$mnem =~ s/[ ":]//g;
		if ( $a1 !~ "ARG_NONE" ){
			if ( exists($A1_X{$mnem}) ) { $a1 .= " | OP_X"; }
			elsif ( $A1_R{$mnem} ) { $a1 .= " | OP_R"; }
			else { $a1 .= " | OP_W";}
		}
		if ( $a2 !~ "ARG_NONE") { 
			if ( $A2_W{$mnem} ) { $a2 .= " | OP_W"; }
			else { $a2 .= " | OP_R"; }
		}
		if ( $a3 !~ "ARG_NONE") { $a3 .= " | OP_R"; }
		print "$f, $a1, $a2, $a3, $p, $t, $m, $w, $x, $y, $z\n";
   } else {
     print;
   }
}
close(FILE);


#INS_INVALID  0x00  /* Not a valid instruction */
#INS_NON      0x01  /* Not a branch instruction */
#INS_BRANCH   0x02  /* Unconditional branch */
#INS_COND  0x03  /* Conditional branch */
#INS_SUB      0x04  /* Jump to subroutine */
#INS_CONDSUB  0x05  /* Conditional jump to subroutine */
#INS_DREF  0x06  /* Data reference instruction */
#INS_DREF2 0x07  /* Two data references in instruction */
sub get_inst_type {
	%types = (
		aaa => "INS_ARITH",
		aad => "INS_ARITH",
		aam => "INS_ARITH",
		aas => "INS_ARITH",
		adc => "INS_ARITH",
		add => "INS_ARITH",
		addps => "NULL",
		and => "INS_LOGIC",
		andnps => "NULL",
		andps => "NULL",
		arpl => "INS_SYSTEM",
		bound => "INS_ARRAY",
		bsf => "INS_FLAG",
		bsr => "INS_FLAG",
		bswap => "INS_MOVE",
		bt => "INS_FLAG",
		btc => "INS_FLAG | INS_LOGIC",
		btr => "INS_FLAG",
		bts => "INS_FLAG",
		call => "INS_BRANCH | INS_SUB",
		callf => "INS_BRANCH | INS_SUB",
		cdq => "NULL",
		cflsh => "NULL",
		clc => "INS_FLAG",
		cld => "INS_FLAG",
		cli => "INS_FLAG | INS_SYSTEM",
		clts => "INS_FLAG | INS_SYSTEM",
		cmc => "INS_FLAG",
		cmova => "INS_FLAG | INS_MOVE",
		cmovbe => "INS_FLAG | INS_MOVE",
		cmovc => "INS_FLAG | INS_MOVE",
		cmovg => "INS_FLAG | INS_MOVE",
		cmovge => "INS_FLAG | INS_MOVE",
		cmovl => "INS_FLAG | INS_MOVE",
		cmovle => "INS_FLAG | INS_MOVE",
		cmovnc => "INS_FLAG | INS_MOVE",
		cmovno => "INS_FLAG | INS_MOVE",
		cmovns => "INS_FLAG | INS_MOVE",
		cmovnz => "INS_FLAG | INS_MOVE",
		cmovo => "INS_FLAG | INS_MOVE",
		cmovpe => "INS_FLAG | INS_MOVE",
		cmovpo => "INS_FLAG | INS_MOVE",
		cmovs => "INS_FLAG | INS_MOVE",
		cmovz => "INS_FLAG | INS_MOVE",
		cmp => "INS_FLAG",
		cmpeqps => "INS_FLAG",
		cmpleps => "INS_FLAG",
		cmpltps => "INS_FLAG",
		cmpneqps => "INS_FLAG",
		cmpnleps => "INS_FLAG",
		cmpnltps => "INS_FLAG",
		cmpordps => "INS_FLAG",
		cmpsb => "INS_FLAG | INS_ARRAY",
		cmpsd => "INS_FLAG | INS_ARRAY",
		cmpunordps => "INS_FLAG",
		cmpxch8b => "INS_FLAG | INS_MOVE",
		cmpxchg => "INS_FLAG | INS_MOVE",
		comiss => "NULL",
		cpuid => "INS_SYSTEM",
		cs => "NULL",
		cvtpi2ps => "NULL",
		cvtps2pi => "NULL",
		cvttps2pi => "NULL",
		cwde => "NULL",
		daa => "INS_ARITH",
		das => "INS_ARITH",
		dec => "INS_ARITH",
		div => "INS_ARITH",
		divps => "NULL",
		ds => "NULL",
		emms => "NULL",
		enter => "INS_FRAME",
		es => "NULL",
		f2xm1 => "NULL",
		fabs => "INS_FPU",
		fadd => "INS_FPU",
		faddp => "INS_FPU",
		fbld => "INS_FPU",
		fbstp => "INS_FPU",
		fchs => "INS_FPU",
		fclex => "INS_FPU",
		fcmovnb => "INS_FPU",
		fcmovnbe => "INS_FPU",
		fcmovne => "INS_FPU",
		fcmovnu => "INS_FPU",
		fcom => "INS_FPU",
		fcom2 => "INS_FPU",
		fcomi => "INS_FPU",
		fcomip => "INS_FPU",
		fcomp => "INS_FPU",
		fcomp3 => "INS_FPU",
		fcomp5 => "INS_FPU",
		fcompp => "INS_FPU",
		fcos => "INS_FPU",
		fdecstp => "INS_FPU",
		fdisi => "INS_FPU",
		fdiv => "INS_FPU",
		fdivp => "INS_FPU",
		fdivr => "INS_FPU",
		fdivrp => "INS_FPU",
		feni => "INS_FPU",
		ffree => "INS_FPU",
		ffreep => "INS_FPU",
		fiadd => "INS_FPU",
		ficom => "INS_FPU",
		ficomp => "INS_FPU",
		fidiv => "INS_FPU",
		fidivr => "INS_FPU",
		fild => "INS_FPU",
		fimul => "INS_FPU",
		fincstp => "INS_FPU",
		finit => "INS_FPU",
		fist => "INS_FPU",
		fistp => "INS_FPU",
		fisub => "INS_FPU",
		fisubr => "INS_FPU",
		fld => "INS_FPU",
		fld1 => "INS_FPU",
		fldcw => "INS_FPU",
		fldenv => "INS_FPU",
		fldl2e => "INS_FPU",
		fldl2t => "INS_FPU",
		fldlg2 => "INS_FPU",
		fldln2 => "INS_FPU",
		fldpi => "INS_FPU",
		fldz => "INS_FPU",
		fmovb => "INS_FPU",
		fmovbe => "INS_FPU",
		fmove => "INS_FPU",
		fmovu => "INS_FPU",
		fmul => "INS_FPU",
		fmulp => "INS_FPU",
		fnop => "INS_FPU",
		fpatan => "INS_FPU",
		fprem => "INS_FPU",
		fprem1 => "INS_FPU",
		fptan => "INS_FPU",
		frinear => "INS_FPU",
		frint2 => "INS_FPU",
		frndint => "INS_FPU",
		frstor => "INS_FPU",
		frstpm => "INS_FPU",
		fs => "NULL",
		fsave => "INS_FPU",
		fscale => "INS_FPU",
		fsetpm => "INS_FPU",
		fsin => "INS_FPU",
		fsincos => "INS_FPU",
		fsqrt => "INS_FPU",
		fst => "INS_FPU",
		fstcw => "INS_FPU",
		fstdw => "INS_FPU",
		fstenv => "INS_FPU",
		fstp => "INS_FPU",
		fstp8 => "INS_FPU",
		fstp9 => "INS_FPU",
		fstsg => "INS_FPU",
		fstsw => "INS_FPU",
		fsub => "INS_FPU",
		fsubp => "INS_FPU",
		fsubr => "INS_FPU",
		fsubrp => "INS_FPU",
		ftst => "INS_FPU",
		fucom => "INS_FPU",
		fucomi => "INS_FPU",
		fucomip => "INS_FPU",
		fucomp => "INS_FPU",
		fucompp => "INS_FPU",
		fxam => "INS_FPU",
		fxch => "INS_FPU",
		fxch4 => "INS_FPU",
		fxch7 => "INS_FPU",
		fxrstor => "INS_FPU",
		fxsave => "INS_FPU",
		fxtract => "INS_FPU",
		fyl2x => "INS_FPU",
		fyl2xp1 => "INS_FPU",
		gs => "NULL",
		hlt => "INS_SYSTEM",
		idiv => "INS_ARITH",
		imul => "INS_ARITH",
		in => "INS_MOVE | INS_SYSTEM",
		inc => "INS_ARITH",
		insb => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		insd => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		int => "INS_SYSTEM",
		int3 => "INS_SYSTEM",
		into => "INS_SYSTEM",
		invd => "INS_SYSTEM",
		invlpg => "INS_SYSTEM",
		iret => "INS_BRANCH | INS_RET | INS_SYSTEM",
		ja => "INS_COND",
		jbe => "INS_COND",
		jc => "INS_COND",
		jcxz => "INS_COND",
		jg => "INS_COND",
		jge => "INS_COND",
		jl => "INS_COND",
		jle => "INS_COND",
		jmp => "INS_BRANCH",
		jnc => "INS_COND",
		jno => "INS_COND",
		jns => "INS_COND",
		jnz => "INS_COND",
		jo => "INS_COND",
		jpe => "INS_COND",
		jpo => "INS_COND",
		js => "INS_COND",
		jz => "INS_COND",
		lahf => "INS_FLAGS",
		lar => "INS_SYSTEM",
		ldmxcsr => "NULL",
		lds => "INS_PTR",
		lea => "INS_PTR | INS_ARITH",
		leave => "INS_FRAME",
		les => "INS_PTR",
		lfs => "INS_PTR",
		lgdt => "INS_SYSTEM",
		lgs => "INS_PTR",
		lidt => "INS_SYSTEM",
		lldt => "INS_SYSTEM",
		lmsw => "INS_SYSTEM",
		lock => "NULL",
		lodsb => "INS_ARRAY",
		lodsd => "INS_ARRAY",
		loop => "INS_BRANCH",
		loopnz => "INS_COND",
		loopz => "INS_COND",
		lsl => "INS_SYSTEM",
		lss => "INS_PTR",
		ltr => "INS_SYSTEM",
		maskmovq => "NULL",
		maxps => "NULL",
		minps => "NULL",
		mov => "INS_MOVE",
		movaps => "INS_MOVE",
		movd => "INS_MOVE",
		movhps => "INS_MOVE",
		movlps => "INS_MOVE",
		movmskps => "INS_MOVE",
		movntps => "INS_MOVE",
		movntq => "INS_MOVE",
		movq => "INS_MOVE",
		movsb => "INS_MOVE",
		movsd => "INS_MOVE",
		movsx => "INS_MOVE",
		movups => "INS_MOVE",
		movzx => "INS_MOVE",
		mul => "INS_ARITH",
		mulps => "NULL",
		neg => "INS_LOGIC",
		nop => "NULL",
		not => "INS_LOGIC",
		or => "INS_LOGIC",
		orps => "NULL",
		out => "INS_MOVE | INS_SYSTEM",
		outsb => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		outsd => "INS_MOVE | INS_SYSTEM | INS_ARRAY",
		packssdw => "NULL",
		packsswb => "NULL",
		packuswb => "NULL",
		paddb => "NULL",
		paddd => "NULL",
		paddsb => "NULL",
		paddsw => "NULL",
		paddusb => "NULL",
		paddusw => "NULL",
		paddw => "NULL",
		pand => "NULL",
		pandn => "NULL",
		pavgb => "NULL",
		pavgw => "NULL",
		pcmpeqb => "NULL",
		pcmpeqd => "NULL",
		pcmpeqw => "NULL",
		pcmpgtb => "NULL",
		pcmpgtd => "NULL",
		pcmpgtw => "NULL",
		pextrw => "NULL",
		pinsrw => "NULL",
		pmaddwd => "NULL",
		pmaxsw => "NULL",
		pmaxub => "NULL",
		pminsw => "NULL",
		pminub => "NULL",
		pmovmskb => "NULL",
		pmulhuw => "NULL",
		pmulhw => "NULL",
		pmullw => "NULL",
		pop => "INS_STACK",
		popad => "INS_STACK",
		popfd => "INS_STACK | INS_FLAG",
		por => "NULL",
		prefetchnta => "NULL",
		prefetcht0 => "NULL",
		prefetcht1 => "NULL",
		prefetcht2 => "NULL",
		psadbw => "NULL",
		pshuf => "NULL",
		pslld => "NULL",
		psllq => "NULL",
		psllw => "NULL",
		psrad => "NULL",
		psraw => "NULL",
		psrld => "NULL",
		psrlq => "NULL",
		psrlw => "NULL",
		psubb => "NULL",
		psubd => "NULL",
		psubsb => "NULL",
		psubsw => "NULL",
		psubusb => "NULL",
		psubusw => "NULL",
		psubw => "NULL",
		punpckhbw => "NULL",
		punpckhdq => "NULL",
		punpckhwd => "NULL",
		punpcklbw => "NULL",
		punpckldq => "NULL",
		punpcklwd => "NULL",
		push => "INS_STACK",
		pushad => "INS_STACK",
		pushfd => "INS_STACK",
		pxor => "NULL",
		rcl => "INS_ARITH",
		rcpps => "NULL",
		rcr => "INS_ARITH",
		rdmsr => "INS_SYSTEM",
		rdpmc => "NULL",
		rdtsc => "INS_SYSTEM",
		rep => "NULL",
		repne => "NULL",
		ret => "INS_RET | INS_BRANCH",
		retf => "INS_RET | INS_BRANCH",
		rol => "INS_ARITH",
		ror => "INS_ARITH",
		rsm => "INS_SYSTEM",
		rsqrtps => "NULL",
		sahf => "INS_ARITH",
		sal => "INS_ARITH",
		sar => "INS_ARITH",
		sbb => "INS_ARITH",
		scasb => "INS_FLAG | INS_ARRAY",
		scasd => "INS_FLAG | INS_ARRAY",
		seta => "INS_FLAG",
		setalc => "INS_FLAG",
		setbe => "INS_FLAG",
		setc => "INS_FLAG",
		setg => "INS_FLAG",
		setge => "INS_FLAG",
		setl => "INS_FLAG",
		setle => "INS_FLAG",
		setnc => "INS_FLAG",
		setno => "INS_FLAG",
		setns => "INS_FLAG",
		setnz => "INS_FLAG",
		seto => "INS_FLAG",
		setpe => "INS_FLAG",
		setpo => "INS_FLAG",
		sets => "INS_FLAG",
		setz => "INS_FLAG",
		sfence => "NULL",
		sgdt => "INS_SYSTEM",
		shl => "INS_ARITH",
		shld => "INS_ARITH",
		shr => "INS_ARITH",
		shrd => "INS_ARITH",
		shufps => "NULL",
		sidt => "INS_SYSTEM",
		sldt => "INS_SYSTEM",
		smi => "NULL",
		smsw => "INS_SYSTEM",
		sqrtps => "NULL",
		ss => "NULL",
		stc => "INS_FLAG",
		std => "INS_FLAG",
		sti => "INS_FLAG | INS_SYSTEM",
		stmxcsr => "NULL",
		stosb => "INS_ARRAY",
		stosd => "INS_ARRAY",
		str => "NULL",
		sub => "INS_ARITH",
		subps => "NULL",
		sysenter => "NULL",
		sysexit => "NULL",
		test => "INS_FLAG",
		ucomiss => "NULL",
		ud1 => "NULL",
		ud2 => "NULL",
		unpckhps => "NULL",
		unpcklps => "NULL",
		verr => "INS_SYSTEM",
		verw => "INS_SYSTEM",
		wait => "INS_SYSTEM",
		wbinvd => "INS_SYSTEM",
		wrmsr => "INS_SYSTEM",
		xadd => "INS_ARITH",
		xchg => "INS_MOVE",
		xlat => "INS_ARRAY",
		xor => "INS_LOGIC",
		xorps => "NULL",
   );
	$mnem = shift;
	$mnem =~ s/[ ":]//g;
	$type = "NULL";
#print ("$mnem $types{$mnem}\n");
   if ( $types{$mnem} ) {$type = $types{$mnem};}

	return $type;
}
