<!DOCTYPE xsl:stylesheet [
<!ENTITY nbsp   "&#160;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/product">
	<HTMLPAGE>
 
	<TITLE><xsl:value-of select="title"/></TITLE>

	<PAGE>
		<TYPE><xsl:value-of select="@menu"/></TYPE>

		<COLOR> 
        		<xsl:value-of select="@color"/>
		</COLOR>
	
		<PAGE-MENU color='{@menucolor}'>

			<W-PICTURE WIDTH='150'> 
				<xsl:value-of select="@picture"/>
			</W-PICTURE>	<BR/><BR/>


			<TABLE-COLUMNS border='0' cellspacing='10'>			
			<COL>
				<xsl:apply-templates select="requires"/> 
			</COL>		
			</TABLE-COLUMNS>

			<MENUSEP>OnLine</MENUSEP>

			<TABLE-COLUMNS border='0' cellspacing='10'>			
			<COL>
				<xsl:apply-templates select="onlinedemo"/>
			</COL>		
			</TABLE-COLUMNS>

		</PAGE-MENU>

		<PAGE-BODY>

		<TABLE-COLUMNS cellspacing='10'>

		<COL valign="bottom" width='90%'>
			<P ALIGN='left'> 
			<BR/>
			<FONT face='Arial' size="+3">
	                <B>&nbsp;&nbsp;<xsl:value-of select="/product/title"/></B>
			</FONT>
			</P>
		</COL>


		<COL ALIGN='RIGHT'>
			<FONT face='Arial' size="-2">
			Version:&nbsp;<xsl:value-of select="/product/version"/><BR/>
			<xsl:value-of select="/product/date"/>
			</FONT>
		</COL>

		</TABLE-COLUMNS>

		<HR width='95%' color='black'/>

		<TABLE-COLUMNS cellspacing='30'>
		<COL>
			<xsl:apply-templates select="summary"/> 
			<BR/>
			<xsl:apply-templates select="installation"/> 
		</COL>
		</TABLE-COLUMNS>

		</PAGE-BODY>

	</PAGE>

	</HTMLPAGE>

</xsl:template>

<xsl:template match="summary">
	<xsl:apply-templates/> 
</xsl:template>

<xsl:template match="installation">
	<P ALIGN='CENTER'>
	<FONT FACE='Arial' size="+1"><B>Installation.</B></FONT>
	<BR/><xsl:value-of select="comment"/>
	</P>

	<UL type="square">
	<xsl:apply-templates select="step"/> 
	</UL>	

</xsl:template>

<xsl:template match="step">
	<LI>
	<xsl:apply-templates/> 
	</LI>
</xsl:template>

<xsl:template match="requires">
	<P>

	<B>
	<xsl:apply-templates select="/product/download/page"/>
	</B><BR/>

	<FONT FACE='Arial' size="-1" color='lightgray'><I>
	<xsl:apply-templates select="/product/date"/>
	</I></FONT>

	<BR/><BR/>

	<FONT FACE='Arial' size='-1'>
		<xsl:apply-templates/> 
	</FONT>
	</P>
</xsl:template>

<xsl:template match="tool">

	<B><xsl:apply-templates select="name"/>&nbsp;</B>
	<FONT size="-1">ver:&nbsp;<xsl:value-of select="version"/></FONT><BR/>

	<I>by <xsl:value-of select="vendor"/></I><BR/>
	<FONT size="-1"><xsl:apply-templates select="page"/></FONT><BR/>

	<BR/>
	<BR/>

</xsl:template>

<xsl:template match="page">
	<A>

        <xsl:attribute name="HREF">
	<xsl:value-of select="text()"/>
        </xsl:attribute>

	<xsl:choose>

		<xsl:when test="@name">
		<xsl:value-of select="@name"/>
		</xsl:when>

		<xsl:otherwise>
		<xsl:value-of select="text()"/>
		</xsl:otherwise>

	</xsl:choose>

        </A>
</xsl:template>

<xsl:template match="mark">
	<B><I>
	<xsl:apply-templates/> 
	</I></B>
</xsl:template>


<xsl:template match="sig">
	<P ALIGN='RIGHT'>
	<I>
	<FONT COLOR='blue' FACE="Comic Sans MS">
	<xsl:apply-templates/> 
	</FONT>
	</I>
	</P>
</xsl:template>

<xsl:template match='para'>
	<P ALIGN='justify'>
	<FONT FACE='Arial' size='-1'>
	<xsl:apply-templates/> 
	</FONT>
	</P>
</xsl:template>

<xsl:template match="file">
	<FONT FACE='Arial' size="-1" color='darkblue'>
	<I>
	<xsl:apply-templates/> 
	</I>
	</FONT>
</xsl:template>

<xsl:template match="code">
	<TABLE><TR><TD BGCOLOR='lightgrey'>
	<CODE>
	<xsl:apply-templates/> 
	</CODE>
	</TD></TR></TABLE>
</xsl:template>


<xsl:template match="motto">
	<P ALIGN='RIGHT'>
	<FONT COLOR='gray' FACE="Comic Sans MS" size='-1'><I>
	<xsl:apply-templates/> 
	</I></FONT>
	</P>
</xsl:template>


<xsl:template match="BR">
	<BR/>
</xsl:template>

<xsl:template match="LIST">
	<UL>
	<xsl:apply-templates/> 
	</UL>
</xsl:template>


<xsl:template match="LI">
	<LI>
	<xsl:apply-templates/> 
	</LI>
</xsl:template>

<xsl:template match="I">
	<I>
		<xsl:apply-templates/>
	</I>
</xsl:template>

<xsl:template match="blink-it">
	<TABLE BORDER='0' CELLPADDING='0' CELLSPACING='0'><TR>
	<TD ALIGN="LEFT">  <IMG SRC='/images/new.gif'/></TD>
	<TD ALIGN="RIGHT"> <xsl:apply-templates/> </TD>
	</TR></TABLE>
</xsl:template>

<xsl:template match="beware">
	<P>
	<FONT color='red' FACE='ARIAL'>
		<xsl:apply-templates/>
	</FONT>
	</P>
</xsl:template>

</xsl:stylesheet>
