<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	version="1.0">

<xsl:include href="links.xsls"/>

<!-- body / para / li / quote / code / imp -->

<xsl:template match="/ux-doc">
	<HTML>
	<xsl:apply-templates/>
	</HTML>
</xsl:template>

<xsl:template match="body">
	<BODY bgcolor='white'>
	<BLOCKQUOTE>
	<BLOCKQUOTE>
	       <xsl:apply-templates/>
	</BLOCKQUOTE>
	</BLOCKQUOTE>
	</BODY>
</xsl:template>

<xsl:template match="p">
	<P>
	<xsl:copy-of select="@*"/>
	<FONT face="Arial" size="-1"><xsl:apply-templates/></FONT>
	</P>
</xsl:template>

<xsl:template match="li">
	<LI>
	<FONT face="Arial" size="-1"><xsl:apply-templates/></FONT>
	</LI>
</xsl:template>

<xsl:template match="q">
     	<P><I>
	   <FONT face="Arial" size="-1"><xsl:apply-templates/></FONT>
	</I></P>
</xsl:template>

<xsl:template match="code">
     	<P><I><CODE><xsl:apply-templates/></CODE></I></P>
</xsl:template>


<xsl:template match="imp">
     	<P><I>
	   <FONT face="Arial" size="-1" color='darkyellow'><xsl:apply-templates/></FONT>
	</I></P>
</xsl:template>

<xsl:template match="mark">
     	<B>
	   <FONT face="Arial" size="+1" color='red'>
	   <xsl:apply-templates/></FONT>
	</B>
</xsl:template>

<xsl:template match="smark">
	   <FONT size="-2"><xsl:apply-templates/></FONT>
</xsl:template>


<!--  Titles 	-->

<xsl:template match="body/title">
	<FONT face="Arial"><B><xsl:apply-templates/></B></FONT><BR/>
</xsl:template>


<xsl:template match="bigtitle">
	<P ALIGN='RIGHT'>
		<FONT face="Arial" size="+2" color='darkblue'>
			<B><xsl:apply-templates/></B>
		</FONT>
	<BR/>
	<HR WIDTH='100%' color='lightgrey'/>
	</P>
</xsl:template>

<!-- Some twists -->

<xsl:template match="see">

	<DL>
	<DT><FONT face="Arial" color="darkred"><B>See:</B></FONT></DT>

		<xsl:for-each select="class">
			<DD><FONT face='Arial' size='-1' color='darkblue'><I><xsl:value-of select="."/></I></FONT></DD>
		</xsl:for-each>

		<xsl:for-each select="ux-link">
			<UL><LI><xsl:apply-templates/></LI></UL>
		</xsl:for-each>

	</DL>
	<BR/><BR/>

</xsl:template>

<!-- History -->

<xsl:template match="version">

	<FONT face="Arial" size='-1'>
	<B> Version: 
	<xsl:value-of select="@ver"/>
	</B>
	<BR/>

	<I>
	<xsl:value-of select="@date"/>
	</I>
	</FONT>

	<BR/>

	<xsl:apply-templates/>
	<P ALIGN='CENTER'> * * * </P>

</xsl:template>


<xsl:template match="ux-sig">
	<P align="right">
		<I>
		<FONT color="lightgrey"  FACE="Comic Sans MS" size="-1">
		Paul Tchistopolskii.&#160;&#160;<BR/>
		<A HREF='http://www.pault.com' TARGET='_top'>http://www.pault.com</A>&#160;&#160;<BR/>
		<A HREF='mailto:paul@pault.com'>pault@pault.com</A>&#160;&#160;<BR/>		
		</FONT>
		</I>
	</P>
</xsl:template>


</xsl:stylesheet>

