package com.pault.tools;

import java.util.Date;
import java.util.StringTokenizer;
import java.io.*;
import java.util.Hashtable;

/**
 * Creation date: (9/5/00 5:49:31 PM)
 * @author: Paul Tchistopolskii
 */
public class HTTP {
	
		static public final String OK 			= "200";
		static public final String BAD_REQ 		= "400";
		static public final String FORBID		= "403";
		static public final String NOT_FOUND	= "404";
		static public final String INT_ERROR	= "500";
		static public final String NOT_IMPL		= "501";

		static Hashtable m_errors = new Hashtable();

		static {
				m_errors.put( OK, 			"OK" );
				m_errors.put( BAD_REQ, 		"Bad Request" );
				m_errors.put( FORBID, 		"Forbidden" );
				m_errors.put( NOT_FOUND, 	"Not Found" );
				m_errors.put( INT_ERROR, 	"Internal Error" );
				m_errors.put( NOT_IMPL, 	"Not Implemented" );
		}


static	public void CGICopyStream( BufferedReader ir , OutputStream os, Hashtable hdr) 
throws Exception {

		int cl= Integer.parseInt( 
					(String) hdr.get( "content-length:" )
				);
		
		if ( cl == 0 ) 
			throw new Exception( "Missing Content-Length: in POST" );

		int maxcl = 500000;

		char buf[] = new char[cl];

		int actual,already;
		actual = already = 0;

		while ( already != cl ) {
			actual = ir.read(buf, already, cl - already);
			already += actual;
		}
				
		System.err.println( 
			"Got: " + already + " " + actual + " bytes (" + cl + ")" );
		
		if ( cl > maxcl ) 
			throw new Exception( "Rejecting upload of " + cl + " bytes\n" +
								 "Only " + maxcl + " bytes are allowed\n" );

		BufferedWriter out =
				new BufferedWriter( new OutputStreamWriter(os) );

		out.write(buf,0,cl);
		out.flush();


		// System.err.println( "Got: " + cl + " bytes\n" + buf );
/*
		String ct = (String) hdr.get( "Content-Type:" );

		String bound = null;
		
		if ( ct.indexOf("boundary=") != -1 ) {
			bound = ct.substring( ct.lastIndexOf("=") + 1 );
			bound = "--" + bound + "--";
		}

		// Not multipart

		// if ( bound != null ) ir.readLine();

		if ( bound == null || true ) {
		
		System.err.println( new String(buf,0,cl) );
		} else {
			boolean done = false;
			// Skip opening boundry.
			
			ir.readLine();

			while ( !done ) {
				String l = ir.readLine();
				System.err.println( l );
				out.write( l + "\n" );
				done = l.equals(bound);
			}
		}

*/
}
static public String decode(String s) {

	StringBuffer sb = new StringBuffer();
	
	for (int i = 0; i < s.length(); i++) {
	    char c = s.charAt(i); 
	    switch (c) {
		    
	    case '+':	sb.append(' '); 	break;
	    case '%':
	    			try {
				  		  sb.append(
					   		 (char) Integer.parseInt
					   		 	(s.substring(i+1, i+3),16));
				    	  i += 2;
					} catch ( Exception e ) {
						return sb.toString();
					}
		
					break;
					
	    default:	sb.append(c);		break;
	    
	    }
	}
	return sb.toString();	
}

static public Hashtable ParseQueryString( String s ) {

	if (s == null) { return null;}

	Hashtable ht = new Hashtable();
	StringTokenizer st = new StringTokenizer(s, "&");

	while (st.hasMoreTokens()) {
	    String pair = (String)st.nextToken();
	    
	    int pos = pair.indexOf('=');
	
	    if (pos == -1) { continue; }

   	    String name = decode( pair.substring(0,pos) );
	    String value = decode( pair.substring(pos+1) );

	    // TODO, support crazy a=b, a=c. Later. 
	    ht.put( name, value);
	}
	
	return ( ht.size() > 0 ) ? ht : null ;
}
static public void SayError( String code, OutputStream os, String detail ) {

			String msg = (String) m_errors.get( code );

			try {

				os.write( 
					 ("HTTP/1.0 " + HTTP.OK + "\nContent-type: text/html\n\n" +
					  "<HTML><BODY><BR><I>Hiawatha v 0.1</I><BR>" +
					  "<FONT color='red'>" +
					  code + " : " + msg +
					  "</FONT>" + 
					  "<BR>" + detail +
					  "</BODY></HTML>\n").getBytes() 
				);

			} catch ( Exception e ) {

				// TODO. What to do? I think nothing.
				
			}
}
// TODO : Obsolete.

static private void SayRealHttpError( String code, OutputStream os, String detail ) {

	System.err.println( code + " : " + detail );
	try {
			os.write(("HTTP/1.0 " + code + "\n\n").getBytes());			
	} catch ( Exception e ) {
				// TODO. What to do? I think nothing.			
	}
}
static public void sendFile
   ( String file, OutputStream os, String mime ) 
	throws Exception {
			
		File inf = new File( file );
		int len = (int)inf.length();
			
		FileInputStream in = new FileInputStream( inf );	

		byte [] buf = new byte[len];
		
		in.read(buf);
		in.close();

		os.write( ("HTTP/1.0 " + HTTP.OK + "\nContent-type: " + mime + "\n\n").getBytes() );		
		os.write(buf);			

}
static public void sendHead
   ( OutputStream os ) 
	throws Exception {

	os.write( ("HTTP/1.0 " + HTTP.OK + 
		"\nLast-modified: " + new Date() + "\n\n").getBytes() );		
}
static public void sendMime
   ( OutputStream os, String mime ) 
	throws Exception {

	os.write( ("HTTP/1.0 " + HTTP.OK + "\nContent-type: " + mime + "\n\n").getBytes() );		
}
}
