package com.pault.tools;

import java.lang.reflect.*;
/**
	Simple Dumper, like perl Data:Dumper()
*/

public class Dumper {

public String dump() { return dump(this); }
public static String dump( Object  obj ) 

{
	return dump( obj, "" );
}
private static String dump( Object  obj, String indent ) 
{
	String out = indent;
	
	if ( obj == null ) return "NULL";

	// System.out.println("dump() got: " + obj.getClass().getName() );

	try {

		Class claz = obj.getClass();
		String typ = claz.getName();
	
		if ( typ.startsWith( "[" ) ) {
					return dump_array( obj, indent );
		}	

		if ( typ.startsWith( "java" ) ) {

			Method m = get_method_in_claz( claz, "toArray" );

			if ( m != null ) {
					return dump_array ( m.invoke( obj, null ), indent );
			}

			return typ;	
		}
	
	out += claz.getName() + " {\n" + indent;


	Field ff[] = claz.getFields();

//	System.out.println( "NFIELDS: " + ff.length );

	for ( int i = 0; i < ff.length; i++ ) {

		Field f = ff[i];
		
		String type = f.getType().getName();
		String name = f.getName();
		String val = null;

//		System.out.println("T: " + type);

			if ( type.equals( "int" ) ) {
				// System.out.println("int");
				val = Integer.toString(f.getInt( obj ));
			} else if ( type.equals( "boolean" ) ) {
				// System.out.println("boolean");
				val = new Boolean(f.getBoolean( obj )).toString();				
			} else if ( type.equals( "java.lang.String" ) ) {
				// System.out.println("string");
				String str = (String) f.get( obj );
				if ( str == null ) {
					str = "$UNINIT$";
				}
				val = "'" + str + "'";
			} else if ( type.startsWith( "[" ) ) { // array

				val = dump_array( f.get(obj), indent );
					
			} else {

				// System.out.println( "calling back!" + type);
				
				val = dump( f.get(obj), indent + "    " ); 
			}
		
			out += " " + name + " => " + val + "\n" + indent;
	}

	} catch ( Exception e ) {
			System.err.println("Dumper: ERR: " + e.toString() );
	}

	return out + "}\n"; 
}
private static String dump_array( Object  arr, String indent ) 
{
	if ( arr == null ) { return "[EMPTY]"; }

	String type = arr.getClass().getName().substring(1);

	// System.out.println( "dump_array GOT: " +  type );
	
	String ret = " [ ";

	for ( int i=0; i < Array.getLength(arr); i++ ) {

		if ( type.equals("I") ){
			ret += Array.getInt(arr,i);
		} else {
			ret += dump(Array.get(arr,i), indent);
		}

		if ( i < Array.getLength(arr)-1 ) { ret += ",";	}

	}
	
	return ret + " ] ";
}
private static Method get_method( Class claz, String mname ) {
/*
	Method m = get_method_in_claz( claz, mname );

	if ( m != null ) { return m; }
		
	Class[] all_claz = claz.getInterfaces( ); 

	for ( int i=0 ; i< all_claz.length; i++ ) {
			m = get_method( all_claz[i], mname );
			if ( m != null ) { return m; }			
	}

	Class parent_claz = claz.getSuperclass(); 

	if ( parent_claz == null ) { 
		System.out.println( claz.getName() + "HAS NO PARENT" );
		return null;			
	} 

	System.out.println( claz.getName() + "HAS PARENT: " + parent_claz.getName() );

	return get_method( parent_claz, mname );
*/
	return null;
}
private static Method get_method_in_claz( Class claz , String mname ) {

	// System.out.println( claz.getName() );
	
	Method mm[] = claz.getMethods( );
						
	for ( int i = 0; i < mm.length; i++ ) {
		Method m = mm[i];

		String name = m.getName();

		// System.out.println( name );

		if ( name.equals( mname ) && m.getParameterTypes( ).length == 0 ) {
			return m;
		}
	}

	return null;
}
}
