package com.pault.queue;

import java.net.InetAddress;
import java.util.Date;
import java.net.Socket;
import java.text.SimpleDateFormat;
/**
 * Creation date: (9/5/00 4:11:07 PM)
 * @author: Paul Tchistopolskii
 */
public class ELogEntry extends E {

private String code = "no code";
private Socket soc = null;
private String msg = "no message";
private int    wrkid = -1;

public ELogEntry
	( int a_wrkid, String a_code, Socket a_soc, String a_msg ) {

	wrkid = a_wrkid;
	code = a_code;
	soc  = a_soc;
	msg  = a_msg;
}
public String toString() {

	 String dat = new SimpleDateFormat("dd/MMM/yyyy:hh:mm:ss").format(new Date() );
	 // 04/Oct/2000:15:37:26 
	 String client = "";
	 
	 if ( soc != null ) {
		 InetAddress ia = soc.getInetAddress();
		 String name = ia.getHostName();
		 client = ( name == null ) ? ia.getHostAddress() : name;
	 }

	 if ( msg.indexOf("\n") != -1 ) {
		 msg = msg.substring( 0, msg.indexOf("\n") - 1 ) + "...";
	 }
	  
	 return client + " -- " +
	 		"[" +  dat + "]" + 
	 		" \""  + msg + "\"" + 
	 		" (" + code + ")" + 
	 		" <" + wrkid + ">" +
	 		"\n";

}
}
