package com.pault.hiawatha.benchmark;

import java.util.Date;
import java.io.InputStream;
import java.net.URL;
/**
 * Simple benchmarking of webserver.
 * Wrote this becaise I failed to find Apache Benchmark 
 * which could run on Windows.
 *
 * Creation date: (8/15/00 10:55:51 PM)
 * @author: Paul Tchistopolksii. http://www.pault.com
 *
 * Public Domain. 
 */
public class Jhb extends Thread {

		URL m_url 	= null;
		int m_n	  	= 0;
		int m_nreq  = 0;


		Jhb m_sync = null;
		private int NTR=0;

		private int NErrs=0;

		public Jhb(){}
public Jhb( URL url, int n, int nreq, Jhb sync ) {
	m_url = url;
	m_n = n;
	m_nreq = nreq;
	m_sync = sync;
}
public 	synchronized void decNTR( ) { NTR--; notifyAll(); }
public 	synchronized int getNTR( ) { return NTR; }
public 	synchronized void incNErrs( ) { NErrs++; }
public static void main(java.lang.String[] args) throws Exception {

		if ( args.length != 3 ) {
			System.err.println( "Usage: Jhb URL N-threads N-requests" );
			System.exit(1);
		}

		URL url 	  = new URL( args[0] );
		int nthreads  = Integer.parseInt(args[1]);
		int nrequests = Integer.parseInt(args[2]);

		Jhb tester = new Jhb();
		tester.test( url, nthreads, nrequests );			
}
public void run() {

				for ( int i = 0; i<m_nreq; i++ ) {
						System.out.println( m_n + "(" + i + ") " );
						// System.err.print(".");

						try { 
							java.net.URLConnection conn = m_url.openConnection();
							InputStream in = conn.getInputStream();
							int len = 0;
							int size = 0;
							byte [] bytes = new byte[1024];
							while ( ( len=in.read(bytes) ) >= 0 ) size += len ;
							System.out.println( m_n + "(" + i + ") = " + size + ". " );
						} catch ( Exception e ) {
							System.err.println(e);	
							m_sync.incNErrs();	
						}

				}	
											

				m_sync.decNTR();

}
public 	synchronized void setNTR( int n ) { NTR = n; }
public synchronized void test( URL url, int n, int nreq ) throws Exception {

		Date ds = new Date();
		int Start = 60 * ds.getMinutes() + ds.getSeconds();
		
		setNTR( n );
		
		for ( int i=1 ; i<= n; i++ ) {
				new Jhb( url, i, nreq, this ).start();
		}
		
		while ( getNTR()!= 0 ) wait();
		
		Date de = new Date();
		int End = 60 * de.getMinutes() + de.getSeconds();

		System.err.println("");
		System.err.println("***********************************************");
		System.err.println("Time: " + ( End - Start ) + " sec.");
		System.err.println("Req: " + ( nreq * n ) );
		System.err.println("Req/Sec: " + ( nreq * n ) / ( End - Start ) );
		System.err.println("Errors: " + NErrs );
		
}
}
