package com.pault.hiawatha;

import java.util.Hashtable;
import com.pault.queue.*;
import com.pault.config.*;
import com.pault.tools.*;

import java.util.Vector;
import java.io.*;
import java.net.*;

/**
 * Creation date: (8/20/00 8:31:35 PM)
 * @author: Paul Tchistopolskii
 */
 
class WorkerRequest extends Worker {
		private int		m_id = 0;			// Worker Id.
WorkerRequest( int id, Q q, CServer cfg) {
		super( q, cfg );
		m_id = id;
}
private void doGet( String url, OutputStream os ) throws Exception {
	
	Hashtable rule = m_cfg.findAppropriateRule( url );

	String oldurl = url;	
	if ( rule.get("#rewrite") != null ) {
		url = (String) rule.get("#rewrite");
	}	
	ERR.Say( "GET: '" + url + "'" + ": '" + oldurl + "'" );

	if ( rule == null ) {
		throw new HEx( HTTP.INT_ERROR, "No rule." );
	}

	new A( rule, url, null, os, null ).dispatchGetPost(); 
}
private void doHead( String url, OutputStream os ) throws Exception {
	
	Hashtable rule = m_cfg.findAppropriateRule( url );

	String oldurl = url;
	if ( rule.get("#rewrite") != null ) {
		url = (String) rule.get("#rewrite");
	}
	ERR.Say( "HEAD: '" + url + "'" + ": '" + oldurl + "'" );

	if ( rule == null ) {
		throw new HEx( HTTP.INT_ERROR, "No rule." );
	}

	new A( rule, url, null, os, null ).dispatchHead(); 
}
private void doPost(String url, BufferedReader ir, OutputStream os, Hashtable hdr) throws Exception {
	Hashtable rule = m_cfg.findAppropriateRule(url);
	String oldurl = url;
	if (rule.get("#rewrite") != null) {
		url = (String) rule.get("#rewrite");
	}
	ERR.Say("POST: '" + url + "'" + ": '" + oldurl + "'");
	if (rule == null) {
		throw new HEx(HTTP.INT_ERROR, "No rule.");
	}
	new A(rule, url, ir, os, hdr).dispatchGetPost();
}
private void process(InputStream is, OutputStream os, Socket soc) {
	Vector lines = new Vector();
	BufferedReader br = new BufferedReader(new InputStreamReader(is));
	try {
		boolean done = false;

		// TODO. Possible optimization - *don't* read the entire vector.

		while (!done) {
			String s = br.readLine();
			if (s == null) {
				s = "GET / HTTP fake";
				done = true;
				lines.addElement(s);
				continue;
			}
			done = (s.length() == 0);
			lines.addElement(s);
		}
	} catch (Exception e) {
		if (lines.size() == 0) {
			ERR.Error(m_id, HTTP.BAD_REQ, os, soc, "Bad Connection?");
			return;
		}
	}
	String fl = ((String) lines.elementAt(0));
	if (fl.indexOf("HTTP") != -1) {
		try {
			reload_config();
			processHTTP(lines, br, os);
			ERR.WriteLog(m_id, HTTP.OK, soc, fl);
		} catch (Exception e) {
			ERR.Error(m_id, HTTP.INT_ERROR, os, soc, e, fl);
		}
	} else {
		ERR.Error(m_id, HTTP.INT_ERROR, os, soc, "BAD: " + fl);
	}
}
private void processHTTP
	( Vector lines, BufferedReader ir, OutputStream os )
		throws Exception {

		String fl = (String) lines.elementAt(0);

		int sp = 0;						

		String url = fl.substring( 
						( sp = fl.indexOf(' ')+1 ), 
						fl.indexOf(' ', sp+1 ) );

		// Strip trailing '/' from any URL. But keep single '/'.

		if ( ! url.equals("/") ) {
			while ( url.length() > 1 && 
				url.substring( url.length()-1 ).equals("/") ) {
					url = url.substring( 0, url.length()-1 );
			}
		}

		Hashtable hdr = new Hashtable();
		
		for ( int i=0; i<lines.size(); i++ ){
			String l = (String) lines.elementAt(i);
			int spc = l.indexOf(" ");
			if ( spc > 0 ) {
				String key = l.substring( 0, spc ).toLowerCase();
				String value = l.substring( spc+1 );
				hdr.put( key, value );
			}
		}


		if ( fl.startsWith("GET") ) {
			doGet( url, os );		
		} else if ( fl.startsWith("POST") ) {
			doPost( url, ir, os, hdr );
		} else if ( fl.startsWith("HEAD") ) {
			doHead( url, os );
		} else {
			throw new HEx( HTTP.NOT_IMPL, fl );			
		}
}
public void run() {

	Socket sock = null;

	while ( (sock = ((ESocket)m_q.get()).socket) != null ) { // Wait

		InputStream is = null;
		OutputStream os = null;
				
		try {
			// System.err.println( "(" + m_id + ")" );
			is = sock.getInputStream();
			os = sock.getOutputStream();

			process( is, os, sock );
			
			is.close();
			os.flush();
			os.close();
			sock.close();
					
		} catch ( Exception e ) {
			System.err.println( "ERR: Worker : run : " + e.toString() );
			e.printStackTrace();
			try { 
				if ( is != null ) is.close();
				if ( os != null ) os.close();
				if ( sock != null ) sock.close();
			} catch ( Exception ex ) {
			}
		}	
	}			
}
}
