package com.pault.hiawatha;

import java.util.Hashtable;
import java.io.*;

import com.pault.queue.*;
import com.pault.config.*;

/**
 * Single Thread responsible for logging.
 * Creation date: (10/4/00 9:47:27 AM)
 * @author: Paul Tchistopolskii
 */
class WorkerLogger extends Worker {
	private FileWriter m_ow	 = null;
WorkerLogger( Q q, CServer cfg ) throws Exception {
	super( q, cfg );
	Hashtable log = cfg.GetLOG();
	if ( log != null ) {
		String file = (String) log.get( C.TEXT );
		m_ow = new FileWriter( file, true );
		System.err.println("Logging is on: " + file );
	} else {
		System.err.println("Logging is off" );
	}
}
// TODO. Not only file.
private void dumpEntry( ELogEntry e ) {

	if ( m_ow != null ) {
		try {
			String wrt = e.toString();
			m_ow.write( wrt, 0, wrt.length() );
			m_ow.flush();
		} catch ( Exception ex ) {
			System.err.println( "Error writing to logfile.");
			System.err.println( ex.toString() );
			try { m_ow.close(); } catch ( Exception ee ) {}
			m_ow = null;	
		}
	}
}
public void run() {

	ELogEntry e = null;
	
	while ( ( e = (ELogEntry) m_q.get() ) != null ) { // Wait

		try {
			dumpEntry( e );
		} catch ( Exception ex ) {
			System.err.println( "ERR: Logger : " + ex.toString() );
			m_ow = null;
		}
	}			
}
}
