package com.pault.hiawatha;

import com.pault.config.CServer;
import java.net.Socket;
import java.net.ServerSocket;

import com.pault.queue.*;
import com.pault.tools.*;

/**
 * Hiawatha webserver.
 * Creation date: (8/20/00 8:22:17 PM)
 * @author: Paul Tchistopolskii
 */
public class Server {
	
	private static String m_config;
	private static CServer m_cfg;

	private static int m_port;
	private static int m_nworkers;

private Server( String config ) {
	m_config = config;
}
private void init() throws Exception {
	
	m_cfg = new CServer( m_config );
	m_cfg.load();
	
	m_port = m_cfg.GetPORT();
	m_nworkers = m_cfg.GetWORKERS();
	
	SECURITY.setConfig( m_cfg );
	SPOOL.setSpoolDir( m_config, m_port );	
}
private synchronized void loop() {

	// General.

	System.err.println( "Server: forking " + m_nworkers + " workers." );
	System.err.println( "Reload config: " + m_cfg.GetRELOADCONFIG() );

	// Debugging.

	System.err.println( "Debug: " + m_cfg.GetDEBUG() );
	ERR.setDebug( m_cfg.GetDEBUG() );

	// Logger Queue.

	Q log_q = new Q();

	try {
		new WorkerLogger( log_q, m_cfg ).start();
	} catch ( Exception e ) {
		System.err.println( "ERR: Log Init " + e.toString() + " ... exiting ..."  );
		e.printStackTrace();
		System.exit(1);		
	}

	ERR.setLoggingQueue( log_q );
	
	// Requests Queue.
	
	Q q = new Q();
	
	// Fork request workers.
	
	for ( int i = 0; i < m_nworkers; i++ ) {
		new WorkerRequest( i, q, m_cfg ).start();
	}
	
	
	// Loop.
		
	try {

		System.err.println( "Server: listening on port: " + m_port );
		ServerSocket s = new ServerSocket( m_port );
				
		while ( true ) {
			q.put ( new ESocket ( s.accept() ) );
		}
				
	} catch ( Exception e ) {
		System.err.println( "ERR: Server (loop): " + e.toString() + " ... exiting... "  );
		e.printStackTrace();
		System.exit(1);
	}
			
}
/**
 */
public static void main(java.lang.String[] args) {
	String config = ( args.length > 0 ) ? args[0] : "server.cfg";
	Server srv = new Server( config );

	
	try {
		
		srv.init();
		srv.loop();
		
	} catch ( Exception e ){
		
		String err = SAX.SAXException2String( e );

		if ( err == null ) 
			System.err.println( e.toString() );
		else {
			System.err.println( err );
		}
		
		System.err.println( "Exiting." );

		// e.printStackTrace();
	}
}
}
