package com.pault.hiawatha;

import java.io.File;
import com.pault.tools.*;
/**
 * SPOOL directory. Used for Caching.
 * Creation date: (10/3/00 11:49:42 AM)
 * @author: Paul Tchistopolskii.
 */
class SPOOL {

	private static String dir = null;

static String calcSName( String url ) {
	return dir + "/" + url.replace( '/', '_' );
}
// Receives path to config. Calculates
// a path to SPOOL directory.

static void setSpoolDir( String cfg, int port ) throws Exception {

	if ( dir != null ) {
		throw new Exception( "SPOOL. Internal Error. dir is not null." );
	}

	dir = MISC.NormalizedDir( cfg ) + "SPOOL" + port;

	System.err.println( "Trying: " + dir );
	
	if ( ! new File( dir ).isDirectory() ) {
		
		dir = MISC.NormalizedDir( new File(".").getAbsolutePath() ) + "SPOOL" + port;
		System.err.println( "Trying: " + dir );

		if ( ! new File( dir ).isDirectory() ) {
				throw new Exception( "No SPOOL found." );	
		}
	}

	System.err.println("SPOOL found: " + dir );
	
}
}
