package com.pault.hiawatha;

import java.net.Socket;
import java.io.*;
import com.pault.tools.*;
import com.pault.queue.*;

/**
 * System-wide error processing and logging.
 * Creation date: (9/26/00 5:38:50 PM)
 * @author: Paul Tchistopolskii
 */
class ERR {
	private static boolean debug = false;
	private static Q log_q = null;
static void 
	Error( int wrkid, String code, OutputStream os, Socket soc, Exception e, String req ) {

	if ( e instanceof HEx && ((HEx)e).e != null ) {
		Error( wrkid, code, os, soc, ((HEx)e).e, req );
		return;	
	}

	if ( e instanceof HEx ) {
		code = 	((HEx)e).code;
		String err = ((HEx)e).detail;
		Error( wrkid, code, os, soc, req + " " + err );
		return;
	}

	Error( wrkid, code, os, soc, req + " " + SAX.SAXException2String( e ) );
	e.printStackTrace();		
}
static void 
	Error( int wrkid, String code, OutputStream os, Socket soc, String detail ) {
		
	HTTP.SayError( code, os, detail );
	System.err.println( "<" + wrkid + "> " + code + " : " + detail );
	WriteLog( wrkid, code, soc, detail );
}
static void Say( String s ) {
	if ( debug )  { System.err.println( s ); }
}
static void setDebug( boolean d ) {
	debug = d;
}
static void setLoggingQueue( Q a_logq ) {
	log_q = a_logq;
}
static void WriteLog( int wrkid, String code, Socket soc, String msg ) {
	log_q.put( new ELogEntry( wrkid, code, soc, msg ) );
}
}
