package com.pault.hiawatha;

import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.*;
import com.icl.saxon.trax.*;
import java.io.*;
import java.util.Hashtable;
import com.pault.tools.*;

/**
 * Invoking XSL engine.
 * Creation date: (10/2/00 4:30:16 PM)
 * @author: Paul Tchistopolskii
 */
class AXSL {

 String url 	 		= null;
 String xsl 	 		= null;
 String xml 	 		= null;
 String q 	 			= null;
 OutputStream os 		= null; 
 InputStreamReader ir	= null;
 String mime			= null;

 // Dependencies.
  // .xsl -> array of .xsl 'include' and 'import'.
 // TODO support those weird SYSTEM entities 
 // for the .xml source? only if somebody
 // will ask. 
 
static Hashtable  m_deps = new Hashtable();

AXSL( String a_url, String a_xsl, String a_xml, String a_q, 
	  			OutputStream a_os, InputStreamReader a_ir,
	  			String a_mime ) {
	

	if ( new File( a_xsl ).exists() ) {
		xsl = a_xsl;
	} else if ( new File( a_xsl + ".xsls" ).exists() ) {
		xsl = a_xsl + ".xsls";
	} else if ( new File( a_xsl + ".xsl" ).exists() ) {
		xsl = a_xsl + ".xsl";
	}

	if ( new File( a_xml ).exists() ) {
		xml = a_xml;
	}
	
	q = a_q;
	os = a_os;
	ir = a_ir;
	mime = a_mime;
	url = a_url;
} 
// Collect dependencies of .xsl

private static synchronized void collectDep( String xsl ) throws HEx {

	try {

		AXSLdepsCollector coll = new AXSLdepsCollector( xsl );
		
		XMLReader r = SAX.CreateXMLReader();
		r.setContentHandler( coll );
		InputSource is = SAX.source( xsl );
		r.parse( is );

		Vector deps = coll.getResults();

		if ( deps == null ) return; 

		// O! there *are*  dependencies.
		
		m_deps.put(xsl, deps );	
		
		for ( int i=0; i<deps.size(); i++ ) {
			collectDep( (String) deps.elementAt(i) );
		}
		
	} catch ( Exception e ) {
		throw new HEx( HTTP.INT_ERROR, e );
	}

		
}
// TODO. Provide a configuration parameter
// that will disable this checking? Dunno.
// It is fast enough.


private boolean needToGenerate( String sname ) {

	  	 File spooled = new File( sname );
		 long spl_lm = spooled.lastModified();

		 // System.err.println("sname: " + sname + ":" + spl_lm );
		 
		 if ( youngestDep( xsl, 0 ) > spl_lm ) return true;
		 if ( new File(xml).lastModified()> spl_lm ) return true;
		 return false;
}
void run() throws Exception {

 FileWriter res	= null;
 
 try {
	
	if ( ! SECURITY.CHK( xml ) ) {
		throw new HEx( HTTP.NOT_FOUND, "Can't access XML file." );	
	}

	if ( ! SECURITY.CHK( xsl ) ) {
		throw new HEx( HTTP.NOT_FOUND,"Can't access XSL file." );
	}

	// It smells like cgi. Always regenerate. TODO - change this.
		
	if ( q != null && q.length() != 0 ) {
			ERR.Say( "re-generating:" + xsl + " " + xml + " " + q);
			HTTP.sendMime( os, mime );
			transform( new Result( os ) );
			return;		
	}

	// Not cgi.
	
	String sname = SPOOL.calcSName( url );
	
	if ( needToGenerate( sname ) ) {
		
		ERR.Say( "re-generating:" + sname );

		collectDep( xsl );
		
		res = new FileWriter( sname );
		transform( new Result( res ) );
		res.close();
	}
	
	HTTP.sendFile( sname, os, mime );
 } catch ( Exception e ) {
	if ( res != null ) {
		res.close();
	}
	throw e;
 }
 
}
private void setQueryParameters( Transformer trans ) {
	
	ERR.Say( "REQUEST_URI: " + url );
	trans.setParameter( "REQUEST_URI", null,  url );

	Hashtable h = HTTP.ParseQueryString( q );
	if ( h==null ) return;

	Enumeration e = h.keys( );

	while ( e.hasMoreElements() ) {
		String key = (String ) e.nextElement();
		trans.setParameter( key, null,  h.get ( key ) );
	}

}
private void transform( Result rez ) throws Exception {
	Processor processor = Processor.newInstance("xslt");
	processor.setXMLReader( SAX.CreateXMLReader() );
	
	Templates templates = processor.process(SAX.source( xsl ));
	
	Transformer transformer = templates.newTransformer();
	transformer.setXMLReader( SAX.CreateXMLReader() );
	
	setQueryParameters( transformer );
	
	transformer.transform( SAX.source( xml ), rez  );
}
private long youngestDep( String xsl, long cur ) {

	long mtime = new File( xsl ).lastModified();
	long youngest = ( mtime > cur ) ? mtime : cur;

	Vector deps = (Vector) m_deps.get( xsl );

	if ( deps == null ) return youngest;

	for ( int i=0; i<deps.size(); i++ ) {
		String child = ( String) deps.elementAt(i);
		long childy  = youngestDep( child, youngest );
		youngest = ( childy > youngest ) ? childy : youngest;
	}

	return youngest;
}
}
