package com.pault.hiawatha;

import java.util.Vector;
import java.io.*;
import java.util.Hashtable;
import com.pault.tools.*;
import com.pault.config.*;

/**
 * Actions Dispatcher.
 * Creation date: (9/20/00 7:06:16 PM)
 * @author: Paul Tchistopolskii
 */
class A {

	private Hashtable 		r  	  = null;
	private String 			url   = null;
	private BufferedReader 	ir 	  = null;
	private OutputStream 	os    = null;
	private Hashtable		hdr   = null;

A( Hashtable rule, String a_url, BufferedReader a_ir, OutputStream a_os, Hashtable a_hdr ) {
		r = rule;
		url = a_url;
		ir = a_ir;
		os = a_os;
		hdr = a_hdr;
}
void dispatchGetPost() throws HEx {

	String action = (String) r.get("action");

	if ( action.equals("#dump") ) {
		do_dump_get();
		return;
	} 

	if ( action.equals("#cgi") ) {
		if ( ir == null ) {
			do_cgi_get();
		} else {
			do_cgi_post();			
		}
		return;
	} 

	if ( action.equals("#xsl") ) {
		if ( ir == null ) {
			do_xsl_get();
		} else {
			do_xsl_post();			
		}
		return;
	}
		
	throw new HEx( HTTP.INT_ERROR, "Bad action: '" + action + "'" );
}
void dispatchHead() throws HEx {

	// TODO - implement.
	// Actually HEAD is not implemented at all.
	// Always says it was modified, not matter what it was.
	// The format of last-modified is incorrect, i think. E t.c.
	
	try {
		HTTP.sendHead( os );
	} catch ( Exception e ) {
		throw new HEx( HTTP.INT_ERROR, e.toString());
	}
	
}
private void do_cgi_get() throws HEx {
	
	String file  = (String) r.get( C.TEXT  );
	String query = (String) r.get( "param" );

	if ( query.startsWith("?") ) query = query.substring( 1 );

	ERR.Say( "Serving GET: " + file + " Q: " + query);

	if ( ! SECURITY.CHK( file ) ) {
		throw new HEx( HTTP.FORBID, url );
	}

	String intr = null;
	
	try {
		intr = MISC.GetInterpreter( file );	
	} catch ( Exception e ) {
		System.err.println( e.toString() );
		throw new HEx( HTTP.NOT_FOUND, "File not found." );
	}

	if ( intr == null ) {
		throw new HEx( HTTP.NOT_IMPL, "Only !# cgi's are supported." );
	}

	String to_exec = intr + " " + file;
	ERR.Say( "Executing: '" + to_exec + "'" );

	Process proc = null;
	
	try {
		
		Hashtable e = new Hashtable();
		e.put( "QUERY_STRING", query );
		e.put( "REQUEST_METHOD", "GET" );
		e.put( "REQUEST_URI", url );
			
		proc = Runtime.getRuntime().exec( to_exec, MISC.HtoArray( e ) );

		os.write( ("HTTP/1.0 " + HTTP.OK + "\n").getBytes() );
		MISC.CopyStream( proc.getInputStream(), os );
		String err = MISC.ReadStream( proc.getErrorStream() );

		proc.waitFor() ;

		if ( proc.exitValue() != 0 || err.length() != 0) {
			throw new HEx( HTTP.INT_ERROR, "Failed to execute.\n" + err );			
		}
		
	} catch ( Exception e ) {
		if ( proc != null ) { proc.destroy(); }
		throw new HEx( HTTP.INT_ERROR, e );
	}

}
private void do_cgi_post() throws HEx{

	String file  = (String) r.get( C.TEXT  );

	ERR.Say( "Serving POST: " + file );

	if ( ! SECURITY.CHK( file ) ) {
		throw new HEx( HTTP.FORBID, url );
	}

	String intr = null;
	
	try {
		intr = MISC.GetInterpreter( file );	
	} catch ( Exception e ) {
		System.err.println( e.toString() );
		throw new HEx( HTTP.NOT_FOUND, "File not found.");
	}

	if ( intr == null ) {
		throw new HEx( HTTP.NOT_IMPL, "Only !# cgi's are supported." );
	}

	String to_exec = intr + " " + file;
	ERR.Say( "Executing: '" + to_exec + "'" );

	Process proc = null;
	
	try {
		
		Hashtable e = new Hashtable();
		e.put( "REQUEST_METHOD", "POST" );
		e.put( "REQUEST_URI", url );

		String type = (String) hdr.get( "content-type:" );
		if ( type != null ) {
			e.put( "CONTENT_TYPE", type );
		}
		
		String len = (String) hdr.get( "content-length:" );
		if ( len != null ) {
			e.put( "CONTENT_LENGTH", len );
		}
	
		// System.err.println( hdr.toString() );
		
		proc = Runtime.getRuntime().exec( to_exec, MISC.HtoArray( e ) );
		HTTP.CGICopyStream( ir, proc.getOutputStream(), hdr );

		os.write( ("HTTP/1.0 " + HTTP.OK + "\n").getBytes() );
		MISC.CopyStream( proc.getInputStream(), os );

		String err = MISC.ReadStream( proc.getErrorStream() );
		
		proc.waitFor() ;

		if ( proc.exitValue() != 0 || err.length() != 0 ) {
			throw new HEx( HTTP.INT_ERROR, "Failed to execute.\n" + err );
		}

	} catch ( Exception e ) {
		if ( proc != null ) { proc.destroy(); }
		throw new HEx( HTTP.INT_ERROR, e );
	}

}
private void do_dump_get() throws HEx{
	
	String mime = (String) r.get("mime");
	if ( mime == null )	mime = "text/plain";

	String file = (String) r.get( C.TEXT );

	ERR.Say( "Serving: " + file + " mime: " + mime );

	if ( ! SECURITY.CHK( file ) ) {
		throw new HEx( HTTP.FORBID, url );
	}

	try {
		HTTP.sendFile( file, os, mime );
	} catch ( Exception e ) {
		throw new HEx( HTTP.NOT_FOUND, "Page not found.");
	}
}
private void do_xsl_get() throws HEx{
	
	String cmd  = (String) r.get( C.TEXT  );
	String query = (String) r.get( "param" );
	if ( query == null ) query ="";

	String mime = (String) r.get("mime");
	if ( mime == null )	mime = "text/html";

	int sep = cmd.indexOf(" ");
	String xsl = cmd.substring( 0, sep );
	String xml = cmd.substring( sep+1 );

	if ( query.startsWith("?") ) query = query.substring( 1 );

	ERR.Say( "Serving XSL GET : " +
			 "XSL: " + xsl + " XML: " + xml + 
			 " Q: '" + query + "'" + " mime: "  + mime );

	try {
		new AXSL( url, xsl, xml, query, os, null, mime ).run();
	} catch ( Exception e ) {
		throw new HEx( HTTP.INT_ERROR, e );
	}

}
private void do_xsl_post() throws HEx {

	throw new HEx( HTTP.NOT_IMPL, "XSL POST is not implemented yet" );

	// TODO.
/*		
	String cmd  = (String) r.get( C.TEXT  );
	String query = (String) r.get( "param" );

	String mime = (String) r.get("mime");
	if ( mime == null )	mime = "text/html";

	int sep = cmd.indexOf(" ");
	String xsl = cmd.substring( 0, sep );
	String xml = cmd.substring( sep+1 );

	if ( query.startsWith("?") ) query = query.substring( 1 );

	ERR.Say( "Serving XSL GET : " +
			 "XSL: " + xsl + " XML: " + xml + " Q: " + query);

	try {
//		new AXSL( xsl, xml, HTTP.ParseQuery(query), os, null, mime ).run();
	} catch ( Exception e ) {
//		ERR.Error( HTTP.INT_ERROR, os, e );
	}
*/
}
}
