package com.pault.config;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Enumeration;
import com.pault.atoms.*;
import com.pault.tools.*;
import java.util.Vector;
import java.util.Hashtable;
import com.pault.atoms.Pair;

/**
 * Hiawatha Server Config.
 * Creation date: (9/18/00 2:11:57 PM)
 * @author: Paul Tchistopolskii
 */
 
public class CServer extends C {
	static Pair [] schema = {
		new Pair( "config", 			C.SKIP 		),
		new Pair( "CONST", 				"name"  	),
		new Pair( "RULE",   			C.ARRAY		),
		new Pair( "PERM",   			C.ARRAY		),
		new Pair( "PORT",   			C.TEXT		),
		new Pair( "DEBUG",   			C.TEXT		),
		new Pair( "WORKERS",   			C.TEXT		),
		new Pair( "RELOAD-CONFIG",   	C.TEXT		),
		new Pair( "LOG",   				C.NAME		),
	};

	private Hashtable rulecache = new Hashtable();
public CServer( String a_filename ) {
	super( schema , a_filename);
}
public boolean findAppropriatePerm( String a_file )
	throws Exception
{
	String file = MISC.NormalizePath( a_file );
	
	if( file.indexOf("..") != -1) {
	    return false;
	}

	Vector perms = getArray( "PERM" );

	for ( int i=0; i < perms.size(); i++ ) {

		Hashtable perm = ( Hashtable) perms.elementAt(i);
		String pref = (String) perm.get( "prefix" );
		String acc  = (String) perm.get( "access" );

		if ( file.startsWith( pref ) ) {
				return acc.equals( "#allow" );		
		} 
	}

	System.err.println( "No PERM for file: '" + file + "'" );
	return false;
}
// TODO. Maybe remove rules caching. Dunno.

public Hashtable findAppropriateRule( String url )
	throws Exception
{
	// System.err.println( "Finding rule for: '" + url +"'" );

	Hashtable crule = ( Hashtable ) rulecache.get( url );
	if ( crule != null ) return crule;
	
	Vector rules = getArray( "RULE" );

	for ( int i=0; i<rules.size(); i++ ) {

		Hashtable rule = ( Hashtable) rules.elementAt(i);
		Vector res = new Re( url,  (String) rule.get("url") ).match();
		
		if ( res != null ) { // Rule found.
				Hashtable nrule = (Hashtable) rule.clone();
				String etext = 
					resolveVariablesAndConstans( (String) nrule.get( C.TEXT ), res );

				nrule.put( C.TEXT, etext );

				String action = (String) nrule.get("action");

				boolean rewriting = false;
					
				if ( action.equals("#rewrite") ) {
					// System.err.println( "Rewriting to: '" + etext + "'");
					rewriting = true;
					nrule = findAppropriateRule( etext );
					nrule.put( "#rewrite", etext );
				}
				
				
				if ( (String) nrule.get( "param" ) != null ) {
					String eparam = 
						resolveVariablesAndConstans( (String) nrule.get( "param" ), res );
					nrule.put( "param", eparam );

				}

				if ( nrule.get( "param" ) == null && ! rewriting ) { // OK to cache.
					// System.err.println( "C:" + url );
					rulecache.put( url, nrule );
				}

				return nrule;
			
		} 
	} 
	return null;
}
public boolean GetDEBUG() {
	return ( getTxt("DEBUG") != null 
			 && getTxt("DEBUG").equals("true") ) ? true : false;
}
public Hashtable GetLOG() {
	return getGrove("LOG");	
}
public int GetPORT() throws Exception {
	return Integer.parseInt( getTxtEx("PORT") );
}
public boolean GetRELOADCONFIG() {
	return ( getTxt("RELOAD-CONFIG") != null 
			 && getTxt("RELOAD-CONFIG").equals("true") ) ? true : false;
}
public int GetWORKERS() throws Exception {
	return Integer.parseInt( getTxtEx("WORKERS") );
}
public synchronized boolean load() throws Exception {
	boolean reloaded = super.load();
	if ( reloaded ) {
			Vector perms = getArray( "PERM" );
			for ( int i=0; i<perms.size(); i++ ) {
				Hashtable perm = ( Hashtable) perms.elementAt(i);
				String eprefix = 
					resolveVariablesAndConstans( (String) perm.get( "prefix" ), null );
				perm.put( "prefix", eprefix );
			}

			Hashtable log = getGrove( "LOG" );

			if ( log != null ) {
				String elog = 
					resolveVariablesAndConstans
						( (String) log.get( C.TEXT ), null );

				log.put( C.TEXT, elog );
			
				putGrove( "LOG", log );
			}
				
			rulecache.clear();
		
	}
	return reloaded;
}
/** Testing.
 */
public static void main(java.lang.String[] args) {
	
	CServer cfg = new CServer("sample.cfg" );

	try { 
		cfg.load();
	} catch ( Exception e ) {

		String err = SAX.SAXException2String( e );

		if ( err == null ) 
			System.err.println( e.toString() );
		else {
			System.err.println( err );
		}

		e.printStackTrace();
	}

	System.err.println( cfg.getTxt( "PORT" ) );
	System.err.println( cfg.getGrove( "CONST", "DOCROOT" ).get("value") );

	Vector arr = cfg.getArray( "RULE" );

	for ( int i=0; i<arr.size(); i++ ) {
		System.err.println(  (( Hashtable) arr.elementAt(i)) .get("url") );
	}
		

}
public String resolveVariablesAndConstans( String text, Vector revars )
	throws Exception
{
	//System.err.println( "Resolving: '" + text + "'" );

	if ( text == null ) {
		throw new Exception ("ERR. Empty RULE in the config file!");		
	}
	
	try {
		
		Enumeration tokens = new StringTokenizer( text , "$", true );

		String etext = "";	// Expanded text.

		while ( tokens.hasMoreElements() ) {
				String t = (String) tokens.nextElement();
				if ( t.equals( "$" ) ) {
					String var  = (String) tokens.nextElement();
					String closet = (String) tokens.nextElement();

					if ( var.equals("$") || !closet.equals("$") ) {
						throw new Exception ("VARIABLE SYNTAX ERR: " + text + " near '" + var + "'");
					}
										
					if ( Character.isDigit( var.charAt(0) ) ) { // Resolve from regexpr.
						etext += revars.elementAt( Integer.parseInt(var) );
					} else { 									// resolve from CONSTants.
						String cnst = (String) getGroveEx( "CONST", var ).get(C.TEXT);
						if ( cnst != null ) etext += cnst;
					}
				} else {
					etext += t;
				} 
		}

		// System.err.println( "Resolved to: " + etext );		
		return etext;
		
	} catch ( Exception e ) {
		throw new Exception ("VARIABLE ERR: " + text );
	}
}
}
