package com.pault.config;

import java.net.URL;
import java.util.Enumeration;
import com.pault.atoms.*;
import com.pault.tools.*;
import org.xml.sax.*;
import java.io.File;
import java.io.FileReader;

import java.util.Hashtable;
import java.util.Vector;

/**
 * Universal XML config.
 * Creation date: (9/7/00 1:09:19 PM)
 * @author: Paul Tchistopolskii
 */
 
public class C extends org.xml.sax.helpers.DefaultHandler {

	private Hashtable h_schema = new Hashtable();
	private String filename = null;
	private long lastmodified = 0;

	// Schema constants.
	
	static public final String SKIP  =  "#skip";
	static public final String ARRAY =  "#array";
	static public final String TEXT   = "#text";
	static public final String NAME   = "#name";

	private Locator 	locator  	= null;

	// Current element. ( Grove ).
	private Hashtable	cur		 	= null;

	// Entire document. ( DOM ).
	private Hashtable 	dom 		= null;

public C ( Pair[] schema, String a_filename ) {

	for ( int i=0; i < schema.length; i++ ) {
		h_schema.put( schema[i].name, schema[i].value );
	}
	
	filename = a_filename;		
}
public	void characters(char[] ch, int start, int length) {
	String accum = new String ( ch, start, length ).trim();
	if ( cur != null && accum.length() != 0 ) {
		// System.err.println( "Remembering: " + accum );
		cur.put( C.TEXT, accum );
	}
}
public void endElement (String uri, String _name, String qName)
	throws SAXParseException
{
	// System.err.println( qName + ">" );

	String action = (String) h_schema.get( qName );

	if ( action == null ) {
		throw new SAXParseException( "Internal error: '" + qName + "'", locator );
	}
	
	if ( action.equals( C.SKIP   ) ) { return; }

	if ( action.equals( C.TEXT  ) ) {
		dom.put( qName, cur.get( C.TEXT ) );
		cur = null;
		return;
	}

	if ( action.equals( C.ARRAY  ) ) {
		Vector arr = ( Vector ) dom.get( qName );

		// If no vector yet - create it. TODO. Speedup. 
		// Convert this vector to array ( in 'endDocument' );
		
		if ( arr == null ) {
			arr = new Vector();
			dom.put( qName, arr );
		}

		arr.addElement(cur);
		return;
	}

	// Use the name of the element as a key of grove.

	if ( action.equals( C.NAME  ) ) {
		putGrove( qName, cur );
		return;
	}
	
	// Default processing. 'Action' equals to name of 'key-property'.

	putGrove( qName, action, cur );
}
public Vector getArray( String elem ) {
	return ( Vector ) dom.get( elem );
}
public Hashtable getGrove( String elem ) {
	return (Hashtable) dom.get( elem );
}
public Hashtable getGrove( String elem, String key ) {
	return (Hashtable) dom.get( elem + key );
}
public Hashtable getGroveEx( String elem, String key ) 
	throws Exception {
	Hashtable ret = (Hashtable) dom.get( elem + key );
	if ( ret == null ) {
			throw new Exception( "ERR: '" + elem + ":" + key + "' is not defined in " + filename );
	} else 
			return ret;
}
public String getTxt( String elem ) {
	return (String) dom.get( elem );
}
public String getTxtEx( String elem ) throws Exception {
	String ret = getTxt( elem );
	if ( ret == null ) 
		throw new Exception( "ERR: '" + elem + "' is not defined in " + filename );
	else 
		return ret;
}
protected synchronized boolean load() throws Exception {

	String path = new File( filename ).getAbsolutePath();
	long lastmod =  new File( path ).lastModified();

	if ( lastmod == 0 ) {
			System.err.println( "ERR: '" + path + "' does not exist! " );
	}
	
	if ( lastmodified == 0 || lastmod != lastmodified ) {
			dom = new Hashtable();
			
			System.err.println( "Reloading: " + path );
			
			XMLReader r = SAX.CreateXMLReader();
			r.setContentHandler( this );

			InputSource is = SAX.source( path );
			
			r.parse( is );		
			lastmodified = lastmod;
			return true;
	}

	return false;
}
// TODO. Experimental. Not yet public.

private void 
	putGrove( String elem, String keyprop, Hashtable grove ) {
		dom.put( elem + grove.get( keyprop ), grove );
}
// TODO Experimental. Not yet public.

protected void 
	putGrove( String elem, Hashtable grove ) {
		dom.put( elem, grove );
}
public void setDocumentLocator(Locator a_locator) { locator = a_locator; }
public void startElement (String uri, String _name, String qName, Attributes attrs) 
	throws SAXParseException
{
	// System.err.println( "<" + qName );
	
	String action = (String) h_schema.get( qName );

	if ( action == null ) { 
		throw new SAXParseException( "Element : '" + qName + "' - not allowed", locator );
	}
	
	if ( action.equals( C.SKIP  ) ) { return; }

	// TEXT, ordinary element or array of ordinary elements.
	
	cur = new Hashtable();

	for (int j = 0; j < attrs.getLength (); j++) {
		cur.put( attrs.getLocalName(j), attrs.getValue (j) );
	}

}
}
