/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLText
extends StyleElement {
    private boolean disable = false;
    private String value = null;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"disable-output-escaping"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("disable-output-escaping");
        if (string != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                throw this.styleError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws SAXException {
        this.checkNotTopLevel();
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof ElementInfo) {
                throw this.styleError("xsl:text must not have any child elements");
            }
            node = node.getNextSibling();
        }
    }

    public void process(Context context) throws SAXException {
        if (this.value == null) {
            this.value = this.getValue();
        }
        if (!this.value.equals("")) {
            Outputter outputter = context.getOutputter();
            if (this.disable) {
                outputter.setEscaping(false);
                outputter.writeContent(this.value);
                outputter.setEscaping(true);
            } else {
                outputter.writeContent(this.value);
            }
        }
    }
}

