/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeListExpression;
import com.icl.saxon.expr.SortedSelection;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StyleSheetFunctionCall;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.output.TextFragment;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StyleException;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLParam;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.style.XSLVariable;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.ElementWithAttributes;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator,
StaticContext {
    protected Vector attributeSets = null;
    private Vector extensionNamespaces = new Vector();
    private Vector excludedNamespaces = new Vector();
    protected String version = null;

    public void substituteFor(StyleElement styleElement) throws SAXException {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.fullName = styleElement.fullName;
        this.sequence = styleElement.sequence;
        this.attributeSets = styleElement.attributeSets;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
    }

    public boolean isInstruction() {
        return false;
    }

    public int getPrecedence() throws SAXException {
        return ((XSLStyleSheet)this.getDocumentElement()).getPrecedence();
    }

    public void processAllAttributes() throws SAXException {
        this.processAttributes();
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).processAllAttributes();
            }
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
    }

    public final void processAttributes() throws SAXException {
        try {
            this.prepareAttributes();
        }
        catch (SAXException sAXException) {
            throw this.styleError(sAXException);
        }
    }

    public void allowAttributes(String[] stringArray) throws SAXException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string = stringArray[n4];
            int n5 = string.hashCode();
            n |= 1 << n5 % 31;
            n2 |= 1 << n5 % 29;
            n3 |= 1 << n5 % 23;
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.attributeList.getLength()) {
            String string = this.attributeList.getName(n6);
            if (string.indexOf(58) < 0) {
                int n7 = string.hashCode();
                int n8 = 1 << n7 % 31;
                int n9 = 1 << n7 % 29;
                int n10 = 1 << n7 % 23;
                if ((n & n8) != n8 || (n2 & n9) != n9 || (n3 & n10) != n10) {
                    throw this.styleError("Attribute " + string + " is not allowed on this element");
                }
            }
            ++n6;
        }
    }

    public abstract void prepareAttributes() throws SAXException;

    public boolean requiresXSLprefix() {
        return false;
    }

    protected void processExtensionElementAttribute() throws SAXException {
        String string;
        Object object;
        if (this.requiresXSLprefix()) {
            object = new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "extension-element-prefixes");
            string = this.getAttributeValue((Name)object);
        } else {
            string = this.getAttributeValue("extension-element-prefixes");
        }
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                String string3 = string2.equals("#default") ? "" : this.getURIforPrefix(string2);
                this.extensionNamespaces.addElement(string3);
            }
        }
    }

    protected void processExcludedNamespaces() throws SAXException {
        String string;
        Object object;
        if (this.requiresXSLprefix()) {
            object = new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
            string = this.getAttributeValue((Name)object);
        } else {
            string = this.getAttributeValue("exclude-result-prefixes");
        }
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                String string3 = string2.equals("#default") ? this.getURIforPrefix("") : this.getURIforPrefix(string2);
                this.excludedNamespaces.addElement(string3);
            }
        }
    }

    protected void processVersionAttribute() throws SAXException {
        if (this.requiresXSLprefix()) {
            Name name = new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "version");
            this.version = this.getAttributeValue(name);
        } else {
            this.version = this.getAttributeValue("version");
        }
    }

    public String getVersion() throws SAXException {
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() throws SAXException {
        if (this.version == null) {
            NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
            if (nodeInfo instanceof StyleElement) {
                return ((StyleElement)nodeInfo).forwardsCompatibleModeIsEnabled();
            }
            return true;
        }
        return !this.version.equals("1.0");
    }

    protected boolean definesExtensionElement(String string) throws SAXException {
        return this.extensionNamespaces.indexOf(string) >= 0;
    }

    public boolean isExtensionNamespace(String string) throws SAXException {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(string)) {
                return true;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(String string) throws SAXException {
        return this.excludedNamespaces.indexOf(string) >= 0;
    }

    public boolean isExcludedNamespace(String string) throws SAXException {
        if (this.isExtensionNamespace(string)) {
            return true;
        }
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(string)) {
                return true;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        return false;
    }

    public void validate() throws SAXException {
    }

    public void preprocess() throws SAXException {
    }

    public void validateSubtree() throws SAXException {
        try {
            this.validate();
        }
        catch (SAXException sAXException) {
            throw this.styleError(sAXException);
        }
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).validateSubtree();
            }
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
    }

    protected XSLStyleSheet getPrincipalStyleSheet() throws SAXException {
        XSLStyleSheet xSLStyleSheet = (XSLStyleSheet)this.getDocumentElement();
        XSLStyleSheet xSLStyleSheet2;
        while ((xSLStyleSheet2 = xSLStyleSheet.getImporter()) != null) {
            xSLStyleSheet = xSLStyleSheet2;
        }
        return xSLStyleSheet;
    }

    protected PreparedStyleSheet getPreparedStyleSheet() throws SAXException {
        return this.getPrincipalStyleSheet().getPreparedStyleSheet();
    }

    public void checkWithinTemplate() throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
        while (nodeInfo != null) {
            if (nodeInfo instanceof XSLTemplate) {
                return;
            }
            if (nodeInfo instanceof XSLVariable) {
                return;
            }
            if (nodeInfo instanceof XSLParam) {
                return;
            }
            if (nodeInfo instanceof SAXONFunction) {
                return;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        throw this.styleError("Element must only be used within a template");
    }

    public void checkTopLevel() throws SAXException {
        if (!(this.getParentNode() instanceof XSLStyleSheet)) {
            throw this.styleError("Element must only be used at top level of stylesheet");
        }
    }

    public void checkNotTopLevel() throws SAXException {
        if (this.getParentNode() instanceof XSLStyleSheet) {
            throw this.styleError("Element must not be used at top level of stylesheet");
        }
    }

    public void checkEmpty() throws SAXException {
        if (this.getFirstChild() != null) {
            throw this.styleError("Element must be empty");
        }
    }

    public void reportAbsence(String string) throws SAXException {
        throw this.styleError("Element must have a \"" + string + "\" attribute");
    }

    public abstract void process(Context var1) throws SAXException;

    public void processChildren(Context context) throws SAXException {
        if (context.getController().isTracing()) {
            TraceListener traceListener = context.getController().getTraceListener();
            NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
            while (nodeInfo != null) {
                traceListener.enter(nodeInfo, context);
                if (nodeInfo instanceof TextInfo) {
                    nodeInfo.copy(context.getOutputter());
                } else if (nodeInfo instanceof StyleElement) {
                    StyleElement styleElement = (StyleElement)nodeInfo;
                    try {
                        styleElement.process(context);
                    }
                    catch (SAXException sAXException) {
                        throw styleElement.styleError(sAXException);
                    }
                }
                traceListener.leave(nodeInfo, context);
                nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
            }
        } else {
            NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
            while (nodeInfo != null) {
                if (nodeInfo instanceof TextInfo) {
                    nodeInfo.copy(context.getOutputter());
                } else if (nodeInfo instanceof StyleElement) {
                    StyleElement styleElement = (StyleElement)nodeInfo;
                    try {
                        styleElement.process(context);
                    }
                    catch (SAXException sAXException) {
                        throw styleElement.styleError(sAXException);
                    }
                }
                nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
            }
        }
    }

    private void processX(Context context) throws SAXException {
        System.err.println("Processing " + context.getCurrentNode() + " using " + this);
        this.process(context);
    }

    protected Expression handleSortKeys(Expression expression) throws SAXException {
        SortedSelection sortedSelection = null;
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof XSLSort) {
                if (sortedSelection == null) {
                    sortedSelection = new SortedSelection(expression);
                }
                sortedSelection.addSortKey(((XSLSort)node).getSortKeyDefinition());
            }
            node = node.getNextSibling();
        }
        if (sortedSelection == null) {
            return new NodeListExpression(expression);
        }
        return sortedSelection;
    }

    public String expandChildren(Context context) throws SAXException {
        Controller controller = context.getController();
        TextFragment textFragment = new TextFragment();
        controller.setNewOutputDetails(textFragment);
        this.processChildren(context);
        controller.resetOutputDetails();
        return textFragment.getText();
    }

    protected void findAttributeSets(String string) throws SAXException {
        this.attributeSets = new Vector();
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = new Name(string2, this, false).getAbsoluteName();
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                XSLAttributeSet xSLAttributeSet;
                String string4;
                if (vector.elementAt(n) instanceof XSLAttributeSet && (string4 = (xSLAttributeSet = (XSLAttributeSet)vector.elementAt(n)).getAttributeSetName()) != null && string4.equals(string3)) {
                    this.attributeSets.addElement(xSLAttributeSet);
                    bl = true;
                }
                ++n;
            }
            if (bl) continue;
            throw this.styleError("No attribute-set exists named " + string2);
        }
    }

    protected void processAttributeSets(Context context) throws SAXException {
        if (this.attributeSets == null) {
            return;
        }
        int n = 0;
        while (n < this.attributeSets.size()) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)this.attributeSets.elementAt(n);
            xSLAttributeSet.expand(context);
            ++n;
        }
    }

    protected SAXException styleError(SAXException sAXException) {
        if (sAXException instanceof StyleException) {
            return sAXException;
        }
        if (sAXException.getException() != null) {
            return new StyleException(sAXException.getException(), this.positionMessage(sAXException.getMessage()));
        }
        return new StyleException(sAXException, this.positionMessage(sAXException.getMessage()));
    }

    protected SAXException styleError(String string) {
        return new StyleException(this.positionMessage(string));
    }

    private String positionMessage(String string) {
        String string2 = this.getDisplayName();
        if (string2.equals("")) {
            string2 = "element";
        }
        String string3 = this.getSystemId();
        return "At " + string2 + (string3 == null ? "" : " on line " + this.getLineNumber() + " of " + string3) + ": " + string;
    }

    public boolean isTopLevel() throws SAXException {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public Binding bindVariable(String string) throws SAXException {
        Binding binding = this.getVariableBinding(string);
        if (binding == null) {
            throw this.styleError("Variable " + string + " has not been declared");
        }
        return binding;
    }

    public Binding getVariableBinding(String string) throws SAXException {
        Object object;
        block5: {
            NodeInfo nodeInfo = this;
            NodeInfo nodeInfo2 = this;
            if (!this.isTopLevel()) {
                do {
                    nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
                    while (nodeInfo == null) {
                        nodeInfo = (NodeInfo)nodeInfo2.getParentNode();
                        nodeInfo2 = nodeInfo;
                        if (nodeInfo.getParentNode() instanceof XSLStyleSheet) break;
                        nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
                    }
                    if (nodeInfo.getParentNode() instanceof XSLStyleSheet) break block5;
                } while (!(nodeInfo instanceof Binding) || !((String)(object = ((Binding)((Object)nodeInfo)).getVariableName())).equals(string));
                return (Binding)((Object)nodeInfo);
            }
        }
        object = this.getPrincipalStyleSheet();
        Vector vector = ((XSLStyleSheet)object).getTopLevel();
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2;
            Object e = vector.elementAt(n);
            if (e instanceof Binding && e != this && (string2 = ((Binding)e).getVariableName()).equals(string)) {
                return (Binding)e;
            }
            --n;
        }
        return null;
    }

    public Enumeration[] getVariableNames() throws SAXException {
        Object object;
        Object object2;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2 = this;
        if (!this.isTopLevel()) {
            while (true) {
                nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
                while (nodeInfo == null) {
                    nodeInfo = (NodeInfo)nodeInfo2.getParentNode();
                    nodeInfo2 = nodeInfo;
                    if (nodeInfo.getParentNode() instanceof XSLStyleSheet) break;
                    nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
                }
                if (nodeInfo.getParentNode() instanceof XSLStyleSheet) break;
                if (!(nodeInfo instanceof Binding) || hashtable.get(object2 = ((Binding)((Object)nodeInfo)).getVariableName()) != null) continue;
                hashtable.put(object2, object2);
            }
        }
        object2 = this.getPrincipalStyleSheet();
        Vector vector = ((XSLStyleSheet)object2).getTopLevel();
        int n = 0;
        while (n < vector.size()) {
            String string;
            object = vector.elementAt(n);
            if (object instanceof Binding && object != this && hashtable.get(string = ((Binding)object).getVariableName()) == null) {
                hashtable2.put(string, string);
            }
            ++n;
        }
        object = new Enumeration[]{hashtable2.keys(), hashtable.keys()};
        return object;
    }

    public Function getStyleSheetFunction(Name name) throws SAXException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        int n = vector.size() - 1;
        while (n >= 0) {
            Object e = vector.elementAt(n);
            if (e instanceof SAXONFunction && ((SAXONFunction)e).getFunctionName().equals(name)) {
                StyleSheetFunctionCall styleSheetFunctionCall = new StyleSheetFunctionCall();
                styleSheetFunctionCall.setFunction((SAXONFunction)e);
                return styleSheetFunctionCall;
            }
            --n;
        }
        return null;
    }
}

