/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class SAXONPreview
extends StyleElement {
    String previewMode = null;
    String elements = null;

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"mode", "elements"};
        this.allowAttributes(stringArray);
        this.previewMode = this.attributeList.getValue("mode");
        if (this.previewMode == null) {
            this.reportAbsence("mode");
        }
        this.elements = this.attributeList.getValue("elements");
        if (this.elements == null) {
            this.reportAbsence("elements");
        }
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
    }

    public void preprocess() throws SAXException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        PreviewManager previewManager = xSLStyleSheet.getPreviewManager();
        if (previewManager == null) {
            previewManager = new PreviewManager();
            xSLStyleSheet.setPreviewManager(previewManager);
        }
        previewManager.setPreviewMode(this.previewMode);
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            previewManager.setPreviewElement(new Name(string, this, true));
        }
    }

    public void process(Context context) throws SAXException {
    }
}

