/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import org.xml.sax.SAXException;

public class UnionPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeType = 0;

    public UnionPattern(Pattern pattern, Pattern pattern2) {
        this.p1 = pattern;
        this.p2 = pattern2;
        if (pattern.getType() == pattern2.getType()) {
            this.nodeType = pattern.getType();
        }
    }

    public Pattern simplify() throws SAXException {
        return new UnionPattern(this.p1.simplify(), this.p2.simplify());
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws SAXException {
        return this.p1.matches(nodeInfo, context) || this.p2.matches(nodeInfo, context);
    }

    public int getType() {
        return this.nodeType;
    }

    public String toString() {
        return "(" + this.p1.toString() + " | " + this.p2.toString() + ")";
    }

    public boolean isRelative() throws SAXException {
        return this.p1.isRelative() || this.p2.isRelative();
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }
}

