/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.sort.HashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;

public class HTMLEmitter
extends XMLEmitter {
    static HashMap emptyTags = new HashMap(101);
    private static HashMap booleanAttributes;
    private static HashMap booleanCombinations;
    private static HashMap urlAttributes;
    private static HashMap urlCombinations;
    private static String[] latin1Entities;

    private static void setEmptyTag(String string) {
        emptyTags.set(string);
    }

    protected static boolean isEmptyTag(String string) {
        return emptyTags.get(string);
    }

    private static void setBooleanAttribute(String string, String string2) {
        booleanAttributes.set(string2);
        booleanCombinations.set(string + "+" + string2);
    }

    private static boolean isBooleanAttribute(String string, String string2, String string3) {
        if (!string2.equalsIgnoreCase(string3)) {
            return false;
        }
        if (!booleanAttributes.get(string2)) {
            return false;
        }
        return booleanCombinations.get(string + "+" + string2);
    }

    private static void setUrlAttribute(String string, String string2) {
        urlAttributes.set(string2);
        urlCombinations.set(string + "+" + string2);
    }

    public static boolean isUrlAttribute(String string, String string2) {
        if (!urlAttributes.get(string2)) {
            return false;
        }
        return urlCombinations.get(string + "+" + string2);
    }

    public void startDocument() throws SAXException {
        if (this.outputDetails.getMediaType() == null) {
            this.outputDetails.setMediaType("text/html");
        }
        String string = this.outputDetails.getDoctypeSystem();
        String string2 = this.outputDetails.getDoctypePublic();
        if (string != null || string2 != null) {
            this.writeDocType("html", string, string2);
        }
        this.empty = false;
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        String string = name.getLocalName();
        if (string.equalsIgnoreCase("script") || string.equalsIgnoreCase("style")) {
            this.setEscaping(false);
        }
        super.startElement(name, attributeCollection);
        this.closeStartTag("", false);
        if (string.equalsIgnoreCase("head") && this.outputDetails.getIncludeHtmlMetaTag()) {
            String string2;
            String string3 = this.outputDetails.getMediaType();
            if (string3 == null) {
                string3 = "text/html";
            }
            if ((string2 = this.outputDetails.getEncoding()) == null) {
                string2 = "utf-8";
            }
            AttributeCollection attributeCollection2 = new AttributeCollection();
            attributeCollection2.addAttribute(new Name("http-equiv"), "CDATA", "Content-Type");
            attributeCollection2.addAttribute(new Name("content"), "CDATA", string3 + "; charset=" + string2);
            try {
                this.writer.write("\n      ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Name name2 = new Name("", "", "meta");
            this.startElement(name2, attributeCollection2);
            this.endElement(name2);
            try {
                this.writer.write("\n   ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void writeAttribute(String string, String string2, String string3, String string4) throws SAXException {
        try {
            if (HTMLEmitter.isBooleanAttribute(string, string2, string4)) {
                this.testCharacters(string2);
                this.writer.write(string2);
            } else if (HTMLEmitter.isUrlAttribute(string, string2) && !string3.equals("NO-ESC")) {
                String string5 = HTMLEmitter.escapeURL(string4);
                super.writeAttribute(string, string2, string3, string5);
            } else {
                super.writeAttribute(string, string2, string3, string4);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void writeEscape(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3 = n;
        boolean[] blArray = bl ? XMLEmitter.specialInAtt : XMLEmitter.specialInText;
        while (n3 < n + n2) {
            int n4;
            block18: {
                block20: {
                    block25: {
                        block21: {
                            block24: {
                                block23: {
                                    block22: {
                                        block19: {
                                            boolean bl2;
                                            n4 = n3;
                                            boolean bl3 = true;
                                            do {
                                                if (!bl3 || (bl3 = false) || !true) {
                                                    ++n4;
                                                }
                                                if (n4 >= n + n2) break;
                                                if (cArray[n4] < '\u0080') {
                                                    if (!blArray[cArray[n4]]) {
                                                        bl2 = true;
                                                        continue;
                                                    }
                                                    bl2 = false;
                                                    continue;
                                                }
                                                bl2 = cArray[n4] > '\u00ff' && this.characterSet.inCharset(cArray[n4]);
                                            } while (bl2);
                                            this.writer.write(cArray, n3, n4 - n3);
                                            if (n4 == n + n2) {
                                                return;
                                            }
                                            if (cArray[n4] < '\u00a0' || cArray[n4] > '\u00ff') break block19;
                                            this.writer.write(38);
                                            this.writer.write(latin1Entities[cArray[n4] - 160]);
                                            this.writer.write(59);
                                            break block18;
                                        }
                                        if (cArray[n4] >= '\u007f') break block20;
                                        if (!bl) break block21;
                                        if (cArray[n4] != '<') break block22;
                                        this.writer.write(60);
                                        break block18;
                                    }
                                    if (cArray[n4] != '>') break block23;
                                    this.writer.write("&gt;");
                                    break block18;
                                }
                                if (cArray[n4] != '&') break block24;
                                if (n4 + 1 < n + n2 && cArray[n4 + 1] == '{') {
                                    this.writer.write(38);
                                    break block18;
                                } else {
                                    this.writer.write("&amp;");
                                }
                                break block18;
                            }
                            if (cArray[n4] == '\"') {
                                this.writer.write("&#34;");
                                break block18;
                            } else if (cArray[n4] == '\n') {
                                this.writer.write("&#xA;");
                            }
                            break block18;
                        }
                        if (cArray[n4] != '<') break block25;
                        this.writer.write("&lt;");
                        break block18;
                    }
                    if (cArray[n4] == '>') {
                        this.writer.write(62);
                        break block18;
                    } else if (cArray[n4] == '&') {
                        this.writer.write("&amp;");
                    }
                    break block18;
                }
                if (cArray[n4] >= '\ud800' && cArray[n4] <= '\udbff') {
                    int n5 = (cArray[n4] - 55296) * 1024 + (cArray[n4 + 1] - 56320) + 65536;
                    this.outputCharacterReference(n5);
                    ++n4;
                } else if (this.characterSet.inCharset(cArray[n4])) {
                    this.writer.write(cArray[n4]);
                } else {
                    this.outputCharacterReference(cArray[n4]);
                }
            }
            n3 = ++n4;
        }
    }

    public void endElement(Name name) throws SAXException {
        String string = name.getLocalName();
        this.setEscaping(true);
        if (!HTMLEmitter.isEmptyTag(string)) {
            super.endElement(name);
        } else {
            this.unwindNamespaces();
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(32);
            this.writer.write(string2);
            this.writer.write(62);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private static String escapeURL(String string) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "0123456789ABCDEF";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '!' || c > '~') {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                    ((OutputStreamWriter)object).write(c);
                    ((OutputStreamWriter)object).close();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SAXException(unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
                object = byteArrayOutputStream.toByteArray();
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    Object object2 = object[n2] >= 0 ? object[n2] : (Object)(256 + object[n2]);
                    stringBuffer.append('%');
                    stringBuffer.append(string2.charAt((int)(object2 / 16)));
                    stringBuffer.append(string2.charAt((int)(object2 % 16)));
                    ++n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HashMap(101);
        booleanCombinations = new HashMap(203);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
        urlAttributes = new HashMap(101);
        urlCombinations = new HashMap(203);
        HTMLEmitter.setUrlAttribute("form", "action");
        HTMLEmitter.setUrlAttribute("body", "background");
        HTMLEmitter.setUrlAttribute("q", "cite");
        HTMLEmitter.setUrlAttribute("blockquote", "cite");
        HTMLEmitter.setUrlAttribute("del", "cite");
        HTMLEmitter.setUrlAttribute("ins", "cite");
        HTMLEmitter.setUrlAttribute("object", "classid");
        HTMLEmitter.setUrlAttribute("object", "codebase");
        HTMLEmitter.setUrlAttribute("applet", "codebase");
        HTMLEmitter.setUrlAttribute("object", "data");
        HTMLEmitter.setUrlAttribute("a", "href");
        HTMLEmitter.setUrlAttribute("a", "name");
        HTMLEmitter.setUrlAttribute("area", "href");
        HTMLEmitter.setUrlAttribute("link", "href");
        HTMLEmitter.setUrlAttribute("base", "href");
        HTMLEmitter.setUrlAttribute("img", "longdesc");
        HTMLEmitter.setUrlAttribute("frame", "longdesc");
        HTMLEmitter.setUrlAttribute("iframe", "longdesc");
        HTMLEmitter.setUrlAttribute("head", "profile");
        HTMLEmitter.setUrlAttribute("script", "src");
        HTMLEmitter.setUrlAttribute("input", "src");
        HTMLEmitter.setUrlAttribute("frame", "src");
        HTMLEmitter.setUrlAttribute("iframe", "src");
        HTMLEmitter.setUrlAttribute("img", "src");
        HTMLEmitter.setUrlAttribute("img", "usemap");
        HTMLEmitter.setUrlAttribute("input", "usemap");
        HTMLEmitter.setUrlAttribute("object", "usemap");
        latin1Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

